/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.feature.Features;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.Interpolator;
import org.apache.maven.internal.transformation.impl.TransformerSupport;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.installation.InstallRequest;

@Singleton
@Named
class PomInlinerTransformer
extends TransformerSupport {
    private final Interpolator interpolator;

    @Inject
    PomInlinerTransformer(Interpolator interpolator) {
        this.interpolator = Objects.requireNonNull(interpolator);
    }

    @Override
    public InstallRequest remapInstallArtifacts(RepositorySystemSession session, InstallRequest request) {
        return request.setArtifacts(this.replacePom(session, request.getArtifacts()));
    }

    @Override
    public DeployRequest remapDeployArtifacts(RepositorySystemSession session, DeployRequest request) {
        return request.setArtifacts(this.replacePom(session, request.getArtifacts()));
    }

    private Collection<Artifact> replacePom(RepositorySystemSession session, Collection<Artifact> artifacts) {
        Set<String> needsInlining = this.needsInlining(session);
        if (needsInlining.isEmpty()) {
            return artifacts;
        }
        ArrayList<Artifact> newArtifacts = new ArrayList<Artifact>(artifacts.size());
        for (Artifact artifact : artifacts) {
            if ("pom".equals(artifact.getExtension()) && artifact.getClassifier().isEmpty()) {
                try {
                    Path tmpPom = Files.createTempFile("pom-inliner-", ".xml", new FileAttribute[0]);
                    String originalPom = Files.readString(artifact.getPath());
                    String interpolatedPom = this.interpolator.interpolate(originalPom, property -> {
                        if (needsInlining.contains(property)) {
                            return (String)session.getConfigProperties().get(property);
                        }
                        return null;
                    }, false);
                    if (!Objects.equals(originalPom, interpolatedPom)) {
                        Files.writeString(tmpPom, (CharSequence)interpolatedPom, new OpenOption[0]);
                        artifact = artifact.setPath(tmpPom);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            newArtifacts.add(artifact);
        }
        return newArtifacts;
    }

    private Set<String> needsInlining(RepositorySystemSession session) {
        return (Set)session.getData().computeIfAbsent((Object)(PomInlinerTransformer.class.getName() + ".needsInlining"), ConcurrentHashMap::newKeySet);
    }

    @Override
    public void injectTransformedArtifacts(RepositorySystemSession session, MavenProject project) throws IOException {
        if (!Features.consumerPom((Map)session.getConfigProperties())) {
            try {
                Model model = this.read(project.getFile().toPath());
                String version = model.getVersion();
                if (version == null && model.getParent() != null) {
                    version = model.getParent().getVersion();
                }
                if (version != null) {
                    HashSet usedProperties = new HashSet();
                    String newVersion = this.interpolator.interpolate(version.trim(), property -> {
                        if (!session.getConfigProperties().containsKey(property)) {
                            throw new IllegalArgumentException("Cannot inline property " + property);
                        }
                        usedProperties.add(property);
                        return (String)session.getConfigProperties().get(property);
                    });
                    if (!Objects.equals(version, newVersion)) {
                        this.needsInlining(session).addAll(usedProperties);
                    }
                }
            }
            catch (XMLStreamException e) {
                throw new IOException("Problem during inlining POM", e);
            }
        }
    }
}

