/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.amazons3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.amazons3.S3Artifact;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.crawler.connectors.amazons3.AmazonS3DocumentProcessUtility;
import org.apache.manifoldcf.crawler.connectors.amazons3.DocumentProcess;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.system.Logging;

public class GenericDocumentProcess
extends AmazonS3DocumentProcessUtility
implements DocumentProcess {
    private static final String TEXT_PLAIN = "text/plain";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doProcessDocument(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority, AmazonS3 amazons3Client) throws ManifoldCFException, ServiceInterruption {
        if (amazons3Client == null) {
            throw new ManifoldCFException("Amazon client can not connect at the moment");
        }
        for (String documentIdentifier : documentIdentifiers) {
            try {
                if (documentIdentifier == null || StringUtils.isEmpty((String)documentIdentifier)) {
                    Logging.connectors.warn((Object)"Document identifier is empty, document will not be processed");
                    continue;
                }
                if (documentIdentifier.split(",") == null && documentIdentifier.length() < 1) continue;
                S3Artifact s3Artifact = this.getS3Artifact(documentIdentifier);
                S3Object s3Obj = amazons3Client.getObject(new GetObjectRequest(s3Artifact.getBucketName(), s3Artifact.getKey()));
                if (s3Obj == null) {
                    activities.deleteDocument(documentIdentifier);
                    continue;
                }
                Logging.connectors.info((Object)("Content-Type: " + s3Obj.getObjectMetadata().getContentType()));
                ObjectMetadata objectMetadata = s3Obj.getObjectMetadata();
                Date lastModified = objectMetadata.getLastModified();
                StringBuilder sb = new StringBuilder();
                if (lastModified == null) {
                    activities.deleteDocument(documentIdentifier);
                    continue;
                }
                String[] aclsToUse = new String[]{};
                AccessControlList objectAcl = amazons3Client.getObjectAcl(s3Artifact.getBucketName(), s3Artifact.getKey());
                Set grants = objectAcl.getGrants();
                String[] users = this.getUsers(grants);
                aclsToUse = users;
                sb.append(lastModified.toString());
                String versionString = sb.toString();
                Logging.connectors.debug((Object)("version string : " + versionString));
                if (versionString.length() > 0 && !activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) {
                    Logging.connectors.info((Object)("Document need not to be reindexed : " + documentIdentifier));
                    continue;
                }
                Logging.connectors.debug((Object)("JIRA: Processing document identifier '" + documentIdentifier + "'"));
                long startTime = System.currentTimeMillis();
                String errorCode = null;
                String errorDesc = null;
                Long fileSize = null;
                String mimeType = TEXT_PLAIN;
                long fileLength = s3Obj.getObjectMetadata().getContentLength();
                if (!activities.checkLengthIndexable(fileLength)) {
                    errorCode = "EXCLUDEDLENGTH";
                    errorDesc = "Excluded because of document length (" + fileLength + ")";
                    activities.noDocument(documentIdentifier, versionString);
                    continue;
                }
                String documentURI = this.getDocumentURI(s3Artifact);
                Logging.connectors.debug((Object)("document : " + documentURI));
                if (!activities.checkURLIndexable(documentURI)) {
                    errorCode = "EXCLUDEDURL";
                    errorDesc = "Excluded because of URL ('" + documentURI + "')";
                    activities.noDocument(documentIdentifier, versionString);
                    continue;
                }
                if (!activities.checkMimeTypeIndexable(mimeType)) {
                    errorCode = "EXCLUDEDMIMETYPE";
                    errorDesc = "Excluded because of mime type ('" + mimeType + "')";
                    activities.noDocument(documentIdentifier, versionString);
                    continue;
                }
                if (!activities.checkDateIndexable(lastModified)) {
                    errorCode = "EXCLUDEDDATE";
                    errorDesc = "Excluded because of date (" + lastModified + ")";
                    activities.noDocument(documentIdentifier, versionString);
                    continue;
                }
                S3ObjectInputStream in = null;
                try {
                    in = s3Obj.getObjectContent();
                    RepositoryDocument rd = new RepositoryDocument();
                    this.addRawMetadata(rd, objectMetadata);
                    String[] denyAclsToUse = aclsToUse.length > 0 ? new String[]{"DEAD_AUTHORITY"} : new String[]{};
                    rd.setSecurity("document", aclsToUse, denyAclsToUse);
                    rd.setMimeType(mimeType);
                    if (lastModified != null) {
                        rd.setModifiedDate(lastModified);
                    }
                    rd.setBinary((InputStream)in, fileLength);
                    activities.ingestDocumentWithException(documentIdentifier, versionString, documentURI, rd);
                    errorCode = "OK";
                    fileSize = new Long(fileLength);
                }
                catch (IOException e1) {
                    GenericDocumentProcess.handleIOException(e1);
                }
                finally {
                    if (in != null) {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
            }
            catch (AmazonServiceException e) {
                GenericDocumentProcess.handleServiceException(e);
            }
            catch (AmazonClientException e) {
                GenericDocumentProcess.handleClientException(e);
            }
        }
    }

    protected static void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        Logging.connectors.error((Object)"Error while copying stream", (Throwable)e);
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
    }

    protected static void handleServiceException(AmazonServiceException e) throws ManifoldCFException, ServiceInterruption {
        Logging.connectors.error((Object)("Service exception status : " + e.getStatusCode()), (Throwable)e);
        if (!e.isRetryable()) {
            throw new ManifoldCFException("Amazon service exception: " + e.getMessage(), e.getCause());
        }
        throw new ServiceInterruption(e.getMessage(), System.currentTimeMillis() + 300000L);
    }

    protected static void handleClientException(AmazonClientException e) throws ManifoldCFException, ServiceInterruption {
        Logging.connectors.error((Object)e);
        if (!e.isRetryable()) {
            throw new ManifoldCFException("Amazon client exception: " + e.getMessage(), e.getCause());
        }
        throw new ServiceInterruption(e.getMessage(), System.currentTimeMillis() + 300000L);
    }
}

