/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpi;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AclServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.DiscoveryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.MultiFilingServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.NavigationServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.ObjectServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.PolicyServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.RelationshipServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.RepositoryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.RepositoryUrlCache;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.VersioningServiceImpl;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.MultiFilingService;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisBrowserBindingSpi
implements CmisSpi {
    private static final Logger LOG = LoggerFactory.getLogger(CmisBrowserBindingSpi.class);
    private final BindingSession session;
    private final RepositoryService repositoryService;
    private final NavigationService navigationService;
    private final ObjectService objectService;
    private final VersioningService versioningService;
    private final DiscoveryService discoveryService;
    private final MultiFilingService multiFilingService;
    private final RelationshipService relationshipService;
    private final PolicyService policyService;
    private final AclService aclService;

    public CmisBrowserBindingSpi(BindingSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session {}: Initializing Browser Binding SPI...", (Object)session.getSessionId());
        }
        this.session = session;
        this.repositoryService = new RepositoryServiceImpl(session);
        this.navigationService = new NavigationServiceImpl(session);
        this.objectService = new ObjectServiceImpl(session);
        this.versioningService = new VersioningServiceImpl(session);
        this.discoveryService = new DiscoveryServiceImpl(session);
        this.multiFilingService = new MultiFilingServiceImpl(session);
        this.relationshipService = new RelationshipServiceImpl(session);
        this.policyService = new PolicyServiceImpl(session);
        this.aclService = new AclServiceImpl(session);
    }

    @Override
    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    @Override
    public NavigationService getNavigationService() {
        return this.navigationService;
    }

    @Override
    public ObjectService getObjectService() {
        return this.objectService;
    }

    @Override
    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    @Override
    public RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    @Override
    public MultiFilingService getMultiFilingService() {
        return this.multiFilingService;
    }

    @Override
    public AclService getAclService() {
        return this.aclService;
    }

    @Override
    public PolicyService getPolicyService() {
        return this.policyService;
    }

    @Override
    public void clearAllCaches() {
        this.session.remove("org.apache.chemistry.opencmis.binding.browser.repositoryurls");
    }

    @Override
    public void clearRepositoryCache(String repositoryId) {
        RepositoryUrlCache repUrlCache = (RepositoryUrlCache)this.session.get("org.apache.chemistry.opencmis.binding.browser.repositoryurls");
        if (repUrlCache != null) {
            repUrlCache.removeRepository(repositoryId);
        }
    }

    @Override
    public void close() {
    }
}

