/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.constraint;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.constraint.DefaultConstraints;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.constraint.LegalConstraints;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.util.InternationalString;

@XmlType(name="MD_LegalConstraints_Type", propOrder={"accessConstraints", "useConstraints", "otherConstraints"})
@XmlRootElement(name="MD_LegalConstraints")
public class DefaultLegalConstraints
extends DefaultConstraints
implements LegalConstraints {
    private static final long serialVersionUID = -228007779747439839L;
    private Collection<Restriction> accessConstraints;
    private Collection<Restriction> useConstraints;
    private Collection<InternationalString> otherConstraints;

    public DefaultLegalConstraints() {
    }

    public DefaultLegalConstraints(CharSequence charSequence) {
        super(charSequence);
    }

    public DefaultLegalConstraints(LegalConstraints legalConstraints) {
        super((Constraints)legalConstraints);
        if (legalConstraints != null) {
            this.accessConstraints = this.copyCollection(legalConstraints.getAccessConstraints(), Restriction.class);
            this.useConstraints = this.copyCollection(legalConstraints.getUseConstraints(), Restriction.class);
            this.otherConstraints = this.copyCollection(legalConstraints.getOtherConstraints(), InternationalString.class);
        }
    }

    public static DefaultLegalConstraints castOrCopy(LegalConstraints legalConstraints) {
        if (legalConstraints == null || legalConstraints instanceof DefaultLegalConstraints) {
            return (DefaultLegalConstraints)legalConstraints;
        }
        return new DefaultLegalConstraints(legalConstraints);
    }

    @XmlElement(name="accessConstraints")
    public Collection<Restriction> getAccessConstraints() {
        this.accessConstraints = this.nonNullCollection(this.accessConstraints, Restriction.class);
        return this.accessConstraints;
    }

    public void setAccessConstraints(Collection<? extends Restriction> collection) {
        this.accessConstraints = this.writeCollection(collection, this.accessConstraints, Restriction.class);
    }

    @XmlElement(name="useConstraints")
    public Collection<Restriction> getUseConstraints() {
        this.useConstraints = this.nonNullCollection(this.useConstraints, Restriction.class);
        return this.useConstraints;
    }

    public void setUseConstraints(Collection<? extends Restriction> collection) {
        this.useConstraints = this.writeCollection(collection, this.useConstraints, Restriction.class);
    }

    @XmlElement(name="otherConstraints")
    public Collection<InternationalString> getOtherConstraints() {
        this.otherConstraints = this.nonNullCollection(this.otherConstraints, InternationalString.class);
        return this.otherConstraints;
    }

    public void setOtherConstraints(Collection<? extends InternationalString> collection) {
        this.otherConstraints = this.writeCollection(collection, this.otherConstraints, InternationalString.class);
    }
}

