/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.DummyLessSource;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.ast.VariableDeclaration;
import com.github.sommeri.less4j.core.compiler.LessToCssCompiler;
import com.github.sommeri.less4j.core.parser.ANTLRParser;
import com.github.sommeri.less4j.core.parser.ASTBuilder;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.GeneralProblem;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.core.problems.UnableToFinish;
import com.github.sommeri.less4j.utils.CssPrinter;
import com.github.sommeri.less4j.utils.PrintUtils;
import com.github.sommeri.less4j.utils.URIUtils;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThreadUnsafeLessCompiler
implements LessCompiler {
    private ProblemsHandler problemsHandler;
    private ASTBuilder astBuilder;
    private LessToCssCompiler compiler;
    private ANTLRParser parser = new ANTLRParser();

    @Override
    public LessCompiler.CompilationResult compile(String lessContent) throws Less4jException {
        return this.compile(new LessSource.StringSource(lessContent), null);
    }

    @Override
    public LessCompiler.CompilationResult compile(String lessContent, LessCompiler.Configuration options) throws Less4jException {
        return this.compile(new LessSource.StringSource(lessContent), options);
    }

    @Override
    public LessCompiler.CompilationResult compile(File lessFile) throws Less4jException {
        LessSource.FileSource lessSource = new LessSource.FileSource(lessFile);
        return this.compile(lessSource, null);
    }

    @Override
    public LessCompiler.CompilationResult compile(File lessFile, LessCompiler.Configuration options) throws Less4jException {
        return this.compile(new LessSource.FileSource(lessFile, "utf-8"), options);
    }

    @Override
    public LessCompiler.CompilationResult compile(URL lessURL) throws Less4jException {
        return this.compile(new LessSource.URLSource(lessURL));
    }

    @Override
    public LessCompiler.CompilationResult compile(URL lessURL, LessCompiler.Configuration options) throws Less4jException {
        return this.compile(new LessSource.URLSource(lessURL), options);
    }

    @Override
    public LessCompiler.CompilationResult compile(LessSource source) throws Less4jException {
        return this.compile(source, new LessCompiler.Configuration());
    }

    @Override
    public LessCompiler.CompilationResult compile(LessSource source, LessCompiler.Configuration options) throws Less4jException {
        if (options == null) {
            options = new LessCompiler.Configuration();
        }
        this.problemsHandler = new ProblemsHandler();
        this.astBuilder = new ASTBuilder(this.problemsHandler);
        this.compiler = new LessToCssCompiler(this.problemsHandler, options);
        LessCompiler.CompilationResult compilationResult = this.doCompile(source, options);
        if (this.problemsHandler.hasErrors()) {
            throw new Less4jException(this.problemsHandler.getErrors(), compilationResult);
        }
        return compilationResult;
    }

    private LessCompiler.CompilationResult doCompile(LessSource source, LessCompiler.Configuration options) throws Less4jException {
        StyleSheet lessStyleSheet = null;
        if (options != null && options.getCache() != null && (lessStyleSheet = (StyleSheet)options.getCache().getAst(source)) != null) {
            lessStyleSheet = lessStyleSheet.clone();
        }
        if (lessStyleSheet == null) {
            ANTLRParser.ParseResult result = this.toAntlrTree(source);
            lessStyleSheet = this.astBuilder.parseStyleSheet(result.getTree());
            if (options != null && options.getCache() != null) {
                options.getCache().setAst(source, lessStyleSheet);
                lessStyleSheet = lessStyleSheet.clone();
            }
        }
        Map<String, HiddenTokenAwareTree> variables = this.toAntlrTree(options.getVariables());
        List<VariableDeclaration> externalVariables = this.astBuilder.parseVariables(variables);
        lessStyleSheet.addMembers(externalVariables);
        lessStyleSheet.configureParentToAllChilds();
        try {
            ASTCssNode cssStyleSheet = this.compiler.compileToCss(lessStyleSheet, source, options);
            LessCompiler.CompilationResult compilationResult = this.createCompilationResult(cssStyleSheet, source, externalVariables, this.compiler.getImportedsources(), options);
            return compilationResult;
        }
        catch (UnableToFinish ex) {
            this.problemsHandler.unableToFinish(lessStyleSheet, ex);
            return this.createEmptyCompilationResult();
        }
    }

    private ANTLRParser.ParseResult toAntlrTree(LessSource source) throws Less4jException {
        ANTLRParser.ParseResult result;
        try {
            result = this.parser.parseStyleSheet(source.getContent(), source);
        }
        catch (LessSource.FileNotFound ex) {
            throw new Less4jException(new GeneralProblem("The file " + source + " does not exists."), new LessCompiler.CompilationResult(null));
        }
        catch (LessSource.CannotReadFile ex) {
            throw new Less4jException(new GeneralProblem("Cannot read the file " + source + "."), new LessCompiler.CompilationResult(null));
        }
        if (result.hasErrors()) {
            LessCompiler.CompilationResult compilationResult = new LessCompiler.CompilationResult("Errors during parsing phase, partial result is not available.");
            throw new Less4jException(result.getErrors(), compilationResult);
        }
        return result;
    }

    private Map<String, HiddenTokenAwareTree> toAntlrTree(Map<String, String> variables) throws Less4jException {
        HashMap<String, HiddenTokenAwareTree> result = new HashMap<String, HiddenTokenAwareTree>();
        ArrayList<LessCompiler.Problem> problems = new ArrayList<LessCompiler.Problem>();
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String nameStr = entry.getKey();
            String valueStr = entry.getValue();
            ANTLRParser.ParseResult valueParseResult = this.toAntlrExpressionTree(nameStr, valueStr);
            problems.addAll(valueParseResult.getErrors());
            result.put(nameStr, valueParseResult.getTree());
        }
        if (!problems.isEmpty()) {
            LessCompiler.CompilationResult compilationResult = new LessCompiler.CompilationResult("Errors parsing custom variables, partial result is not available.");
            throw new Less4jException(problems, compilationResult);
        }
        return result;
    }

    private ANTLRParser.ParseResult toAntlrExpressionTree(String dummySourceName, String expression) {
        DummyLessSource source = new DummyLessSource(dummySourceName, expression);
        return this.parser.parseFullExpression(expression, source);
    }

    private LessCompiler.CompilationResult createCompilationResult(ASTCssNode cssStyleSheet, LessSource lessSource, List<VariableDeclaration> externalVariables, Collection<LessSource> additionalSourceFiles, LessCompiler.Configuration options) {
        LessSource cssDestination;
        LessSource lessSource2 = cssDestination = options == null ? null : options.getCssResultLocation();
        if (cssDestination == null) {
            String guessedCssName = URIUtils.changeSuffix(lessSource.getName(), ".css");
            URI guessedURI = URIUtils.changeSuffix(lessSource.getURI(), ".css");
            cssDestination = new LessSource.StringSource("", guessedCssName, guessedURI);
        }
        CssPrinter builder = new CssPrinter(lessSource, cssDestination, this.extractSources(externalVariables), additionalSourceFiles, options);
        builder.append(cssStyleSheet);
        StringBuilder css = builder.toCss();
        String sourceMap = builder.toSourceMap();
        this.handleSourceMapLink(cssStyleSheet, css, options, lessSource, sourceMap);
        LessCompiler.CompilationResult compilationResult = new LessCompiler.CompilationResult(css.toString(), sourceMap, this.problemsHandler.getWarnings());
        return compilationResult;
    }

    private List<LessSource> extractSources(List<VariableDeclaration> externalVariables) {
        ArrayList<LessSource> result = new ArrayList<LessSource>();
        for (VariableDeclaration variableDeclaration : externalVariables) {
            result.add(variableDeclaration.getSource());
        }
        return result;
    }

    private LessCompiler.CompilationResult createEmptyCompilationResult() {
        LessCompiler.CompilationResult compilationResult = new LessCompiler.CompilationResult("", null, this.problemsHandler.getWarnings());
        return compilationResult;
    }

    private void handleSourceMapLink(ASTCssNode cssAst, StringBuilder css, LessCompiler.Configuration options, LessSource source, String sourceMap) {
        String commentText;
        String cssResultLocation = this.getCssResultLocationName(options, source);
        LessCompiler.SourceMapConfiguration sourceMapConfiguration = options.getSourceMapConfiguration();
        if (!sourceMapConfiguration.shouldLinkSourceMap() && !sourceMapConfiguration.isInline()) {
            return;
        }
        if (!sourceMapConfiguration.isInline() && cssResultLocation == null) {
            this.problemsHandler.warnSourceMapLinkWithoutCssResultLocation(cssAst);
            return;
        }
        this.addNewLine(css);
        String encodingCharset = sourceMapConfiguration.getEncodingCharset();
        if (sourceMapConfiguration.isInline()) {
            String encodedSourceMap = PrintUtils.base64Encode(sourceMap, encodingCharset, this.problemsHandler, cssAst);
            commentText = "/*# sourceMappingURL=data:application/json;base64," + encodedSourceMap + " */";
        } else {
            String url = sourceMapConfiguration.getSourceMapNameGenerator().generateUrl(cssResultLocation);
            String encodedUrl = PrintUtils.urlEncode(url, encodingCharset, this.problemsHandler, cssAst);
            commentText = "/*# sourceMappingURL=" + encodedUrl + " */";
        }
        css.append(commentText).append("\n");
    }

    private void addNewLine(StringBuilder css) {
        if (css == null) {
            return;
        }
        int length = css.length();
        if (length == 0) {
            css.append("\n");
            return;
        }
        String endingSymbol = css.substring(length - 1);
        if ("\n".equals(endingSymbol)) {
            return;
        }
        css.append("\n");
    }

    private String getCssResultLocationName(LessCompiler.Configuration options, LessSource source) {
        String name;
        LessSource location = options.getCssResultLocation();
        String string = name = location == null ? null : location.getName();
        if (name == null) {
            name = URIUtils.changeSuffix(source.getName(), ".css");
        }
        return name;
    }
}

