/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di.resolver;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.convert.TypeConverter;
import org.apache.logging.log4j.plugins.di.resolver.AbstractAttributeFactoryResolver;
import org.apache.logging.log4j.plugins.di.spi.StringValueResolver;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.Strings;
import org.jspecify.annotations.Nullable;

public class PluginAttributeFactoryResolver<T>
extends AbstractAttributeFactoryResolver<T, PluginAttribute> {
    private static final Map<Type, Function<PluginAttribute, ?>> DEFAULT_VALUE_EXTRACTORS = Map.ofEntries(Map.entry(Integer.TYPE, PluginAttribute::defaultInt), Map.entry(Integer.class, PluginAttribute::defaultInt), Map.entry(Long.TYPE, PluginAttribute::defaultLong), Map.entry(Long.class, PluginAttribute::defaultLong), Map.entry(Boolean.TYPE, PluginAttribute::defaultBoolean), Map.entry(Boolean.class, PluginAttribute::defaultBoolean), Map.entry(Float.TYPE, PluginAttribute::defaultFloat), Map.entry(Float.class, PluginAttribute::defaultFloat), Map.entry(Double.TYPE, PluginAttribute::defaultDouble), Map.entry(Double.class, PluginAttribute::defaultDouble), Map.entry(Byte.TYPE, PluginAttribute::defaultByte), Map.entry(Byte.class, PluginAttribute::defaultByte), Map.entry(Character.TYPE, PluginAttribute::defaultChar), Map.entry(Character.class, PluginAttribute::defaultChar), Map.entry(Short.TYPE, PluginAttribute::defaultShort), Map.entry(Short.class, PluginAttribute::defaultShort), Map.entry(Class.class, PluginAttribute::defaultClass));

    public PluginAttributeFactoryResolver() {
        super(PluginAttribute.class);
    }

    @Override
    protected boolean isSensitive(PluginAttribute annotation) {
        return annotation.sensitive();
    }

    @Override
    protected @Nullable T getDefaultValue(PluginAttribute annotation, StringValueResolver resolver, Type type, TypeConverter<T> typeConverter) {
        Function extractor = (Function)Cast.cast(DEFAULT_VALUE_EXTRACTORS.get(type));
        if (extractor != null) {
            return (T)extractor.apply(annotation);
        }
        String defaultString = resolver.resolve(annotation.defaultString());
        return Strings.isEmpty((CharSequence)defaultString) ? null : (T)typeConverter.convert(defaultString, null);
    }
}

