/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jdbc.appender;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.logging.log4j.jdbc.appender.AbstractConnectionSource;
import org.apache.logging.log4j.jdbc.appender.ConnectionSource;

public class JdbcH2TestHelper {
    public static final String CONNECTION_STRING_IN_MEMORY = "jdbc:h2:mem:Log4j";
    private static final String CONNECTION_STRING_IN_MEMORY_PERMANENT = "jdbc:h2:mem:Log4j_perm;DB_CLOSE_DELAY=-1";
    public static final String USER_NAME = "sa";
    public static final String PASSWORD = "";
    public static ConnectionSource TEST_CONFIGURATION_SOURCE_MEM = new AbstractConnectionSource(){

        public Connection getConnection() throws SQLException {
            return JdbcH2TestHelper.getConnectionInMemory();
        }
    };
    public static ConnectionSource TEST_CONFIGURATION_SOURCE_MEM_PERM = new AbstractConnectionSource(){

        public Connection getConnection() throws SQLException {
            return JdbcH2TestHelper.getConnectionInMemoryPermanent();
        }
    };

    static Connection getConnectionInMemory() throws SQLException {
        return DriverManager.getConnection(CONNECTION_STRING_IN_MEMORY, USER_NAME, PASSWORD);
    }

    @SuppressFBWarnings(value={"DMI_EMPTY_DB_PASSWORD"})
    static Connection getConnectionInMemoryPermanent() throws SQLException {
        return DriverManager.getConnection(CONNECTION_STRING_IN_MEMORY_PERMANENT, USER_NAME, PASSWORD);
    }
}

