/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit.request;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.audit.annotation.Chained;
import org.apache.logging.log4j.audit.annotation.ClientServer;
import org.apache.logging.log4j.audit.annotation.HeaderPrefix;
import org.apache.logging.log4j.audit.annotation.Local;
import org.apache.logging.log4j.audit.request.ChainedMapping;
import org.apache.logging.log4j.audit.request.ClientServerMapping;
import org.apache.logging.log4j.audit.request.LocalMapping;
import org.apache.logging.log4j.audit.request.RequestContextMapping;
import org.apache.logging.log4j.audit.request.Scope;

public class RequestContextMappings {
    private static final String DEFAULT_HEADER_PREFIX = "request-context-";
    private final Map<String, RequestContextMapping> mappings = new HashMap<String, RequestContextMapping>();
    private final String headerPrefix;

    public RequestContextMappings(String fqcn) {
        this(RequestContextMappings.getClass(fqcn));
    }

    private static Class<?> getClass(String fqcn) {
        if (fqcn == null) {
            throw new IllegalArgumentException("RequestContext class name cannot be null");
        }
        try {
            return Class.forName(fqcn);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Invalid RequestContext class name", ex);
        }
    }

    public RequestContextMappings(Class<?> clazz) {
        Field[] fields;
        if (clazz == null) {
            throw new IllegalArgumentException("A RequestContext class must be provided");
        }
        Annotation annotation = clazz.getAnnotation(HeaderPrefix.class);
        this.headerPrefix = annotation != null ? annotation.value().toLowerCase() : DEFAULT_HEADER_PREFIX;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (field.getType().equals(String.class)) {
                String fieldName;
                try {
                    fieldName = (String)field.get(null);
                }
                catch (IllegalAccessException ex) {
                    continue;
                }
                if (fieldName == null) continue;
                annotation = field.getAnnotation(ClientServer.class);
                if (annotation != null) {
                    this.mappings.put(fieldName.toLowerCase(), new ClientServerMapping(fieldName));
                    continue;
                }
                annotation = field.getAnnotation(Local.class);
                if (annotation == null) continue;
                this.mappings.put(fieldName.toLowerCase(), new LocalMapping(fieldName));
                continue;
            }
            if (!field.getType().equals(Supplier.class) || (annotation = field.getAnnotation(Chained.class)) == null) continue;
            Chained chained = (Chained)annotation;
            try {
                Supplier supplier = (Supplier)field.get(null);
                this.mappings.put(chained.fieldName().toLowerCase(), new ChainedMapping(chained.fieldName(), chained.chainedFieldName(), supplier));
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Unable to retrieve Supplier for chained field " + chained.fieldName());
            }
        }
        this.mappings.entrySet().removeIf(a -> this.validateChained((RequestContextMapping)a.getValue()));
    }

    public RequestContextMapping getMapping(String name) {
        return this.mappings.get(name.toLowerCase());
    }

    public RequestContextMapping getMappingByHeader(String header) {
        String hdr = header.toLowerCase();
        if (hdr.startsWith(this.headerPrefix)) {
            return this.mappings.get(hdr.substring(this.headerPrefix.length()));
        }
        return null;
    }

    public String getHeaderPrefix() {
        return this.headerPrefix;
    }

    private boolean validateChained(RequestContextMapping mapping) {
        return mapping.getScope() == Scope.CHAIN && !this.mappings.containsKey(mapping.getChainKey().toLowerCase());
    }
}

