/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.help;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.help.HelpLocator;

public final class HelpManager {
    private static final HelpManager instance = new HelpManager();
    private HelpLocator helpLocator = new HelpLocator();
    private URL helpURL;
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private final Logger logger = LogManager.getLogger(HelpManager.class);

    private HelpManager() {
        try {
            if (System.getProperty("log4j.chainsaw.localDocs") != null) {
                this.logger.info((Object)("Adding HelpLocator for localDocs property=" + System.getProperty("log4j.chainsaw.localDocs")));
                this.helpLocator.installLocator(new URL(System.getProperty("log4j.chainsaw.localDocs")));
            } else if (new File("docs/api").exists()) {
                File dir = new File("docs/api");
                this.logger.info((Object)("Detected Local JavaDocs at " + dir.toString()));
                this.helpLocator.installLocator(dir.toURI().toURL());
            } else {
                this.logger.warn((Object)"Could not find any local JavaDocs, you might want to consider running 'ant javadoc'. The release version will be able to access Javadocs from the Apache website.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.helpLocator.installClassloaderLocator(this.getClass().getClassLoader());
    }

    public void setHelpURL(URL helpURL) {
        this.helpURL = helpURL;
        this.firePropertyChange("helpURL", null, this.helpURL);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.propertySupport.firePropertyChange(evt);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    public static HelpManager getInstance() {
        return instance;
    }

    public void showHelpForClass(Class c) {
        URL url = this.getHelpForClass(c);
        this.setHelpURL(url);
    }

    public URL getHelpForClass(Class c) {
        String name = c.getName();
        name = name.replace('.', '/') + ".html";
        URL url = this.helpLocator.findResource(name);
        this.logger.debug((Object)("located help resource for '" + name + "' at " + (url == null ? "" : url.toExternalForm())));
        return url != null ? url : ChainsawConstants.URL_PAGE_NOT_FOUND;
    }
}

