/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.token;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.ThumbprintUtils;
import com.nimbusds.jose.util.Base64URL;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.util.LinkedHashMap;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.token.impl.JWT;

public class TokenUtils {
    public static final String ATTR_CURRENT_KNOXSSO_COOKIE_TOKEN_ID = "currentKnoxSsoCookieTokenId";
    public static final String SIGNING_HMAC_SECRET_ALIAS = "gateway.signing.hmac.secret";
    private static final String DEFAULT_RSA_SIG_ALG = "RS256";
    private static final String DEFAULT_HMAC_SIG_ALG = "HS256";

    public static String getTokenId(JWT token) {
        return token.getClaim("knox.id");
    }

    public static boolean isServerManagedTokenStateEnabled(FilterConfig filterConfig) {
        String providerParamValue = filterConfig.getInitParameter("knox.token.exp.server-managed");
        return TokenUtils.isServerManagedTokenStateEnabled(providerParamValue, filterConfig.getServletContext());
    }

    public static boolean isServerManagedTokenStateEnabled(ServletContext context) {
        String serviceParamValue = context.getInitParameter("knox.token.exp.server-managed");
        return TokenUtils.isServerManagedTokenStateEnabled(serviceParamValue, context);
    }

    private static boolean isServerManagedTokenStateEnabled(String parameterValue, ServletContext context) {
        if (parameterValue == null || parameterValue.isEmpty()) {
            GatewayConfig config = (GatewayConfig)context.getAttribute("org.apache.knox.gateway.config");
            return config != null && config.isServerManagedTokenStateEnabled();
        }
        return Boolean.valueOf(parameterValue);
    }

    public static String getSignatureAlgorithm(String configuredSignatureAlgorithm, AliasService aliasService, String signingKeystoreName) throws AliasServiceException {
        if (StringUtils.isNotBlank((CharSequence)configuredSignatureAlgorithm)) {
            return configuredSignatureAlgorithm;
        }
        char[] hmacSecret = aliasService.getPasswordFromAliasForGateway(SIGNING_HMAC_SECRET_ALIAS);
        return TokenUtils.useHMAC(hmacSecret == null ? null : hmacSecret, signingKeystoreName) ? DEFAULT_HMAC_SIG_ALG : DEFAULT_RSA_SIG_ALG;
    }

    public static String getThumbprint(RSAPublicKey publicKey, String hashAlgorithm) throws JOSEException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("e", Base64URL.encode((BigInteger)publicKey.getPublicExponent()).toString());
        params.put("kty", KeyType.RSA.getValue());
        params.put("n", Base64URL.encode((BigInteger)publicKey.getModulus()).toString());
        return ThumbprintUtils.compute((String)hashAlgorithm, params).toString();
    }

    private static boolean useHMAC(char[] hmacSecret, String signingKeystoreName) {
        return hmacSecret != null && StringUtils.isBlank((CharSequence)signingKeystoreName);
    }
}

