/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util.urltemplate;

import java.net.URISyntaxException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.util.urltemplate.Builder;
import org.apache.knox.gateway.util.urltemplate.Path;
import org.apache.knox.gateway.util.urltemplate.Resources;
import org.apache.knox.gateway.util.urltemplate.Scheme;
import org.apache.knox.gateway.util.urltemplate.Template;
import org.apache.knox.gateway.util.urltemplate.Token;

public class Parser {
    private static final Resources RES = (Resources)ResourcesFactory.get(Resources.class);
    public static final char TEMPLATE_OPEN_MARKUP = '{';
    public static final char TEMPLATE_CLOSE_MARKUP = '}';
    public static final char NAME_PATTERN_SEPARATOR = '=';
    private static final int MATCH_GROUP_SCHEME = 1;
    private static final int MATCH_GROUP_SCHEME_NAKED = 2;
    private static final int MATCH_GROUP_AUTHORITY = 3;
    private static final int MATCH_GROUP_AUTHORITY_NAKED = 4;
    private static final int MATCH_GROUP_PATH = 5;
    private static final int MATCH_GROUP_QUERY = 6;
    private static final int MATCH_GROUP_QUERY_NAKED = 7;
    private static final int MATCH_GROUP_FRAGMENT = 8;
    private static final int MATCH_GROUP_FRAGMENT_NAKED = 9;
    private static Pattern PATTERN = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");

    @Deprecated
    public static Template parse(String template) throws URISyntaxException {
        return Parser.parseTemplate(template);
    }

    public static Template parseTemplate(String template) throws URISyntaxException {
        Builder builder = new Builder(template);
        return Parser.parseInternal(builder);
    }

    public static Template parseLiteral(String literal) throws URISyntaxException {
        Builder builder = new Builder(literal);
        builder.setLiteral(true);
        return Parser.parseInternal(builder);
    }

    private static Template parseInternal(Builder builder) throws URISyntaxException {
        String original = builder.getOriginal();
        builder.setHasScheme(false);
        builder.setHasAuthority(false);
        builder.setIsAuthorityOnly(false);
        builder.setIsAbsolute(false);
        builder.setIsDirectory(false);
        builder.setHasQuery(false);
        builder.setHasFragment(false);
        Matcher match = PATTERN.matcher(original);
        if (!match.matches()) {
            throw new URISyntaxException(original, RES.parseTemplateFailureReason(original));
        }
        Parser.consumeSchemeMatch(builder, match);
        Parser.consumeAuthorityMatch(builder, match);
        Parser.consumePathMatch(builder, match);
        Parser.consumeQueryMatch(builder, match);
        Parser.consumeFragmentMatch(builder, match);
        Parser.fixNakedAuthority(builder);
        return builder.build();
    }

    private static void fixNakedAuthority(Builder builder) {
        if (!(!builder.getHasScheme() || builder.getHasAuthority() || builder.getIsAbsolute() || builder.getIsDirectory() || builder.getPath().size() != 1 || builder.getHasQuery() || builder.getHasFragment())) {
            Scheme scheme = builder.getScheme();
            builder.setHasScheme(false);
            builder.setHost(Parser.makeTokenSingular(scheme.getToken()));
            Path path = builder.getPath().remove(0);
            builder.setPort(Parser.makeTokenSingular(path.getToken()));
            builder.setIsAuthorityOnly(true);
        }
    }

    private static Token makeTokenSingular(Token token) {
        String effectivePattern = token.getEffectivePattern();
        if ("**".equals(effectivePattern)) {
            token = new Token(token.getParameterName(), token.getOriginalPattern(), "*", token.isLiteral());
        }
        return token;
    }

    private static void consumeSchemeMatch(Builder builder, Matcher match) {
        if (match.group(1) != null) {
            builder.setHasScheme(true);
            Parser.consumeSchemeToken(builder, match.group(2));
        }
    }

    private static void consumeSchemeToken(Builder builder, String token) {
        if (token != null) {
            Token t = Parser.parseTemplateToken(builder, token, "*");
            builder.setScheme(t);
        }
    }

    private static void consumeAuthorityMatch(Builder builder, Matcher match) {
        if (match.group(3) != null) {
            builder.setHasAuthority(true);
            Parser.consumeAuthorityToken(builder, match.group(4));
        }
    }

    private static void consumeAuthorityToken(Builder builder, String token) {
        if (token != null) {
            Token paramPattern;
            String[] hostPort;
            String[] usernamePassword = null;
            String[] userAddr = Parser.split(token, '@');
            if (userAddr.length == 1) {
                hostPort = Parser.split(userAddr[0], ':');
            } else {
                usernamePassword = Parser.split(userAddr[0], ':');
                hostPort = Parser.split(userAddr[1], ':');
            }
            if (usernamePassword != null) {
                if (!usernamePassword[0].isEmpty()) {
                    paramPattern = Parser.makeTokenSingular(Parser.parseTemplateToken(builder, usernamePassword[0], "*"));
                    builder.setUsername(paramPattern);
                }
                if (usernamePassword.length > 1 && !usernamePassword[1].isEmpty()) {
                    paramPattern = Parser.makeTokenSingular(Parser.parseTemplateToken(builder, usernamePassword[1], "*"));
                    builder.setPassword(paramPattern);
                }
            }
            if (!hostPort[0].isEmpty()) {
                paramPattern = Parser.makeTokenSingular(Parser.parseTemplateToken(builder, hostPort[0], "*"));
                builder.setHost(paramPattern);
            }
            if (hostPort.length > 1 && !hostPort[1].isEmpty()) {
                paramPattern = Parser.makeTokenSingular(Parser.parseTemplateToken(builder, hostPort[1], "*"));
                builder.setPort(paramPattern);
            }
        }
    }

    private static void consumePathMatch(Builder builder, Matcher match) {
        String path = match.group(5);
        if (path != null) {
            builder.setIsAbsolute(path.startsWith("/"));
            builder.setIsDirectory(path.endsWith("/"));
            Parser.consumePathToken(builder, path);
        }
    }

    private static void consumePathToken(Builder builder, String token) {
        if (token != null) {
            StringTokenizer tokenizer = new StringTokenizer(token, "/");
            while (tokenizer.hasMoreTokens()) {
                Parser.consumePathSegment(builder, tokenizer.nextToken());
            }
        }
    }

    private static void consumePathSegment(Builder builder, String token) {
        if (token != null) {
            Token t = Parser.parseTemplateToken(builder, token, "**");
            builder.addPath(t);
        }
    }

    private static void consumeQueryMatch(Builder builder, Matcher match) {
        if (match.group(6) != null) {
            builder.setHasQuery(true);
            Parser.consumeQueryToken(builder, match.group(7));
        }
    }

    private static void consumeQueryToken(Builder builder, String token) {
        String[] tokens;
        if (token != null && (tokens = token.split("(&amp;|\\?|&)")) != null) {
            for (String nextToken : tokens) {
                Parser.consumeQuerySegment(builder, nextToken);
            }
        }
    }

    private static void consumeQuerySegment(Builder builder, String token) {
        if (token != null && !token.isEmpty()) {
            if ('{' == token.charAt(0)) {
                Token paramPattern = Parser.parseTemplateToken(builder, token, "**");
                String paramName = paramPattern.parameterName;
                if (paramPattern.originalPattern == null) {
                    builder.addQuery(paramName, new Token(paramName, null, "**", builder.isLiteral()));
                } else {
                    builder.addQuery(paramName, new Token(paramName, paramPattern.originalPattern, builder.isLiteral()));
                }
            } else {
                String[] nameValue = Parser.split(token, '=');
                if (nameValue.length == 1) {
                    String queryName = nameValue[0];
                    builder.addQuery(queryName, new Token("", null, builder.isLiteral()));
                } else {
                    String queryName = nameValue[0];
                    Token paramPattern = Parser.parseTemplateToken(builder, nameValue[1], "**");
                    builder.addQuery(queryName, paramPattern);
                }
            }
        }
    }

    private static void consumeFragmentMatch(Builder builder, Matcher match) {
        if (match.group(8) != null) {
            builder.setHasFragment(true);
            Parser.consumeFragmentToken(builder, match.group(9));
        }
    }

    private static void consumeFragmentToken(Builder builder, String token) {
        if (token != null && !token.isEmpty()) {
            Token t = Parser.parseTemplateToken(builder, token, "*");
            builder.setFragment(t);
        }
    }

    static Token parseTemplateToken(Builder builder, String s, String defaultEffectivePattern) {
        String effectivePattern;
        String actualPattern;
        String paramName;
        int l = s.length();
        if (l > 0 && !builder.isLiteral()) {
            int e;
            int b = s.charAt(0) == '{' ? 1 : -1;
            int n = e = s.charAt(l - 1) == '}' ? l - 1 : -1;
            if (b > 0 && e > 0 && e > b) {
                int i = s.indexOf(61, b);
                if (i < 0) {
                    paramName = s.substring(b, e);
                    actualPattern = null;
                    effectivePattern = "**".equals(paramName) ? "**" : defaultEffectivePattern;
                } else {
                    paramName = s.substring(b, i);
                    effectivePattern = actualPattern = s.substring(i + 1, e);
                }
            } else {
                paramName = "";
                effectivePattern = actualPattern = s;
            }
        } else {
            paramName = "";
            effectivePattern = actualPattern = s;
        }
        return new Token(paramName, actualPattern, effectivePattern, builder.isLiteral());
    }

    private static String[] split(String s, char d) {
        int i = s.indexOf(d);
        String[] a = i < 0 ? new String[]{s} : new String[]{s.substring(0, i), s.substring(i + 1)};
        return a;
    }
}

