/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import javax.activation.MimeType;
import javax.servlet.FilterConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.filter.GatewayResponse;
import org.apache.knox.gateway.filter.GatewayResponseWrapper;
import org.apache.knox.gateway.filter.ResponseStreamer;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteServletContextListener;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteServletFilter;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteStreamFilterFactory;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.knox.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteResponseStream;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteUtil;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStreamFilter;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.util.MimeTypes;
import org.apache.knox.gateway.util.Urls;
import org.apache.knox.gateway.util.urltemplate.Params;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Resolver;
import org.apache.knox.gateway.util.urltemplate.Template;

public class UrlRewriteResponse
extends GatewayResponseWrapper
implements Params,
ResponseStreamer {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private static final int STREAM_BUFFER_SIZE = 8192;
    private static final Set<String> IGNORE_HEADER_NAMES = new HashSet<String>();
    private static final String REQUEST_PARAM_PREFIX = "request.";
    private static final String CLUSTER_PARAM_PREFIX = "cluster.";
    private static final String GATEWAY_PARAM_PREFIX = "gateway.";
    public static final String INBOUND_QUERY_PARAM_PREFIX = "query.param.";
    private UrlRewriter rewriter;
    private FilterConfig config;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletOutputStream output;
    private String bodyFilterName;
    private String headersFilterName;
    private UrlRewriteFilterContentDescriptor headersFilterConfig;
    private String xForwardedHostname;
    private String xForwardedPort;
    private String xForwardedScheme;
    private String contentEncoding;

    public UrlRewriteResponse(FilterConfig config, HttpServletRequest request, HttpServletResponse response) {
        super(response);
        this.rewriter = UrlRewriteServletContextListener.getUrlRewriter(config.getServletContext());
        this.config = config;
        this.request = request;
        this.response = response;
        this.output = null;
        this.getXForwardedHeaders();
        this.bodyFilterName = config.getInitParameter("response.body");
        this.headersFilterName = config.getInitParameter("response.headers");
        this.headersFilterConfig = UrlRewriteUtil.getRewriteFilterConfig(this.rewriter.getConfig(), this.headersFilterName, UrlRewriteServletFilter.HEADERS_MIME_TYPE);
        this.contentEncoding = "";
    }

    protected boolean ignoreHeader(String name) {
        return IGNORE_HEADER_NAMES.contains(name);
    }

    private String rewriteValue(String value, String rule) {
        try {
            Template input = Parser.parseLiteral((String)value);
            Template output = this.rewriter.rewrite((Resolver)this, input, UrlRewriter.Direction.OUT, rule);
            if (output != null) {
                value = output.toString();
            }
        }
        catch (URISyntaxException e) {
            LOG.failedToParseValueForUrlRewrite(value);
        }
        return value;
    }

    private void setContentEncoding(String name, String value) {
        if ("Content-Encoding".equalsIgnoreCase(name)) {
            this.contentEncoding = value;
        }
    }

    public void setHeader(String name, String value) {
        if (!this.ignoreHeader(name)) {
            value = this.rewriteValue(value, UrlRewriteUtil.pickFirstRuleWithEqualsIgnoreCasePathMatch(this.headersFilterConfig, name));
            this.setContentEncoding(name, value);
            super.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (!this.ignoreHeader(name)) {
            String rule = UrlRewriteUtil.pickFirstRuleWithEqualsIgnoreCasePathMatch(this.headersFilterConfig, name);
            value = this.rewriteValue(value, rule);
            this.setContentEncoding(name, value);
            super.addHeader(name, value);
        }
    }

    public OutputStream getRawOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamResponse(InputStream input, OutputStream output) throws IOException {
        InputStream inStream;
        OutputStream outStream;
        UrlRewriteStreamFilter filter;
        String asType;
        MimeType mimeType = this.getMimeType();
        UrlRewriteFilterContentDescriptor filterContentConfig = UrlRewriteUtil.getRewriteFilterConfig(this.rewriter.getConfig(), this.bodyFilterName, mimeType);
        if (filterContentConfig != null && (asType = filterContentConfig.asType()) != null && !StringUtils.isBlank((CharSequence)asType)) {
            mimeType = MimeTypes.create((String)asType, (String)this.getCharacterEncoding());
        }
        if ((filter = UrlRewriteStreamFilterFactory.create(mimeType, null)) != null) {
            Object unFilteredStream;
            boolean isGzip = false;
            BufferedInputStream inBuffer = new BufferedInputStream(input, 8192);
            inBuffer.mark(2);
            byte[] signature = new byte[2];
            int len = inBuffer.read(signature);
            if (len == 2 && signature[0] == 31 && signature[1] == -117) {
                isGzip = true;
            }
            inBuffer.reset();
            if (isGzip || "gzip".equalsIgnoreCase(this.contentEncoding)) {
                unFilteredStream = new GzipCompressorInputStream((InputStream)inBuffer, true);
                outStream = new GZIPOutputStream(output, 8192);
            } else if ("deflate".equalsIgnoreCase(this.contentEncoding)) {
                unFilteredStream = new InflaterInputStream(inBuffer);
                outStream = new DeflaterOutputStream(output);
            } else {
                unFilteredStream = inBuffer;
                outStream = output;
            }
            String charset = MimeTypes.getCharset((MimeType)mimeType, (String)StandardCharsets.UTF_8.name());
            inStream = filter.filter((InputStream)unFilteredStream, charset, this.rewriter, (Resolver)this, UrlRewriter.Direction.OUT, filterContentConfig);
        } else {
            inStream = input;
            outStream = output;
        }
        try {
            IOUtils.copy((InputStream)inStream, (OutputStream)outStream, (int)8192);
        }
        finally {
            outStream.close();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            this.output = new UrlRewriteResponseStream((GatewayResponse)this);
        }
        return this.output;
    }

    public Set<String> getNames() {
        return Collections.emptySet();
    }

    public List<String> resolve(String name) {
        if (name.startsWith(REQUEST_PARAM_PREFIX)) {
            return Collections.singletonList(this.getRequestParam(name.substring(REQUEST_PARAM_PREFIX.length())));
        }
        if (name.startsWith(GATEWAY_PARAM_PREFIX)) {
            return Collections.singletonList(this.getGatewayParam(name.substring(GATEWAY_PARAM_PREFIX.length())));
        }
        if (name.startsWith(CLUSTER_PARAM_PREFIX)) {
            return Collections.singletonList(this.getClusterParam(name.substring(GATEWAY_PARAM_PREFIX.length())));
        }
        if (name.startsWith(INBOUND_QUERY_PARAM_PREFIX)) {
            return this.getInboundQueryParam(name.substring(INBOUND_QUERY_PARAM_PREFIX.length()));
        }
        return Collections.singletonList(this.config.getInitParameter(name));
    }

    private String getRequestLocalHostName() {
        String hostName = this.request.getLocalName();
        try {
            hostName = InetAddress.getByName(hostName).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostName;
    }

    private String getGatewayParam(String name) {
        if ("url".equals(name)) {
            if (this.xForwardedPort == null) {
                return this.xForwardedScheme + "://" + this.xForwardedHostname + this.request.getContextPath();
            }
            return this.xForwardedScheme + "://" + this.xForwardedHostname + ":" + this.xForwardedPort + this.request.getContextPath();
        }
        if ("scheme".equals(name)) {
            return this.xForwardedScheme;
        }
        if ("host".equals(name)) {
            return this.xForwardedHostname;
        }
        if ("port".equals(name)) {
            return this.xForwardedPort;
        }
        if ("addr".equals(name) || "address".equals(name)) {
            if (this.xForwardedPort == null) {
                return this.xForwardedHostname;
            }
            return this.xForwardedHostname + ":" + this.xForwardedPort;
        }
        if ("path".equals(name)) {
            return this.request.getContextPath();
        }
        return null;
    }

    private String getClusterParam(String name) {
        if ("name".equals(name)) {
            return this.config.getServletContext().getServletContextName();
        }
        return null;
    }

    private List<String> getInboundQueryParam(String name) {
        List<String> inboundHosts = null;
        if (this.request != null) {
            inboundHosts = Arrays.asList(this.request.getParameterValues(name));
        }
        return inboundHosts;
    }

    private String getRequestParam(String name) {
        if ("host".equals(name)) {
            return this.request.getServerName();
        }
        if ("port".equals(name)) {
            return Integer.toString(this.request.getLocalPort());
        }
        if ("scheme".equals(name)) {
            return this.request.getScheme();
        }
        if ("context-path".equals(name)) {
            return Urls.stripLeadingSlash((String)this.request.getContextPath());
        }
        this.config.getServletContext().getServletContextName();
        return null;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeURL(String url) {
        throw new UnsupportedOperationException();
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeRedirectURL(String url) {
        throw new UnsupportedOperationException();
    }

    private void getXForwardedHeaders() {
        this.xForwardedHostname = this.request.getHeader("X-Forwarded-Host");
        this.xForwardedPort = this.request.getHeader("X-Forwarded-Port");
        this.xForwardedScheme = this.request.getHeader("X-Forwarded-Proto");
        if (this.xForwardedScheme == null) {
            this.xForwardedScheme = this.request.getScheme();
        }
        if (this.xForwardedHostname != null) {
            int separator = this.xForwardedHostname.indexOf(58);
            if (separator > 0) {
                this.xForwardedPort = this.xForwardedHostname.substring(separator + 1, this.xForwardedHostname.length());
                this.xForwardedHostname = this.xForwardedHostname.substring(0, separator);
            }
        } else {
            this.xForwardedHostname = this.getRequestLocalHostName();
            this.xForwardedPort = Integer.toString(this.request.getLocalPort());
        }
    }

    static {
        IGNORE_HEADER_NAMES.add("Content-Length");
    }
}

