/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.message.internal.TracingLogger;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.ServerTraceEvent;
import org.glassfish.jersey.server.internal.process.Endpoint;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.internal.process.RespondingContext;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.monitoring.RequestEvent;

class ContainerFilteringStage
extends AbstractChainableStage<ContainerRequest> {
    private final ServiceLocator locator;
    private final Iterable<RankedProvider<ContainerRequestFilter>> requestFilters;
    private final Iterable<RankedProvider<ContainerResponseFilter>> responseFilters;
    private final Provider<RespondingContext> respondingContextFactory;

    private ContainerFilteringStage(Provider<RespondingContext> respondingContextFactory, ServiceLocator locator, Iterable<RankedProvider<ContainerRequestFilter>> requestFilters, Iterable<RankedProvider<ContainerResponseFilter>> responseFilters) {
        this.respondingContextFactory = respondingContextFactory;
        this.locator = locator;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Stage.Continuation<ContainerRequest> apply(ContainerRequest requestContext) {
        int processedCount;
        long timestamp;
        ServerTraceEvent summaryEvent;
        TracingLogger tracingLogger;
        boolean postMatching;
        block14: {
            Stage.Continuation continuation;
            block13: {
                Iterable sortedRequestFilters;
                postMatching = this.responseFilters == null;
                tracingLogger = TracingLogger.getInstance((PropertiesDelegate)requestContext);
                if (postMatching) {
                    RoutingContext rc = (RoutingContext)this.locator.getService(RoutingContext.class, new Annotation[0]);
                    ArrayList<Iterable<RankedProvider<ContainerRequestFilter>>> rankedProviders = new ArrayList<Iterable<RankedProvider<ContainerRequestFilter>>>(2);
                    rankedProviders.add(this.requestFilters);
                    rankedProviders.add(rc.getBoundRequestFilters());
                    sortedRequestFilters = Providers.mergeAndSortRankedProviders((RankedComparator)new RankedComparator(), rankedProviders);
                    requestContext.getRequestEventBuilder().setContainerRequestFilters(sortedRequestFilters);
                    requestContext.triggerEvent(RequestEvent.Type.REQUEST_MATCHED);
                } else {
                    ((RespondingContext)this.respondingContextFactory.get()).push((ChainableStage<ContainerResponse>)new ResponseFilterStage(this.responseFilters, this.locator, tracingLogger));
                    sortedRequestFilters = Providers.sortRankedProviders((RankedComparator)new RankedComparator(), this.requestFilters);
                }
                summaryEvent = postMatching ? ServerTraceEvent.REQUEST_FILTER_SUMMARY : ServerTraceEvent.PRE_MATCH_SUMMARY;
                timestamp = tracingLogger.timestamp((TracingLogger.Event)summaryEvent);
                processedCount = 0;
                try {
                    ServerTraceEvent filterEvent = postMatching ? ServerTraceEvent.REQUEST_FILTER : ServerTraceEvent.PRE_MATCH;
                    for (ContainerRequestFilter filter : sortedRequestFilters) {
                        long filterTimestamp = tracingLogger.timestamp((TracingLogger.Event)filterEvent);
                        try {
                            filter.filter((ContainerRequestContext)requestContext);
                            ++processedCount;
                        }
                        catch (Exception exception) {
                            try {
                                throw new MappableException(exception);
                            }
                            catch (Throwable throwable) {
                                ++processedCount;
                                tracingLogger.logDuration((TracingLogger.Event)filterEvent, filterTimestamp, new Object[]{filter});
                                throw throwable;
                            }
                        }
                        tracingLogger.logDuration((TracingLogger.Event)filterEvent, filterTimestamp, new Object[]{filter});
                        final Response abortResponse = requestContext.getAbortResponse();
                        if (abortResponse == null) continue;
                        continuation = Stage.Continuation.of((Object)((Object)requestContext), (Stage)Stages.asStage((Inflector)new Endpoint(){

                            public ContainerResponse apply(ContainerRequest requestContext) {
                                return new ContainerResponse(requestContext, abortResponse);
                            }
                        }));
                        if (postMatching) {
                            requestContext.triggerEvent(RequestEvent.Type.REQUEST_FILTERED);
                        }
                        break block13;
                    }
                    break block14;
                }
                catch (Throwable throwable) {
                    if (postMatching) {
                        requestContext.triggerEvent(RequestEvent.Type.REQUEST_FILTERED);
                    }
                    tracingLogger.logDuration((TracingLogger.Event)summaryEvent, timestamp, new Object[]{processedCount});
                    throw throwable;
                }
            }
            tracingLogger.logDuration((TracingLogger.Event)summaryEvent, timestamp, new Object[]{processedCount});
            return continuation;
        }
        if (postMatching) {
            requestContext.triggerEvent(RequestEvent.Type.REQUEST_FILTERED);
        }
        tracingLogger.logDuration((TracingLogger.Event)summaryEvent, timestamp, new Object[]{processedCount});
        return Stage.Continuation.of((Object)((Object)requestContext), (Stage)this.getDefaultNext());
    }

    static class Binder
    extends AbstractBinder {
        Binder() {
        }

        protected void configure() {
            this.bindAsContract(Builder.class);
        }
    }

    private static class ResponseFilterStage
    extends AbstractChainableStage<ContainerResponse> {
        private final Iterable<RankedProvider<ContainerResponseFilter>> filters;
        private final ServiceLocator locator;
        private final TracingLogger tracingLogger;

        private ResponseFilterStage(Iterable<RankedProvider<ContainerResponseFilter>> filters, ServiceLocator locator, TracingLogger tracingLogger) {
            this.filters = filters;
            this.locator = locator;
            this.tracingLogger = tracingLogger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Stage.Continuation<ContainerResponse> apply(ContainerResponse responseContext) {
            RoutingContext rc = (RoutingContext)this.locator.getService(RoutingContext.class, new Annotation[0]);
            ArrayList<Iterable<RankedProvider<ContainerResponseFilter>>> rankedProviders = new ArrayList<Iterable<RankedProvider<ContainerResponseFilter>>>(2);
            rankedProviders.add(this.filters);
            rankedProviders.add(rc.getBoundResponseFilters());
            Iterable sortedResponseFilters = Providers.mergeAndSortRankedProviders((RankedComparator)new RankedComparator(RankedComparator.Order.DESCENDING), rankedProviders);
            ContainerRequest request = responseContext.getRequestContext();
            request.getRequestEventBuilder().setContainerResponseFilters(sortedResponseFilters);
            request.triggerEvent(RequestEvent.Type.RESP_FILTERS_START);
            long timestamp = this.tracingLogger.timestamp((TracingLogger.Event)ServerTraceEvent.RESPONSE_FILTER_SUMMARY);
            int processedCount = 0;
            try {
                for (ContainerResponseFilter filter : sortedResponseFilters) {
                    long filterTimestamp = this.tracingLogger.timestamp((TracingLogger.Event)ServerTraceEvent.RESPONSE_FILTER);
                    try {
                        filter.filter((ContainerRequestContext)request, (ContainerResponseContext)responseContext);
                        ++processedCount;
                    }
                    catch (Exception ex) {
                        try {
                            throw new MappableException(ex);
                        }
                        catch (Throwable throwable) {
                            ++processedCount;
                            this.tracingLogger.logDuration((TracingLogger.Event)ServerTraceEvent.RESPONSE_FILTER, filterTimestamp, new Object[]{filter});
                            throw throwable;
                        }
                    }
                    this.tracingLogger.logDuration((TracingLogger.Event)ServerTraceEvent.RESPONSE_FILTER, filterTimestamp, new Object[]{filter});
                }
                request.triggerEvent(RequestEvent.Type.RESP_FILTERS_FINISHED);
            }
            catch (Throwable throwable) {
                request.triggerEvent(RequestEvent.Type.RESP_FILTERS_FINISHED);
                this.tracingLogger.logDuration((TracingLogger.Event)ServerTraceEvent.RESPONSE_FILTER_SUMMARY, timestamp, new Object[]{processedCount});
                throw throwable;
            }
            this.tracingLogger.logDuration((TracingLogger.Event)ServerTraceEvent.RESPONSE_FILTER_SUMMARY, timestamp, new Object[]{processedCount});
            return Stage.Continuation.of((Object)responseContext, (Stage)this.getDefaultNext());
        }
    }

    static class Builder {
        @Inject
        private ServiceLocator locator;
        @Inject
        private Provider<RespondingContext> respondingContextFactory;

        Builder() {
        }

        public ContainerFilteringStage build(Iterable<RankedProvider<ContainerRequestFilter>> requestFilters, Iterable<RankedProvider<ContainerResponseFilter>> responseFilters) {
            return new ContainerFilteringStage(this.respondingContextFactory, this.locator, requestFilters, responseFilters);
        }
    }
}

