/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.knox.gateway.util.NoClassNameMultiLineToStringStyle;

class KnoxShellTableCall {
    static final String KNOX_SHELL_TABLE_FILTER_TYPE = "org.apache.knox.gateway.shell.table.KnoxShellTableFilter";
    private final String invokerClass;
    private final String method;
    private boolean builderMethod;
    private final Map<Object, Class<?>> params;

    KnoxShellTableCall(String invokerClass, String method, boolean builderMethod, Map<Object, Class<?>> params) {
        this.invokerClass = invokerClass;
        this.method = method;
        this.builderMethod = builderMethod;
        this.params = params;
    }

    public String getInvokerClass() {
        return this.invokerClass;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isBuilderMethod() {
        return this.builderMethod;
    }

    public Map<Object, Class<?>> getParams() {
        return this.params == null ? Collections.emptyMap() : this.params;
    }

    @JsonIgnore
    boolean hasSensitiveData() {
        return "username".equals(this.getMethod()) || "pwd".equals(this.getMethod());
    }

    @JsonIgnore
    Class<?>[] getParameterTypes() {
        ArrayList parameterTypes = new ArrayList(this.params.size());
        if (KNOX_SHELL_TABLE_FILTER_TYPE.equals(this.invokerClass) && this.builderMethod) {
            parameterTypes.add(Comparable.class);
        } else {
            parameterTypes.addAll(this.params.values());
        }
        return parameterTypes.toArray(new Class[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)new NoClassNameMultiLineToStringStyle());
    }
}

