/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.session.control;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.session.control.ConcurrentSessionVerifier;

public class InMemoryConcurrentSessionVerifier
implements ConcurrentSessionVerifier {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private Set<String> privilegedUsers;
    private Set<String> unlimitedUsers;
    private int privilegedUserConcurrentSessionLimit;
    private int nonPrivilegedUserConcurrentSessionLimit;
    private Map<String, Set<SessionJWT>> concurrentSessionCounter;
    private final Lock sessionCountModifyLock = new ReentrantLock();
    private long cleaningPeriod;
    private final ScheduledExecutorService expiredTokenRemover = Executors.newSingleThreadScheduledExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerToken(String username, JWT jwtToken) {
        if (StringUtils.isBlank((CharSequence)username)) {
            LOG.errorRegisteringTokenForBlankUsername();
            return false;
        }
        if (this.unlimitedUsers.contains(username)) {
            return true;
        }
        this.sessionCountModifyLock.lock();
        try {
            if (this.checkLimitReached(username)) {
                boolean bl = false;
                return bl;
            }
            this.concurrentSessionCounter.putIfAbsent(username, new HashSet());
            this.concurrentSessionCounter.compute(username, (key, sessionTokenSet) -> this.addTokenForUser((Set<SessionJWT>)sessionTokenSet, jwtToken));
        }
        finally {
            this.sessionCountModifyLock.unlock();
        }
        return true;
    }

    public boolean verifySessionForUser(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            LOG.errorVerifyingUserBlankUsername();
            return false;
        }
        if (this.unlimitedUsers.contains(username)) {
            return true;
        }
        this.sessionCountModifyLock.lock();
        try {
            if (this.checkLimitReached(username)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.sessionCountModifyLock.unlock();
        }
        return true;
    }

    private boolean checkLimitReached(String username) {
        int validTokenNumber = this.countValidTokensForUser(username);
        return this.privilegedUserCheckLimitReached(username, validTokenNumber) || this.nonPrivilegedUserCheckLimitReached(username, validTokenNumber);
    }

    int countValidTokensForUser(String username) {
        return (int)this.concurrentSessionCounter.getOrDefault(username, Collections.emptySet()).stream().filter(each -> !each.hasExpired()).count();
    }

    private boolean privilegedUserCheckLimitReached(String username, int validTokenNumber) {
        if (this.privilegedUserConcurrentSessionLimit < 0) {
            return false;
        }
        return this.privilegedUsers.contains(username) && validTokenNumber >= this.privilegedUserConcurrentSessionLimit;
    }

    private boolean nonPrivilegedUserCheckLimitReached(String username, int validTokenNumber) {
        if (this.nonPrivilegedUserConcurrentSessionLimit < 0) {
            return false;
        }
        return !this.privilegedUsers.contains(username) && validTokenNumber >= this.nonPrivilegedUserConcurrentSessionLimit;
    }

    public void sessionEndedForUser(String username, String token) {
        if (StringUtils.isNotBlank((CharSequence)token) && StringUtils.isNotBlank((CharSequence)username)) {
            this.sessionCountModifyLock.lock();
            try {
                this.concurrentSessionCounter.computeIfPresent(username, (key, sessionTokenSet) -> this.removeTokenFromUser((Set<SessionJWT>)sessionTokenSet, token));
            }
            finally {
                this.sessionCountModifyLock.unlock();
            }
        }
    }

    private Set<SessionJWT> removeTokenFromUser(Set<SessionJWT> sessionTokenSet, String token) {
        sessionTokenSet.removeIf(sessionToken -> sessionToken.getToken().equals(token));
        if (sessionTokenSet.isEmpty()) {
            return null;
        }
        return sessionTokenSet;
    }

    private Set<SessionJWT> addTokenForUser(Set<SessionJWT> sessionTokenSet, JWT jwtToken) {
        sessionTokenSet.add(new SessionJWT(jwtToken));
        return sessionTokenSet;
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.privilegedUsers = config.getSessionVerificationPrivilegedUsers();
        this.unlimitedUsers = config.getSessionVerificationUnlimitedUsers();
        this.privilegedUserConcurrentSessionLimit = config.getPrivilegedUsersConcurrentSessionLimit();
        this.nonPrivilegedUserConcurrentSessionLimit = config.getNonPrivilegedUsersConcurrentSessionLimit();
        this.cleaningPeriod = config.getConcurrentSessionVerifierExpiredTokensCleaningPeriod();
        this.concurrentSessionCounter = new ConcurrentHashMap<String, Set<SessionJWT>>();
    }

    public void start() throws ServiceLifecycleException {
        this.expiredTokenRemover.scheduleAtFixedRate(this::removeExpiredTokens, this.cleaningPeriod, this.cleaningPeriod, TimeUnit.SECONDS);
    }

    public void stop() throws ServiceLifecycleException {
        this.expiredTokenRemover.shutdown();
    }

    void removeExpiredTokens() {
        this.sessionCountModifyLock.lock();
        try {
            Iterator<Map.Entry<String, Set<SessionJWT>>> concurrentSessionCounterIterator = this.concurrentSessionCounter.entrySet().iterator();
            while (concurrentSessionCounterIterator.hasNext()) {
                Set<SessionJWT> sessionJWTSet = concurrentSessionCounterIterator.next().getValue();
                sessionJWTSet.removeIf(session -> session.hasExpired());
                if (!sessionJWTSet.isEmpty()) continue;
                concurrentSessionCounterIterator.remove();
            }
        }
        finally {
            this.sessionCountModifyLock.unlock();
        }
    }

    Integer getTokenCountForUser(String username) {
        Integer result = null;
        if (this.concurrentSessionCounter.containsKey(username)) {
            result = this.concurrentSessionCounter.get(username).size();
        }
        return result;
    }

    public static class SessionJWT {
        private final Date expiry;
        private final String token;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionJWT that = (SessionJWT)o;
            return Objects.equals(this.token, that.token);
        }

        public int hashCode() {
            return Objects.hash(this.token);
        }

        public SessionJWT(JWT token) {
            this.expiry = token.getExpiresDate();
            this.token = token.toString();
        }

        public String getToken() {
            return this.token;
        }

        public boolean hasExpired() {
            return this.expiry != null && this.expiry.before(new Date());
        }
    }
}

