/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.tgs;

import java.net.URISyntaxException;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ServiceDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.topology.Service;

public class TGSDeploymentContributor
extends ServiceDeploymentContributorBase {
    private static final String TGS_EXTERNAL_PATH = "/tgs/api/v1";

    public String getRole() {
        return "TGS";
    }

    public String getName() {
        return "tgs";
    }

    public void contributeService(DeploymentContext context, Service service) throws URISyntaxException {
        ResourceDescriptor resource = context.getGatewayDescriptor().addResource();
        resource.role(service.getRole());
        resource.pattern("/tgs/api/v1/accesstoken");
        if (this.topologyContainsProviderType(context, "authentication")) {
            context.contributeFilter(service, resource, "authentication", null, null);
        }
        if (this.topologyContainsProviderType(context, "federation")) {
            context.contributeFilter(service, resource, "federation", null, null);
        }
        context.contributeFilter(service, resource, "identity-assertion", null, null);
    }
}

