/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.preauth.filter;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.preauth.filter.PreAuthService;
import org.apache.knox.gateway.preauth.filter.PreAuthValidator;

public class PreAuthFederationFilter
implements Filter {
    private static final String CUSTOM_HEADER_PARAM = "preauth.customHeader";
    private List<PreAuthValidator> validators;
    private FilterConfig filterConfig;
    private String headerName = "SM_USER";

    public void init(FilterConfig filterConfig) throws ServletException {
        String customHeader = filterConfig.getInitParameter(CUSTOM_HEADER_PARAM);
        if (customHeader != null) {
            this.headerName = customHeader;
        }
        this.filterConfig = filterConfig;
        this.validators = PreAuthService.getValidators(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpRequest.getHeader(this.headerName) != null) {
            if (PreAuthService.validate(httpRequest, this.filterConfig, this.validators)) {
                chain.doFilter(request, response);
            } else {
                ((HttpServletResponse)response).sendError(400, "Missing Required Header for SSO Validation");
            }
        } else {
            ((HttpServletResponse)response).sendError(400, "Missing Required Header for PreAuth SSO Federation");
        }
    }

    public void destroy() {
    }
}

