/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.ozone;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class OzoneServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "OZONE";
    public static final String SERVICE_TYPE = "OZONE";
    public static final String ROLE_TYPE = "OZONE_MANAGER";
    static final String SSL_ENABLED = "ssl_enabled";
    static final String HTTP_PORT = "ozone.om.http-port";
    static final String HTTPS_PORT = "ozone.om.https-port";

    @Override
    public String getService() {
        return "OZONE";
    }

    @Override
    public String getServiceType() {
        return "OZONE";
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.UI;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        String hostname = role.getHostRef().getHostname();
        boolean sslEnabled = Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, SSL_ENABLED));
        String scheme = sslEnabled ? "https" : "http";
        String httpPort = this.getRoleConfigValue(roleConfig, HTTP_PORT);
        String httpsPort = this.getRoleConfigValue(roleConfig, HTTPS_PORT);
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, sslEnabled ? httpsPort : httpPort));
        model.addRoleProperty(this.getRoleType(), SSL_ENABLED, this.getRoleConfigValue(roleConfig, SSL_ENABLED));
        model.addRoleProperty(this.getRoleType(), HTTP_PORT, httpPort);
        model.addRoleProperty(this.getRoleType(), HTTPS_PORT, httpsPort);
        return model;
    }
}

