/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import com.cloudera.api.swagger.RolesResourceApi;
import com.cloudera.api.swagger.ServicesResourceApi;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiRoleConfig;
import com.cloudera.api.swagger.model.ApiRoleConfigList;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import com.cloudera.api.swagger.model.ApiServiceList;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.topology.ClusterConfigurationMonitorService;
import org.apache.knox.gateway.topology.discovery.ClusterConfigurationMonitor;
import org.apache.knox.gateway.topology.discovery.ServiceDiscovery;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerCluster;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryRepository;
import org.apache.knox.gateway.topology.discovery.cm.DiscoveryApiClient;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGenerator;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGeneratorHandleResponse;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGeneratorsHolder;
import org.apache.knox.gateway.topology.discovery.cm.ServiceRoleCollector;
import org.apache.knox.gateway.topology.discovery.cm.ServiceRoleCollectorBuilder;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ClouderaManagerClusterConfigurationMonitor;

public class ClouderaManagerServiceDiscovery
implements ServiceDiscovery,
ClusterConfigurationMonitor.ConfigurationChangeListener {
    static final String TYPE = "ClouderaManager";
    private static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    private static final GatewaySpiMessages LOGGER = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    private static final String VIEW_SUMMARY = "summary";
    private static final String VIEW_FULL = "full";
    public static final String CM_SERVICE_TYPE = "CM";
    public static final String CM_ROLE_TYPE = "CM_SERVER";
    private static final ApiService CM_SERVICE = new ApiService().name("CM".toLowerCase(Locale.ROOT)).type("CM");
    private static final ApiRoleConfigList CM_SERVICE_ROLE_CONFIGS = new ApiRoleConfigList().addItemsItem(new ApiRoleConfig().name("CM_SERVER").roleType("CM_SERVER"));
    public static final String CORE_SETTINGS_TYPE = "CORE_SETTINGS";
    private ServiceModelGeneratorsHolder serviceModelGeneratorsHolder = ServiceModelGeneratorsHolder.getInstance();
    private boolean debug;
    private AliasService aliasService;
    private KeyStore truststore;
    private ClouderaManagerClusterConfigurationMonitor configChangeMonitor;
    private final ClouderaManagerServiceDiscoveryRepository repository = ClouderaManagerServiceDiscoveryRepository.getInstance();
    private final AtomicInteger retryAttempts = new AtomicInteger(0);
    private final int retrySleepSeconds = 3;
    private int maxRetryAttempts = -1;
    private Collection<String> excludedServiceTypes = Collections.emptySet();

    ClouderaManagerServiceDiscovery(GatewayConfig gatewayConfig) {
        this(false, gatewayConfig);
    }

    ClouderaManagerServiceDiscovery(boolean debug, GatewayConfig gatewayConfig) {
        GatewayServices gwServices = GatewayServer.getGatewayServices();
        if (gwServices != null) {
            this.aliasService = (AliasService)gwServices.getService(ServiceType.ALIAS_SERVICE);
            KeystoreService keystoreService = (KeystoreService)gwServices.getService(ServiceType.KEYSTORE_SERVICE);
            if (keystoreService != null) {
                try {
                    this.truststore = keystoreService.getTruststoreForHttpClient();
                }
                catch (KeystoreServiceException e) {
                    LOGGER.failedToLoadTruststore(e.getMessage(), (Exception)((Object)e));
                }
            }
        }
        this.debug = debug;
        this.configChangeMonitor = this.getConfigurationChangeMonitor();
        if (gatewayConfig != null) {
            this.repository.setCacheEntryTTL(gatewayConfig.getClouderaManagerServiceDiscoveryRepositoryEntryTTL());
            this.configureRetryParams(gatewayConfig);
            this.excludedServiceTypes = this.getLowercaseStringCollection(gatewayConfig.getClouderaManagerServiceDiscoveryExcludedServiceTypes());
        }
    }

    private Collection<String> getLowercaseStringCollection(Collection<String> original) {
        return original == null ? Collections.emptySet() : (Collection)original.stream().map(serviceType -> serviceType.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    }

    private void configureRetryParams(GatewayConfig gatewayConfig) {
        int configuredMaxRetryAttempts = gatewayConfig.getClouderaManagerServiceDiscoveryMaximumRetryAttempts();
        if (configuredMaxRetryAttempts > 0) {
            int configuredRetryDurationSeconds = configuredMaxRetryAttempts * 3;
            int pollingInterval = gatewayConfig.getClusterMonitorPollingInterval(ClouderaManagerClusterConfigurationMonitor.getType());
            int retryDurationLimit = pollingInterval / 2;
            if (retryDurationLimit > configuredRetryDurationSeconds) {
                this.maxRetryAttempts = configuredMaxRetryAttempts;
            } else {
                this.maxRetryAttempts = retryDurationLimit / 3;
                log.updateMaxRetryAttempts(configuredMaxRetryAttempts, this.maxRetryAttempts);
            }
        }
    }

    public String getType() {
        return TYPE;
    }

    private DiscoveryApiClient getClient(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig) {
        String discoveryAddress = discoveryConfig.getAddress();
        if (discoveryAddress == null || discoveryAddress.isEmpty()) {
            log.missingDiscoveryAddress();
            throw new IllegalArgumentException("Missing or invalid discovery address.");
        }
        DiscoveryApiClient client = new DiscoveryApiClient(gatewayConfig, discoveryConfig, this.aliasService, this.truststore);
        client.setDebugging(this.debug);
        return client;
    }

    private ClouderaManagerClusterConfigurationMonitor getConfigurationChangeMonitor() {
        ClouderaManagerClusterConfigurationMonitor cmMonitor = null;
        try {
            ClusterConfigurationMonitorService clusterMonitorService;
            ClusterConfigurationMonitor monitor;
            GatewayServices gwServices = GatewayServer.getGatewayServices();
            if (gwServices != null && (monitor = (clusterMonitorService = (ClusterConfigurationMonitorService)GatewayServer.getGatewayServices().getService(ServiceType.CLUSTER_CONFIGURATION_MONITOR_SERVICE)).getMonitor(ClouderaManagerClusterConfigurationMonitor.getType())) != null && ClouderaManagerClusterConfigurationMonitor.class.isAssignableFrom(monitor.getClass())) {
                cmMonitor = (ClouderaManagerClusterConfigurationMonitor)monitor;
                cmMonitor.addListener(this);
            }
        }
        catch (Exception e) {
            log.errorAccessingConfigurationChangeMonitor(e);
        }
        return cmMonitor;
    }

    public ClouderaManagerCluster discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig, String clusterName) {
        return this.discover(gatewayConfig, discoveryConfig, clusterName, (Collection)Collections.emptySet());
    }

    public ClouderaManagerCluster discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig, String clusterName, Collection<String> includedServices) {
        return this.discover(gatewayConfig, discoveryConfig, clusterName, includedServices, this.getClient(gatewayConfig, discoveryConfig));
    }

    protected ClouderaManagerCluster discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig, String clusterName, Collection<String> includedServices, DiscoveryApiClient client) {
        ClouderaManagerCluster cluster = null;
        if (clusterName == null || clusterName.isEmpty()) {
            log.missingDiscoveryCluster();
            throw new IllegalArgumentException("The cluster configuration is missing from, or invalid in, the discovery configuration.");
        }
        try {
            cluster = this.discoverCluster(gatewayConfig, client, clusterName, includedServices);
            if (this.configChangeMonitor != null && cluster != null) {
                this.configChangeMonitor.addServiceConfiguration(cluster, discoveryConfig);
            }
            this.resetRetryAttempts();
        }
        catch (ApiException e) {
            log.clusterDiscoveryError(clusterName, (Exception)((Object)e));
            if (this.shouldRetryServiceDiscovery(e)) {
                log.retryDiscovery(3L, this.retryAttempts.get());
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                cluster = this.discover(gatewayConfig, discoveryConfig, clusterName, includedServices, client);
            }
            this.resetRetryAttempts();
        }
        return cluster;
    }

    private void resetRetryAttempts() {
        this.retryAttempts.set(0);
    }

    private boolean shouldRetryServiceDiscovery(ApiException e) {
        Throwable cause;
        return this.maxRetryAttempts > 0 && this.maxRetryAttempts > this.retryAttempts.getAndIncrement() && (cause = e.getCause()) != null && (SocketException.class.isAssignableFrom(cause.getClass()) || SocketTimeoutException.class.isAssignableFrom(cause.getClass()) || UnknownHostException.class.isAssignableFrom(cause.getClass()));
    }

    private ClouderaManagerCluster discoverCluster(GatewayConfig gatewayConfig, DiscoveryApiClient client, String clusterName, Collection<String> includedServices) throws ApiException {
        ServicesResourceApi servicesResourceApi = new ServicesResourceApi((ApiClient)client);
        RolesResourceApi rolesResourceApi = new RolesResourceApi((ApiClient)client);
        ServiceRoleCollector roleCollector = ServiceRoleCollectorBuilder.newBuilder().gatewayConfig(gatewayConfig).rolesResourceApi(rolesResourceApi).build();
        log.discoveringCluster(clusterName);
        List<ApiService> serviceList = this.getClusterServices(client.getConfig(), servicesResourceApi);
        ApiServiceConfig coreSettingsConfig = this.coreSettingsConfig(client, servicesResourceApi, serviceList);
        HashSet<ServiceModel> serviceModels = new HashSet<ServiceModel>();
        for (ApiService service : serviceList) {
            serviceModels.addAll(this.discoverService(client, clusterName, includedServices, service, servicesResourceApi, roleCollector, coreSettingsConfig));
        }
        ClouderaManagerCluster cluster = new ClouderaManagerCluster(clusterName);
        cluster.addServiceModels(serviceModels);
        log.discoveredCluster(clusterName);
        return cluster;
    }

    private Set<ServiceModel> discoverService(DiscoveryApiClient client, String clusterName, Collection<String> includedServices, ApiService service, ServicesResourceApi servicesResourceApi, ServiceRoleCollector roleCollector, ApiServiceConfig coreSettingsConfig) throws ApiException {
        ApiRoleConfigList roleConfigList;
        HashSet<ServiceModel> serviceModels = new HashSet<ServiceModel>();
        List<ServiceModelGenerator> modelGenerators = this.serviceModelGeneratorsHolder.getServiceModelGenerators(service.getType());
        log.discoveringService(service.getName(), service.getType());
        ApiServiceConfig serviceConfig = null;
        if (!CM_SERVICE_TYPE.equals(service.getType()) && !CORE_SETTINGS_TYPE.equals(service.getType())) {
            serviceConfig = this.getServiceConfig(client.getConfig(), servicesResourceApi, service);
        }
        if ((roleConfigList = this.getAllServiceRoleConfigurations(client.getConfig(), roleCollector, clusterName, service)) != null && roleConfigList.getItems() != null) {
            ArrayList<ApiRole> allApiRoles = new ArrayList<ApiRole>();
            for (ApiRoleConfig roleConfig : roleConfigList.getItems()) {
                ApiRole role = new ApiRole().name(roleConfig.getName()).type(roleConfig.getRoleType()).hostRef(roleConfig.getHostRef());
                allApiRoles.add(role);
                ApiConfigList roleConfigs = roleConfig.getConfig();
                ServiceRoleDetails serviceRoleDetails = new ServiceRoleDetails(service, serviceConfig, role, roleConfigs);
                log.discoveringServiceRole(role.getName(), role.getType());
                Set<ServiceModel> modelsForRole = this.generateServiceModels(client, serviceRoleDetails, coreSettingsConfig, modelGenerators);
                log.discoveredServiceRole(role.getName(), role.getType());
                serviceModels.addAll(modelsForRole);
            }
            String allServiceRoles = allApiRoles.stream().map(r -> r.getName() + " (" + r.getType() + ")").collect(Collectors.joining(", "));
            log.processedServiceRoles(service.getName(), allServiceRoles);
        }
        log.discoveredService(service.getName(), service.getType());
        return serviceModels;
    }

    private Set<ServiceModel> generateServiceModels(DiscoveryApiClient client, ServiceRoleDetails serviceRoleDetails, ApiServiceConfig coreSettingsConfig, List<ServiceModelGenerator> modelGenerators) throws ApiException {
        HashSet<ServiceModel> serviceModels = new HashSet<ServiceModel>();
        if (modelGenerators != null) {
            for (ServiceModelGenerator serviceModelGenerator : modelGenerators) {
                ServiceModel serviceModel = ClouderaManagerServiceDiscovery.generateServiceModel(client, serviceRoleDetails, coreSettingsConfig, serviceModelGenerator);
                if (serviceModel == null) continue;
                serviceModels.add(serviceModel);
            }
        }
        return serviceModels;
    }

    private static ServiceModel generateServiceModel(DiscoveryApiClient client, ServiceRoleDetails sd, ApiServiceConfig coreSettingsConfig, ServiceModelGenerator serviceModelGenerator) throws ApiException {
        ServiceModelGeneratorHandleResponse response = serviceModelGenerator.handles(sd.getService(), sd.getServiceConfig(), sd.getRole(), sd.getRoleConfig());
        if (response.handled()) {
            serviceModelGenerator.setApiClient(client);
            return serviceModelGenerator.generateService(sd.getService(), sd.getServiceConfig(), sd.getRole(), sd.getRoleConfig(), coreSettingsConfig);
        }
        if (!response.getConfigurationIssues().isEmpty()) {
            log.serviceRoleHasConfigurationIssues(sd.getRole().getName(), String.join((CharSequence)";", response.getConfigurationIssues()));
        }
        return null;
    }

    private ApiServiceConfig coreSettingsConfig(DiscoveryApiClient client, ServicesResourceApi servicesResourceApi, List<ApiService> serviceList) throws ApiException {
        for (ApiService service : serviceList) {
            if (!CORE_SETTINGS_TYPE.equals(service.getType())) continue;
            return this.getServiceConfig(client.getConfig(), servicesResourceApi, service);
        }
        return null;
    }

    private boolean shouldSkipServiceDiscovery(List<ServiceModelGenerator> modelGenerators, Collection<String> includedServices) {
        if (includedServices == null || includedServices.isEmpty()) {
            return false;
        }
        if (modelGenerators != null) {
            for (ServiceModelGenerator modelGenerator : modelGenerators) {
                if (!includedServices.contains(modelGenerator.getService())) continue;
                return false;
            }
        }
        return true;
    }

    private List<ApiService> getClusterServices(ServiceDiscoveryConfig serviceDiscoveryConfig, ServicesResourceApi servicesResourceApi) throws ApiException {
        log.lookupClusterServicesFromRepository();
        List<Object> services = this.repository.getServices(serviceDiscoveryConfig);
        if (services.isEmpty()) {
            try {
                log.lookupClusterServicesFromCM();
                ApiServiceList serviceList = servicesResourceApi.readServices(serviceDiscoveryConfig.getCluster(), VIEW_SUMMARY);
                services = serviceList == null ? new ArrayList() : serviceList.getItems();
                services = services.stream().filter(service -> {
                    if (this.excludedServiceTypes.contains(service.getType().toLowerCase(Locale.ROOT))) {
                        log.skipServiceDiscovery(service.getName(), service.getType());
                        return false;
                    }
                    return true;
                }).collect(Collectors.toList());
                services.forEach(service -> this.repository.addService(serviceDiscoveryConfig, (ApiService)service));
            }
            catch (ApiException e) {
                log.failedToAccessServiceConfigs(serviceDiscoveryConfig.getCluster(), (Exception)((Object)e));
                throw e;
            }
        }
        services.add(CM_SERVICE);
        return services;
    }

    private ApiServiceConfig getServiceConfig(ServiceDiscoveryConfig serviceDiscoveryConfig, ServicesResourceApi servicesResourceApi, ApiService service) throws ApiException {
        log.lookupServiceConfigsFromRepository();
        ApiServiceConfig serviceConfig = this.repository.getServiceConfig(serviceDiscoveryConfig, service);
        if (serviceConfig == null) {
            try {
                log.lookupServiceConfigsFromCM();
                serviceConfig = servicesResourceApi.readServiceConfig(serviceDiscoveryConfig.getCluster(), service.getName(), VIEW_FULL);
                this.repository.addServiceConfig(serviceDiscoveryConfig, service, serviceConfig);
            }
            catch (ApiException e) {
                log.failedToAccessServiceConfigs(serviceDiscoveryConfig.getCluster(), (Exception)((Object)e));
                throw e;
            }
        }
        return serviceConfig;
    }

    private ApiRoleConfigList getAllServiceRoleConfigurations(ServiceDiscoveryConfig serviceDiscoveryConfig, ServiceRoleCollector roleCollector, String clusterName, ApiService service) throws ApiException {
        log.lookupRolesFromRepository();
        ApiRoleConfigList roleConfigs = this.repository.getServiceRoleConfigs(serviceDiscoveryConfig, service);
        if (roleConfigs == null) {
            String serviceName = service.getName();
            try {
                if (CM_SERVICE_TYPE.equalsIgnoreCase(serviceName)) {
                    roleConfigs = CM_SERVICE_ROLE_CONFIGS;
                } else if (CORE_SETTINGS_TYPE.equalsIgnoreCase(serviceName)) {
                    log.noRoles();
                } else {
                    log.lookupRoleConfigsFromCM();
                    roleConfigs = roleCollector.getAllServiceRoleConfigurations(clusterName, serviceName);
                }
                if (roleConfigs != null) {
                    this.repository.setServiceRoleConfigs(serviceDiscoveryConfig, service, roleConfigs);
                }
            }
            catch (ApiException e) {
                log.failedToAccessServiceRoleConfigs(serviceName, "N/A", clusterName, (Exception)((Object)e));
                throw e;
            }
        }
        return roleConfigs;
    }

    public void onConfigurationChange(String source, String clusterName) {
        log.clearServiceDiscoveryRepository();
        this.repository.clear();
    }

    private static class ServiceRoleDetails {
        private final ApiService service;
        private final ApiServiceConfig serviceConfig;
        private final ApiRole role;
        private final ApiConfigList roleConfig;

        ServiceRoleDetails(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
            this.service = service;
            this.serviceConfig = serviceConfig;
            this.role = role;
            this.roleConfig = roleConfig;
        }

        public ApiService getService() {
            return this.service;
        }

        public ApiServiceConfig getServiceConfig() {
            return this.serviceConfig;
        }

        public ApiRole getRole() {
            return this.role;
        }

        public ApiConfigList getRoleConfig() {
            return this.roleConfig;
        }
    }
}

