/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.direct;

import org.pac4j.cas.authorization.DefaultCasAuthorizationGenerator;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.cas.credentials.authenticator.CasAuthenticator;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.ParameterExtractor;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.util.CommonHelper;

public class DirectCasProxyClient
extends DirectClient<TokenCredentials> {
    private CasConfiguration configuration;
    private UrlResolver urlResolver = new DefaultUrlResolver();
    private CallbackUrlResolver callbackUrlResolver = new NoParameterCallbackUrlResolver();
    private String serviceUrl;

    public DirectCasProxyClient() {
    }

    public DirectCasProxyClient(CasConfiguration casConfiguration, String serviceUrl) {
        this.configuration = casConfiguration;
        this.serviceUrl = serviceUrl;
    }

    protected void clientInit() {
        CommonHelper.assertNotNull((String)"urlResolver", (Object)this.urlResolver);
        CommonHelper.assertNotNull((String)"callbackUrlResolver", (Object)this.callbackUrlResolver);
        CommonHelper.assertNotBlank((String)"serviceUrl", (String)this.serviceUrl);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        CasProtocol protocol = this.configuration.getProtocol();
        CommonHelper.assertTrue((protocol == CasProtocol.CAS20_PROXY || protocol == CasProtocol.CAS30_PROXY ? 1 : 0) != 0, (String)"The DirectCasProxyClient must be configured with a CAS proxy protocol (CAS20_PROXY or CAS30_PROXY)");
        this.defaultCredentialsExtractor((CredentialsExtractor)new ParameterExtractor("ticket", true, false));
        this.defaultAuthenticator(new CasAuthenticator(this.configuration, this.getName(), this.urlResolver, this.callbackUrlResolver, this.serviceUrl));
        this.addAuthorizationGenerator(new DefaultCasAuthorizationGenerator());
    }

    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public UrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    public void setUrlResolver(UrlResolver urlResolver) {
        this.urlResolver = urlResolver;
    }

    public CallbackUrlResolver getCallbackUrlResolver() {
        return this.callbackUrlResolver;
    }

    public void setCallbackUrlResolver(CallbackUrlResolver callbackUrlResolver) {
        this.callbackUrlResolver = callbackUrlResolver;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "authorizationGenerators", this.getAuthorizationGenerators(), "configuration", this.configuration, "callbackUrlResolver", this.callbackUrlResolver, "serviceUrl", this.serviceUrl, "urlResolver", this.urlResolver});
    }
}

