/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.factory.AliasServiceFactory;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.impl.ZookeeperRemoteAliasService;
import org.apache.knox.gateway.services.security.token.TokenMetadata;
import org.apache.knox.gateway.services.token.RemoteTokenStateChangeListener;
import org.apache.knox.gateway.services.token.impl.AliasBasedTokenStateService;
import org.apache.knox.gateway.util.Tokens;

public class ZookeeperTokenStateService
extends AliasBasedTokenStateService
implements RemoteTokenStateChangeListener {
    private final GatewayServices gatewayServices;
    private final AliasServiceFactory aliasServiceFactory;

    public ZookeeperTokenStateService(GatewayServices gatewayServices) {
        this(gatewayServices, new AliasServiceFactory());
    }

    public ZookeeperTokenStateService(GatewayServices gatewayServices, AliasServiceFactory aliasServiceFactory) {
        this.gatewayServices = gatewayServices;
        this.aliasServiceFactory = aliasServiceFactory;
    }

    @Override
    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        ZookeeperRemoteAliasService zookeeperAliasService = (ZookeeperRemoteAliasService)this.aliasServiceFactory.create(this.gatewayServices, ServiceType.ALIAS_SERVICE, config, options, ZookeeperRemoteAliasService.class.getName());
        options.put("zkShouldCreateTokenSubnodes", "true");
        options.put("zkShouldUseLocalAlias", "false");
        zookeeperAliasService.registerRemoteTokenStateChangeListener(this);
        zookeeperAliasService.init(config, options);
        super.setAliasService((AliasService)zookeeperAliasService);
        super.init(config, options);
        options.remove("zkShouldCreateTokenSubnodes");
        options.remove("zkShouldUseLocalAlias");
    }

    @Override
    protected void loadTokenAliasesFromPersistenceStore() {
    }

    @Override
    protected boolean readyForEviction() {
        return true;
    }

    @Override
    protected char[] getPasswordUsingAliasService(String alias) throws AliasServiceException {
        char[] password = super.getPasswordUsingAliasService(alias);
        if (password == null) {
            password = this.retry(alias);
        }
        return password;
    }

    private char[] retry(String alias) throws AliasServiceException {
        char[] password = null;
        Instant timeLimit = Instant.now().plusSeconds(this.statePersistenceInterval).plusSeconds(1L);
        while (password == null && timeLimit.isAfter(Instant.now())) {
            try {
                TimeUnit.SECONDS.sleep(1L);
                log.retryZkFetchAlias(this.getDisplayableAliasText(alias));
                password = super.getPasswordUsingAliasService(alias);
            }
            catch (InterruptedException e) {
                log.failedRetryZkFetchAlias(this.getDisplayableAliasText(alias), e.getMessage(), e);
            }
        }
        return password;
    }

    @Override
    public void onChanged(String alias, String updatedState) {
        this.processAlias(alias, updatedState);
        log.onRemoteTokenStateChanged(this.getDisplayableAliasText(alias));
    }

    @Override
    public void onRemoved(String alias) {
        String tokenId = this.getTokenIdFromAlias(alias);
        this.removeTokensFromMemory(Collections.singleton(tokenId));
        log.onRemoteTokenStateRemoval(this.getDisplayableAliasText(alias));
    }

    private void processAlias(String alias, String value) {
        if (!"tokens".equals(alias)) {
            try {
                String tokenId = this.getTokenIdFromAlias(alias);
                if (alias.endsWith("--max")) {
                    long maxLifeTime = Long.parseLong(value);
                    this.setMaxLifetime(tokenId, maxLifeTime);
                } else if (alias.endsWith("--meta")) {
                    this.addMetadataInMemory(tokenId, TokenMetadata.fromJSON((String)value));
                } else if (alias.endsWith("--iss")) {
                    this.setIssueTimeInMemory(tokenId, Long.parseLong(value));
                } else {
                    long expiration = Long.parseLong(value);
                    this.updateExpirationInMemory(tokenId, expiration);
                }
            }
            catch (Throwable e) {
                log.errorWhileProcessingTokenAlias(this.getDisplayableAliasText(alias), e.getMessage(), e);
            }
        }
    }

    private String getTokenIdFromAlias(String alias) {
        return alias.contains("--") ? alias.substring(0, alias.indexOf("--")) : alias;
    }

    private String getDisplayableAliasText(String alias) {
        String tokenId = this.getTokenIdFromAlias(alias);
        String suffix = alias.length() > tokenId.length() ? alias.substring(tokenId.length()) : "";
        return Tokens.getTokenIDDisplayText((String)tokenId) + suffix;
    }
}

