/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.transport;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.BindingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPPostSimpleSignEncoder;
import org.pac4j.saml.transport.Pac4jSAMLResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pac4jHTTPPostSimpleSignEncoder
extends HTTPPostSimpleSignEncoder {
    private static final Logger log = LoggerFactory.getLogger(Pac4jHTTPPostSimpleSignEncoder.class);
    private final Pac4jSAMLResponse responseAdapter;

    public Pac4jHTTPPostSimpleSignEncoder(Pac4jSAMLResponse responseAdapter) {
        this.responseAdapter = responseAdapter;
        this.setVelocityTemplateId("/templates/saml2-post-simplesign-binding.vm");
    }

    protected URI getEndpointURL(MessageContext<SAMLObject> messageContext) throws MessageEncodingException {
        try {
            return SAMLBindingSupport.getEndpointURL(messageContext);
        }
        catch (BindingException e) {
            throw new MessageEncodingException("Could not obtain message endpoint URL", (Exception)((Object)e));
        }
    }

    protected void postEncode(MessageContext<SAMLObject> messageContext, String endpointURL) throws MessageEncodingException {
        log.debug("Invoking Velocity template to create POST body");
        try {
            VelocityContext velocityContext = new VelocityContext();
            this.populateVelocityContext(velocityContext, messageContext, endpointURL);
            this.responseAdapter.setContentType("text/html");
            this.responseAdapter.init();
            OutputStreamWriter out = this.responseAdapter.getOutputStreamWriter();
            this.getVelocityEngine().mergeTemplate(this.getVelocityTemplateId(), "UTF-8", (Context)velocityContext, (Writer)out);
            out.flush();
        }
        catch (Exception e) {
            throw new MessageEncodingException("Error creating output document", e);
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        log.debug("Initialized {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        if (this.getMessageContext() == null) {
            throw new ComponentInitializationException("Message context cannot be null");
        }
        if (this.getVelocityEngine() == null) {
            throw new ComponentInitializationException("VelocityEngine must be supplied");
        }
        if (this.getVelocityTemplateId() == null) {
            throw new ComponentInitializationException("Velocity template id must be supplied");
        }
    }
}

