/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.yahoo;

import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.profile.creator.OAuth10ProfileCreator;
import org.pac4j.oauth.profile.definition.OAuth10ProfileDefinition;
import org.pac4j.oauth.profile.yahoo.YahooProfile;

public class YahooProfileCreator
extends OAuth10ProfileCreator<YahooProfile> {
    public YahooProfileCreator(OAuth10Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    @Override
    protected YahooProfile retrieveUserProfileFromToken(WebContext context, OAuth1AccessToken accessToken) {
        OAuth10ProfileDefinition profileDefinition = (OAuth10ProfileDefinition)((OAuth10Configuration)this.configuration).getProfileDefinition();
        String profileUrl = profileDefinition.getProfileUrl(accessToken, this.configuration);
        OAuth10aService service = (OAuth10aService)((OAuth10Configuration)this.configuration).buildService(context, this.client, null);
        String body = this.sendRequestForData(service, accessToken, profileUrl, profileDefinition.getProfileVerb());
        String guid = CommonHelper.substringBetween((String)body, (String)"<value>", (String)"</value>");
        this.logger.debug("guid : {}", (Object)guid);
        if (CommonHelper.isBlank((String)guid)) {
            throw new HttpCommunicationException("Cannot find guid from body : " + body);
        }
        body = this.sendRequestForData(service, accessToken, "https://social.yahooapis.com/v1/user/" + guid + "/profile?format=json", Verb.GET);
        YahooProfile profile = (YahooProfile)((Object)((OAuth10Configuration)this.configuration).getProfileDefinition().extractUserProfile(body));
        this.addAccessTokenToProfile(profile, accessToken);
        return profile;
    }
}

