/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.client;

import org.springframework.core.codec.ByteArrayDecoder;
import org.springframework.core.codec.ByteArrayEncoder;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.Assert;
import org.springframework.vault.client.SimpleVaultEndpointProvider;
import org.springframework.vault.client.VaultClients;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilderFactory;

public class ReactiveVaultClients {
    public static WebClient createWebClient(VaultEndpoint endpoint, ClientHttpConnector connector) {
        return ReactiveVaultClients.createWebClient(SimpleVaultEndpointProvider.of(endpoint), connector);
    }

    public static WebClient createWebClient(VaultEndpointProvider endpointProvider, ClientHttpConnector connector) {
        Assert.notNull((Object)endpointProvider, (String)"VaultEndpointProvider must not be null");
        Assert.notNull((Object)connector, (String)"ClientHttpConnector must not be null");
        UriBuilderFactory uriBuilderFactory = VaultClients.createUriBuilderFactory(endpointProvider);
        ExchangeStrategies strategies = ExchangeStrategies.builder().codecs(configurer -> {
            CodecConfigurer.CustomCodecs cc = configurer.customCodecs();
            cc.decoder((Decoder)new ByteArrayDecoder());
            cc.decoder((Decoder)new Jackson2JsonDecoder());
            cc.decoder((Decoder)StringDecoder.allMimeTypes((boolean)false));
            cc.encoder((Encoder)new ByteArrayEncoder());
            cc.encoder((Encoder)new Jackson2JsonEncoder());
        }).build();
        return WebClient.builder().uriBuilderFactory(uriBuilderFactory).exchangeStrategies(strategies).clientConnector(connector).build();
    }
}

