/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.base.spec.se.manifest;

import java.util.jar.Attributes;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestAppletDef;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestEntryDef;
import org.jboss.shrinkwrap.descriptor.impl.base.spec.se.manifest.ManifestAppletDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.base.spec.se.manifest.ManifestCommonDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.base.spec.se.manifest.ManifestEntryDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.base.spec.se.manifest.ManifestModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestDescriptorImpl
extends ManifestCommonDefImpl<ManifestDescriptor>
implements ManifestDescriptor {
    private final String descriptorName;
    private final ManifestModel manifest;

    public ManifestDescriptorImpl(String descriptionName) {
        this(descriptionName, new ManifestModel());
    }

    public ManifestDescriptorImpl(String descriptorName, ManifestModel manifest) {
        this.descriptorName = descriptorName;
        this.manifest = manifest;
        if (!manifest.getMainAttributes().containsValue(Attributes.Name.MANIFEST_VERSION)) {
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
    }

    @Override
    ManifestDescriptor getDescriptor() {
        return this;
    }

    public ManifestDescriptor main() {
        return this;
    }

    public ManifestEntryDef entry(String name) {
        return new ManifestEntryDefImpl(this, this.manifest, name);
    }

    public ManifestAppletDef applet(String name) {
        return new ManifestAppletDefImpl(this.descriptorName, this.manifest, name);
    }

    public ManifestDescriptor extensionName(String name) {
        this.includeAttribute(Attributes.Name.EXTENSION_NAME, name);
        return this;
    }

    public ManifestDescriptor extensionInstallation(String installation) {
        this.includeAttribute(Attributes.Name.EXTENSION_INSTALLATION, installation);
        return this;
    }

    @Override
    void includeAttribute(Attributes.Name name, String value) {
        this.manifest.getMainAttributes().put(name, value);
    }

    @Override
    String findAttribute(Attributes.Name name) {
        return this.manifest.getMainAttributes().getValue(name);
    }

    public String getDescriptorName() {
        return this.descriptorName;
    }

    @Override
    ManifestModel getManifestModel() {
        return this.manifest;
    }
}

