/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.redirect;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.oauth.OAuth20Service;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.redirect.RedirectActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20RedirectActionBuilder
implements RedirectActionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(OAuth20RedirectActionBuilder.class);
    protected OAuth20Configuration configuration;
    protected IndirectClient client;

    public OAuth20RedirectActionBuilder(OAuth20Configuration configuration, IndirectClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)client);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
        this.client = client;
    }

    public RedirectAction redirect(WebContext context) {
        try {
            OAuth20Service service;
            if (this.configuration.isWithState()) {
                String state = this.getStateParameter();
                logger.debug("save sessionState: {}", (Object)state);
                context.getSessionStore().set(context, this.configuration.getStateSessionAttributeName(this.client.getName()), (Object)state);
                service = (OAuth20Service)this.configuration.buildService(context, this.client, state);
            } else {
                service = (OAuth20Service)this.configuration.buildService(context, this.client, null);
            }
            String authorizationUrl = service.getAuthorizationUrl(this.configuration.getCustomParams());
            logger.debug("authorizationUrl: {}", (Object)authorizationUrl);
            return RedirectAction.redirect((String)authorizationUrl);
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected String getStateParameter() {
        String stateData = this.configuration.getStateData();
        String stateParameter = CommonHelper.isNotBlank((String)stateData) ? stateData : CommonHelper.randomString((int)10);
        return stateParameter;
    }
}

