/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.orcid;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.OAuth2AccessToken;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;
import org.pac4j.oauth.profile.orcid.OrcidProfile;
import org.pac4j.scribe.model.OrcidToken;

public class OrcidProfileDefinition
extends OAuth20ProfileDefinition<OrcidProfile, OAuth20Configuration> {
    public static final String ORCID = "path";
    public static final String FIRST_NAME = "given-names";
    public static final String FAMILY_NAME = "family-name";
    public static final String URI = "uri";
    public static final String CREATION_METHOD = "creation-method";
    public static final String CLAIMED = "claimed";

    public OrcidProfileDefinition() {
        super(x -> new OrcidProfile());
        this.primary(ORCID, (AttributeConverter)Converters.STRING);
        this.primary(FIRST_NAME, (AttributeConverter)Converters.STRING);
        this.primary(FAMILY_NAME, (AttributeConverter)Converters.STRING);
        this.primary(URI, (AttributeConverter)Converters.URL);
        this.primary(CREATION_METHOD, (AttributeConverter)Converters.STRING);
        this.primary(CLAIMED, (AttributeConverter)Converters.BOOLEAN);
    }

    @Override
    public String getProfileUrl(OAuth2AccessToken accessToken, OAuth20Configuration configuration) {
        if (accessToken instanceof OrcidToken) {
            return String.format("https://api.orcid.org/v1.1/%s/orcid-profile", ((OrcidToken)accessToken).getOrcid());
        }
        throw new OAuthException("Token in getProfileUrl is not an OrcidToken");
    }

    @Override
    public OrcidProfile extractUserProfile(String body) {
        OrcidProfile profile = (OrcidProfile)this.newProfile(new Object[0]);
        if (body == null || body.isEmpty()) {
            this.raiseProfileExtractionError(body);
        }
        profile.setId(CommonHelper.substringBetween((String)body, (String)"<path>", (String)"</path>"));
        for (String attribute : this.getPrimaryAttributes()) {
            this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, CommonHelper.substringBetween((String)body, (String)("<" + attribute + ">"), (String)("</" + attribute + ">")));
        }
        return profile;
    }
}

