/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.crypto;

import java.util.ArrayList;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.crypto.DecryptionProvider;

public class KeyStoreDecryptionProvider
implements DecryptionProvider {
    private static final ChainingEncryptedKeyResolver encryptedKeyResolver;
    private final CredentialProvider credentialProvider;

    public KeyStoreDecryptionProvider(CredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }

    @Override
    public final Decrypter build() {
        Credential encryptionCredential = this.credentialProvider.getCredential();
        StaticKeyInfoCredentialResolver resolver = new StaticKeyInfoCredentialResolver(encryptionCredential);
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)resolver, (EncryptedKeyResolver)encryptedKeyResolver);
        decrypter.setRootInNewDocument(true);
        return decrypter;
    }

    static {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new InlineEncryptedKeyResolver());
        list.add(new EncryptedElementTypeEncryptedKeyResolver());
        list.add(new SimpleRetrievalMethodEncryptedKeyResolver());
        encryptedKeyResolver = new ChainingEncryptedKeyResolver(list);
    }
}

