/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.descriptor.xml;

import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.knox.gateway.descriptor.FilterDescriptor;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.GatewayDescriptor;
import org.apache.knox.gateway.descriptor.GatewayDescriptorExporter;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.descriptor.xml.XmlGatewayDescriptorTags;
import org.apache.knox.gateway.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlGatewayDescriptorExporter
implements GatewayDescriptorExporter,
XmlGatewayDescriptorTags {
    public String getFormat() {
        return "xml";
    }

    public void store(GatewayDescriptor descriptor, Writer writer) throws IOException {
        try {
            Document document = XmlUtils.createDocument();
            Element gateway = document.createElement("gateway");
            document.appendChild(gateway);
            for (ResourceDescriptor resource : descriptor.resources()) {
                gateway.appendChild(XmlGatewayDescriptorExporter.createResource(document, resource));
            }
            XmlUtils.writeXml((Document)document, (Writer)writer);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    private static Element createResource(Document dom, ResourceDescriptor resource) {
        Element element = dom.createElement("resource");
        String role = resource.role();
        if (role != null) {
            XmlGatewayDescriptorExporter.addTextElement(dom, element, "role", role);
        }
        XmlGatewayDescriptorExporter.addTextElement(dom, element, "pattern", resource.pattern());
        for (FilterDescriptor filter : resource.filters()) {
            element.appendChild(XmlGatewayDescriptorExporter.createFilter(dom, filter));
        }
        return element;
    }

    private static Element createFilter(Document dom, FilterDescriptor filter) {
        String name;
        Element element = dom.createElement("filter");
        String role = filter.role();
        if (role != null) {
            XmlGatewayDescriptorExporter.addTextElement(dom, element, "role", filter.role());
        }
        if ((name = filter.name()) != null) {
            XmlGatewayDescriptorExporter.addTextElement(dom, element, "name", filter.name());
        }
        XmlGatewayDescriptorExporter.addTextElement(dom, element, "class", filter.impl());
        for (FilterParamDescriptor param : filter.params()) {
            element.appendChild(XmlGatewayDescriptorExporter.createFilterParam(dom, param));
        }
        return element;
    }

    private static Element createFilterParam(Document dom, FilterParamDescriptor param) {
        Element element = dom.createElement("param");
        XmlGatewayDescriptorExporter.addTextElement(dom, element, "name", param.name());
        XmlGatewayDescriptorExporter.addTextElement(dom, element, "value", param.value());
        return element;
    }

    private static void addTextElement(Document doc, Element parent, String tag, String text) {
        if (text != null) {
            Element element = doc.createElement(tag);
            element.appendChild(doc.createTextNode(text));
            parent.appendChild(element);
        }
    }
}

