/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.ext;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.PassThroughMetadata;
import org.apache.aries.blueprint.ext.AbstractPropertyPlaceholder;
import org.apache.aries.blueprint.ext.evaluator.PropertyEvaluator;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyPlaceholder
extends AbstractPropertyPlaceholder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyPlaceholder.class);
    private Map defaultProperties;
    private Properties properties;
    private List<URL> locations;
    private boolean ignoreMissingLocations;
    private SystemProperties systemProperties = SystemProperties.fallback;
    private PropertyEvaluator evaluator = null;
    private ExtendedBlueprintContainer container;

    public Map getDefaultProperties() {
        return this.defaultProperties;
    }

    public void setDefaultProperties(Map defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public List<URL> getLocations() {
        return this.locations;
    }

    public void setLocations(List<URL> locations) {
        this.locations = locations;
    }

    public boolean isIgnoreMissingLocations() {
        return this.ignoreMissingLocations;
    }

    public void setIgnoreMissingLocations(boolean ignoreMissingLocations) {
        this.ignoreMissingLocations = ignoreMissingLocations;
    }

    public SystemProperties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(SystemProperties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(PropertyEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        this.properties = new Properties();
        if (this.locations != null) {
            for (URL url : this.locations) {
                InputStream is = null;
                try {
                    is = url.openStream();
                }
                catch (IOException e) {
                    if (this.ignoreMissingLocations) {
                        LOGGER.debug("Unable to load properties from url " + url + " while ignoreMissingLocations is set to true");
                    }
                    throw e;
                }
                if (is == null) continue;
                try {
                    this.properties.load(is);
                }
                finally {
                    is.close();
                }
            }
        }
    }

    @Override
    public void process(ComponentDefinitionRegistry registry) throws ComponentDefinitionException {
        this.container = (ExtendedBlueprintContainer)((PassThroughMetadata)registry.getComponentDefinition("blueprintContainer")).getObject();
        super.process(registry);
    }

    @Override
    protected String getProperty(String val) {
        LOGGER.debug("Retrieving property {}", (Object)val);
        String v = null;
        if (v == null && this.systemProperties == SystemProperties.override && (v = this.getSystemProperty(val)) != null) {
            LOGGER.debug("Found system property {} with value {}", (Object)val, (Object)v);
        }
        if (v == null && this.properties != null && (v = this.properties.getProperty(val)) != null) {
            LOGGER.debug("Found property {} from locations with value {}", (Object)val, (Object)v);
        }
        if (v == null && this.systemProperties == SystemProperties.fallback && (v = this.getSystemProperty(val)) != null) {
            LOGGER.debug("Found system property {} with value {}", (Object)val, (Object)v);
        }
        if (v == null && this.defaultProperties != null && (v = this.defaultProperties.get(val)) != null) {
            LOGGER.debug("Retrieved property {} value from defaults {}", (Object)val, (Object)v);
        }
        if (v == null) {
            LOGGER.debug("Property {} not found", (Object)val);
        }
        return v != null ? v.toString() : null;
    }

    protected String getSystemProperty(String val) {
        if (val.startsWith("env:")) {
            return System.getenv(val.substring("env:".length()));
        }
        if (val.startsWith("static:")) {
            int idx = (val = val.substring("static:".length())).indexOf(35);
            if (idx <= 0 || idx == val.length() - 1) {
                throw new IllegalArgumentException("Bad syntax: " + val);
            }
            String clazz = val.substring(0, idx);
            String name = val.substring(idx + 1);
            try {
                Class cl = this.container.loadClass(clazz);
                Field field = null;
                try {
                    field = cl.getField(name);
                }
                catch (NoSuchFieldException e) {
                    while (field == null && cl != null) {
                        try {
                            field = cl.getDeclaredField(name);
                        }
                        catch (NoSuchFieldException t) {
                            cl = cl.getSuperclass();
                        }
                    }
                }
                if (field == null) {
                    throw new NoSuchFieldException(name);
                }
                Object obj = field.get(null);
                return obj != null ? obj.toString() : null;
            }
            catch (Throwable t) {
                LOGGER.warn("Unable to retrieve static field: " + val + " (" + t + ")");
            }
        }
        return System.getProperty(val);
    }

    @Override
    protected String retrieveValue(String expression) {
        LOGGER.debug("Retrieving Value from expression: {}", (Object)expression);
        if (this.evaluator == null) {
            return super.retrieveValue(expression);
        }
        return this.evaluator.evaluate(expression, new Dictionary<String, String>(){

            @Override
            public String get(Object key) {
                return PropertyPlaceholder.this.getProperty((String)key);
            }

            @Override
            public String put(String key, String value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Enumeration<String> elements() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isEmpty() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Enumeration<String> keys() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String remove(Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }
        });
    }

    public static enum SystemProperties {
        never,
        fallback,
        override;

    }
}

