/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal;

import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.ops4j.pax.logging.spi.PaxLevel;
import org.ops4j.pax.logging.spi.PaxLocationInfo;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

public class PaxLoggingEventImpl
implements PaxLoggingEvent {
    private final LogEvent event;

    public PaxLoggingEventImpl(LogEvent event) {
        this.event = event;
    }

    public PaxLocationInfo getLocationInformation() {
        return new PaxLocationInfoImpl(this.event.getSource());
    }

    public PaxLevel getLevel() {
        return new PaxLevelImpl(this.event.getLevel());
    }

    public String getLoggerName() {
        return this.event.getLoggerName();
    }

    public String getMessage() {
        return this.event.getMessage().getFormattedMessage();
    }

    public String getRenderedMessage() {
        return this.event.getMessage().getFormattedMessage();
    }

    public String getThreadName() {
        return this.event.getThreadName();
    }

    public String[] getThrowableStrRep() {
        ThrowableProxy t = this.event.getThrownProxy();
        return t != null ? t.getExtendedStackTraceAsString("").split("\n") : null;
    }

    public boolean locationInformationExists() {
        return this.event.isIncludeLocation();
    }

    public long getTimeStamp() {
        return this.event.getTimeMillis();
    }

    public String getFQNOfLoggerClass() {
        return this.event.getLoggerFqcn();
    }

    public Map getProperties() {
        return this.event.getContextMap();
    }

    static {
        new PaxLocationInfoImpl(null);
        new PaxLevelImpl(Level.DEBUG);
    }

    static class PaxLevelImpl
    implements PaxLevel {
        public static final int SYSLOG_DEBUG = 7;
        public static final int SYSLOG_INFO = 6;
        public static final int SYSLOG_WARN = 4;
        public static final int SYSLOG_ERROR = 3;
        public static final int SYSLOG_OFF = 0;
        private final Level level;

        public PaxLevelImpl(Level level) {
            this.level = level;
        }

        public boolean isGreaterOrEqual(PaxLevel r) {
            return this.getSyslogEquivalent() <= r.getSyslogEquivalent();
        }

        public int toInt() {
            int lvl = this.level.intLevel();
            if (lvl <= Level.ERROR.intLevel()) {
                return 4;
            }
            if (lvl <= Level.WARN.intLevel()) {
                return 3;
            }
            if (lvl <= Level.INFO.intLevel()) {
                return 2;
            }
            if (lvl <= Level.DEBUG.intLevel()) {
                return 1;
            }
            return 0;
        }

        public int getSyslogEquivalent() {
            int lvl = this.level.intLevel();
            if (lvl <= Level.OFF.intLevel()) {
                return 0;
            }
            if (lvl <= Level.ERROR.intLevel()) {
                return 3;
            }
            if (lvl <= Level.WARN.intLevel()) {
                return 4;
            }
            if (lvl <= Level.INFO.intLevel()) {
                return 6;
            }
            return 7;
        }

        public String toString() {
            return this.level.toString();
        }
    }

    static class PaxLocationInfoImpl
    implements PaxLocationInfo {
        private final StackTraceElement source;

        public PaxLocationInfoImpl(StackTraceElement source) {
            this.source = source;
        }

        public String getFileName() {
            String s = this.source != null ? this.source.getFileName() : null;
            return s != null ? s : "?";
        }

        public String getClassName() {
            String s = this.source != null ? this.source.getClassName() : null;
            return s != null ? s : "?";
        }

        public String getLineNumber() {
            return this.source != null ? Integer.toString(this.source.getLineNumber()) : "?";
        }

        public String getMethodName() {
            String s = this.source != null ? this.source.getMethodName() : null;
            return s != null ? s : "?";
        }
    }
}

