/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.component.scheduler;

import java.util.List;
import java.util.Vector;
import org.apache.log4j.component.scheduler.Job;

public class Scheduler
extends Thread {
    List jobList = new Vector();
    boolean shutdown = false;

    int findIndex(Job job) {
        int i;
        int size = this.jobList.size();
        boolean found = false;
        for (i = 0; i < size; ++i) {
            ScheduledJobEntry se = (ScheduledJobEntry)this.jobList.get(i);
            if (se.job != job) continue;
            found = true;
            break;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public synchronized boolean delete(Job job) {
        if (this.shutdown) {
            return false;
        }
        int i = this.findIndex(job);
        if (i != -1) {
            ScheduledJobEntry se = (ScheduledJobEntry)this.jobList.remove(i);
            if (se.job != job) {
                new IllegalStateException("Internal programming error");
            }
            if (i == 0) {
                this.notifyAll();
            }
            return true;
        }
        return false;
    }

    public synchronized void schedule(Job job, long desiredTime) {
        this.schedule(new ScheduledJobEntry(job, desiredTime));
    }

    public synchronized void schedule(Job job, long desiredTime, long period) {
        this.schedule(new ScheduledJobEntry(job, desiredTime, period));
    }

    public synchronized boolean changePeriod(Job job, long newPeriod) {
        if (newPeriod <= 0L) {
            throw new IllegalArgumentException("Period must be an integer langer than zero");
        }
        int i = this.findIndex(job);
        if (i == -1) {
            return false;
        }
        ScheduledJobEntry se = (ScheduledJobEntry)this.jobList.get(i);
        se.period = newPeriod;
        return true;
    }

    private synchronized void schedule(ScheduledJobEntry newSJE) {
        int i;
        if (this.shutdown) {
            return;
        }
        int max = this.jobList.size();
        long desiredExecutionTime = newSJE.desiredExecutionTime;
        for (i = 0; i < max; ++i) {
            ScheduledJobEntry sje = (ScheduledJobEntry)this.jobList.get(i);
            if (desiredExecutionTime < sje.desiredExecutionTime) break;
        }
        this.jobList.add(i, newSJE);
        if (i == 0) {
            this.notifyAll();
        }
    }

    public synchronized void shutdown() {
        this.shutdown = true;
    }

    @Override
    public synchronized void run() {
        while (!this.shutdown) {
            if (this.jobList.isEmpty()) {
                this.linger();
                continue;
            }
            ScheduledJobEntry sje = (ScheduledJobEntry)this.jobList.get(0);
            long now = System.currentTimeMillis();
            if (now >= sje.desiredExecutionTime) {
                this.executeInABox(sje.job);
                this.jobList.remove(0);
                if (sje.period <= 0L) continue;
                sje.desiredExecutionTime = now + sje.period;
                this.schedule(sje);
                continue;
            }
            this.linger(sje.desiredExecutionTime - now);
        }
        this.jobList.clear();
        this.jobList = null;
        System.out.println("Leaving scheduler run method");
    }

    void executeInABox(Job job) {
        try {
            job.execute();
        }
        catch (Exception e) {
            System.err.println("The execution of the job threw an exception");
            e.printStackTrace(System.err);
        }
    }

    void linger() {
        try {
            while (this.jobList.isEmpty() && !this.shutdown) {
                this.wait();
            }
        }
        catch (InterruptedException ie) {
            this.shutdown = true;
        }
    }

    void linger(long timeToLinger) {
        try {
            this.wait(timeToLinger);
        }
        catch (InterruptedException ie) {
            this.shutdown = true;
        }
    }

    static final class ScheduledJobEntry {
        long desiredExecutionTime;
        Job job;
        long period = 0L;

        ScheduledJobEntry(Job job, long desiredTime) {
            this(job, desiredTime, 0L);
        }

        ScheduledJobEntry(Job job, long desiredTime, long period) {
            this.desiredExecutionTime = desiredTime;
            this.job = job;
            this.period = period;
        }
    }
}

