/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.repository;

import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.internal.resolver.CapabilityImpl;
import org.apache.karaf.features.internal.resolver.RequirementImpl;
import org.apache.karaf.features.internal.resolver.ResourceImpl;
import org.apache.karaf.features.internal.resolver.SimpleFilter;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public final class StaxParser {
    public static final String REPOSITORY = "repository";
    public static final String REPO_NAME = "name";
    public static final String INCREMENT = "increment";
    public static final String REFERRAL = "referral";
    public static final String DEPTH = "depth";
    public static final String URL = "url";
    public static final String RESOURCE = "resource";
    public static final String CAPABILITY = "capability";
    public static final String REQUIREMENT = "requirement";
    public static final String NAMESPACE = "namespace";
    public static final String ATTRIBUTE = "attribute";
    public static final String DIRECTIVE = "directive";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String REPOSITORY_NAMESPACE = "http://www.osgi.org/xmlns/repository/v1.0.0";
    static XMLInputFactory inputFactory;
    static XMLOutputFactory outputFactory;

    private StaxParser() {
    }

    public static void write(XmlRepository repository, Writer os) throws XMLStreamException {
        XMLStreamWriter writer = StaxParser.getOutputFactory().createXMLStreamWriter(os);
        writer.writeStartDocument();
        writer.setDefaultNamespace(REPOSITORY_NAMESPACE);
        writer.writeStartElement(REPOSITORY_NAMESPACE, REPOSITORY);
        writer.writeAttribute("xmlns", REPOSITORY_NAMESPACE);
        writer.writeAttribute("name", repository.name);
        writer.writeAttribute(INCREMENT, Long.toString(repository.increment));
        for (Referral referral : repository.referrals) {
            writer.writeStartElement(REPOSITORY_NAMESPACE, REFERRAL);
            writer.writeAttribute(DEPTH, Integer.toString(referral.depth));
            writer.writeAttribute(URL, referral.url);
            writer.writeEndElement();
        }
        for (Resource resource : repository.resources) {
            writer.writeStartElement(REPOSITORY_NAMESPACE, RESOURCE);
            for (Capability cap : resource.getCapabilities(null)) {
                StaxParser.writeClause(writer, CAPABILITY, cap.getNamespace(), cap.getDirectives(), cap.getAttributes());
            }
            for (Requirement req : resource.getRequirements(null)) {
                StaxParser.writeClause(writer, REQUIREMENT, req.getNamespace(), req.getDirectives(), req.getAttributes());
            }
            writer.writeEndElement();
        }
        writer.writeEndDocument();
        writer.flush();
    }

    private static void writeClause(XMLStreamWriter writer, String element, String namespace, Map<String, String> directives, Map<String, Object> attributes) throws XMLStreamException {
        writer.writeStartElement(REPOSITORY_NAMESPACE, element);
        writer.writeAttribute(NAMESPACE, namespace);
        for (Map.Entry<String, String> dir : directives.entrySet()) {
            writer.writeStartElement(REPOSITORY_NAMESPACE, DIRECTIVE);
            writer.writeAttribute("name", dir.getKey());
            writer.writeAttribute(VALUE, dir.getValue());
            writer.writeEndElement();
        }
        for (Map.Entry<String, Object> att : attributes.entrySet()) {
            String key = att.getKey();
            Object val = att.getValue();
            writer.writeStartElement(REPOSITORY_NAMESPACE, ATTRIBUTE);
            writer.writeAttribute("name", key);
            if (val instanceof Version) {
                writer.writeAttribute(TYPE, "Version");
            } else if (val instanceof Long) {
                writer.writeAttribute(TYPE, "Long");
            } else if (val instanceof Double) {
                writer.writeAttribute(TYPE, "Double");
            } else if (val instanceof Iterable) {
                Iterable it = (Iterable)att.getValue();
                String scalar = null;
                for (Object o : it) {
                    String ts;
                    if (o instanceof String) {
                        ts = "String";
                    } else if (o instanceof Long) {
                        ts = "Long";
                    } else if (o instanceof Double) {
                        ts = "Double";
                    } else if (o instanceof Version) {
                        ts = "Version";
                    } else {
                        throw new IllegalArgumentException("Unsupported scalar type: " + o);
                    }
                    if (scalar == null) {
                        scalar = ts;
                        continue;
                    }
                    if (scalar.equals(ts)) continue;
                    throw new IllegalArgumentException("Unconsistent list type for attribute " + key);
                }
                writer.writeAttribute(TYPE, "List<" + scalar + ">");
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Object o : it) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(o.toString().replace(",", "\\,"));
                }
                val = sb.toString();
            }
            writer.writeAttribute(VALUE, val.toString());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static XmlRepository parse(InputStream is) throws XMLStreamException {
        return StaxParser.parse(null, is, null);
    }

    public static XmlRepository parse(URI repositoryUrl, InputStream is) throws XMLStreamException {
        return StaxParser.parse(repositoryUrl, is, null);
    }

    public static XmlRepository parse(URI repositoryUrl, InputStream is, XmlRepository previous) throws XMLStreamException {
        XMLStreamReader reader = StaxParser.getInputFactory().createXMLStreamReader(is);
        int event = reader.nextTag();
        if (event != 1 || !REPOSITORY.equals(reader.getLocalName())) {
            throw new IllegalStateException("Expected element 'repository' at the root of the document");
        }
        XmlRepository repo = new XmlRepository();
        int nb = reader.getAttributeCount();
        block24: for (int i = 0; i < nb; ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrValue = reader.getAttributeValue(i);
            switch (attrName) {
                case "name": {
                    repo.name = attrValue;
                    continue block24;
                }
                case "increment": {
                    repo.increment = Long.parseLong(attrValue);
                    continue block24;
                }
                default: {
                    throw new IllegalStateException("Unexpected attribute '" + attrName + "'");
                }
            }
        }
        if (previous != null && repo.increment == previous.increment) {
            return previous;
        }
        block25: while ((event = reader.nextTag()) == 1) {
            String element;
            switch (element = reader.getLocalName()) {
                case "referral": {
                    Referral referral = new Referral();
                    int nb2 = reader.getAttributeCount();
                    block26: for (int i = 0; i < nb2; ++i) {
                        String attrName = reader.getAttributeLocalName(i);
                        String attrValue = reader.getAttributeValue(i);
                        switch (attrName) {
                            case "depth": {
                                referral.depth = Integer.parseInt(attrValue);
                                continue block26;
                            }
                            case "url": {
                                referral.url = attrValue;
                                continue block26;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected attribute '" + attrName + "'");
                            }
                        }
                    }
                    if (referral.url == null) {
                        throw new IllegalStateException("Expected attribute 'url'");
                    }
                    repo.referrals.add(referral);
                    StaxParser.sanityCheckEndElement(reader, reader.nextTag(), REFERRAL);
                    continue block25;
                }
                case "resource": {
                    repo.resources.add(StaxParser.parseResource(repositoryUrl, reader));
                    continue block25;
                }
            }
            throw new IllegalStateException("Unsupported element '" + element + "'. Expected 'referral' or 'resource'");
        }
        StaxParser.sanityCheckEndElement(reader, event, REPOSITORY);
        return repo;
    }

    private static void sanityCheckEndElement(XMLStreamReader reader, int event, String element) {
        if (event != 2 || !element.equals(reader.getLocalName())) {
            throw new IllegalStateException("Unexpected state while finishing element " + element);
        }
    }

    private static ResourceImpl parseResource(URI repositoryUrl, XMLStreamReader reader) {
        try {
            int event;
            if (reader.getAttributeCount() > 0) {
                throw new IllegalStateException("Unexpected attribute '" + reader.getAttributeLocalName(0) + "'");
            }
            ResourceImpl resource = new ResourceImpl();
            block14: while ((event = reader.nextTag()) == 1) {
                String element;
                switch (element = reader.getLocalName()) {
                    case "capability": {
                        Object url;
                        CapabilityImpl cap = StaxParser.parseCapability(reader, resource);
                        if (repositoryUrl != null && "osgi.content".equals(cap.getNamespace()) && (url = cap.getAttributes().get(URL)) instanceof String) {
                            url = repositoryUrl.resolve(url.toString()).toString();
                            cap.getAttributes().put(URL, url);
                        }
                        resource.addCapability(cap);
                        continue block14;
                    }
                    case "requirement": {
                        resource.addRequirement(StaxParser.parseRequirement(reader, resource));
                        continue block14;
                    }
                }
                while ((event = reader.next()) != 2) {
                    switch (event) {
                        case 1: {
                            throw new IllegalStateException("Unexpected element '" + reader.getLocalName() + "' inside 'resource' element");
                        }
                        case 4: {
                            throw new IllegalStateException("Unexpected text inside 'resource' element");
                        }
                    }
                }
            }
            StaxParser.sanityCheckEndElement(reader, event, RESOURCE);
            return resource;
        }
        catch (Exception e) {
            Location loc = reader.getLocation();
            if (loc != null) {
                throw new IllegalStateException("Error while parsing resource at line " + loc.getLineNumber() + " and column " + loc.getColumnNumber(), e);
            }
            throw new IllegalStateException("Error while parsing resource", e);
        }
    }

    private static CapabilityImpl parseCapability(XMLStreamReader reader, ResourceImpl resource) throws XMLStreamException {
        String[] namespace = new String[1];
        HashMap<String, String> directives = new HashMap<String, String>();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        StaxParser.parseClause(reader, namespace, directives, attributes);
        StaxParser.sanityCheckEndElement(reader, reader.getEventType(), CAPABILITY);
        return new CapabilityImpl(resource, namespace[0], directives, attributes);
    }

    private static RequirementImpl parseRequirement(XMLStreamReader reader, ResourceImpl resource) throws XMLStreamException {
        String[] namespace = new String[1];
        HashMap<String, String> directives = new HashMap<String, String>();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        StaxParser.parseClause(reader, namespace, directives, attributes);
        StaxParser.sanityCheckEndElement(reader, reader.getEventType(), REQUIREMENT);
        String filterStr = (String)directives.get("filter");
        SimpleFilter sf = filterStr != null ? SimpleFilter.parse(filterStr) : SimpleFilter.convert(attributes);
        return new RequirementImpl(resource, namespace[0], directives, attributes, sf);
    }

    private static void parseClause(XMLStreamReader reader, String[] namespace, Map<String, String> directives, Map<String, Object> attributes) throws XMLStreamException {
        namespace[0] = null;
        int nb = reader.getAttributeCount();
        for (int i = 0; i < nb; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (!NAMESPACE.equals(name)) {
                throw new IllegalStateException("Unexpected attribute: '" + name + "'. Expected 'namespace'");
            }
            namespace[0] = value;
        }
        if (namespace[0] == null) {
            throw new IllegalStateException("Expected attribute 'namespace'");
        }
        block27: while (reader.nextTag() == 1) {
            String element;
            switch (element = reader.getLocalName()) {
                case "directive": {
                    String name = null;
                    String value = null;
                    int nb2 = reader.getAttributeCount();
                    block28: for (int i = 0; i < nb2; ++i) {
                        String attName = reader.getAttributeLocalName(i);
                        String attValue = reader.getAttributeValue(i);
                        switch (attName) {
                            case "name": {
                                name = attValue;
                                continue block28;
                            }
                            case "value": {
                                value = attValue;
                                continue block28;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected attribute: '" + attName + "'. Expected 'name', or 'value'.");
                            }
                        }
                    }
                    if (name == null || value == null) {
                        throw new IllegalStateException("Expected attribute 'name' and 'value'");
                    }
                    directives.put(name, value);
                    StaxParser.sanityCheckEndElement(reader, reader.nextTag(), DIRECTIVE);
                    continue block27;
                }
                case "attribute": {
                    String name = null;
                    String value = null;
                    String type = "String";
                    int nb3 = reader.getAttributeCount();
                    block29: for (int i = 0; i < nb3; ++i) {
                        String attName = reader.getAttributeLocalName(i);
                        String attValue = reader.getAttributeValue(i);
                        switch (attName) {
                            case "name": {
                                name = attValue;
                                continue block29;
                            }
                            case "value": {
                                value = attValue;
                                continue block29;
                            }
                            case "type": {
                                type = attValue;
                                continue block29;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected attribute: '" + attName + "'. Expected 'name', 'value' or 'type'.");
                            }
                        }
                    }
                    if (name == null || value == null) {
                        throw new IllegalStateException("Expected attribute 'name' and 'value'");
                    }
                    attributes.put(name, StaxParser.parseAttribute(value, type));
                    StaxParser.sanityCheckEndElement(reader, reader.nextTag(), ATTRIBUTE);
                    continue block27;
                }
            }
            throw new IllegalStateException("Unexpected element: '" + element + ". Expected 'directive' or 'attribute'");
        }
    }

    private static Object parseAttribute(String value, String type) {
        if ("String".equals(type)) {
            return value;
        }
        if ("Version".equals(type)) {
            return VersionTable.getVersion(value);
        }
        if ("Long".equals(type)) {
            return Long.parseLong(value.trim());
        }
        if ("Double".equals(type)) {
            return Double.parseDouble(value.trim());
        }
        if (type.startsWith("List<") && type.endsWith(">")) {
            type = type.substring("List<".length(), type.length() - 1);
            ArrayList<Object> list = new ArrayList<Object>();
            for (String s : value.split(",")) {
                list.add(StaxParser.parseAttribute(s.trim(), type));
            }
            return list;
        }
        throw new IllegalStateException("Unexpected type: '" + type + "'");
    }

    private static synchronized XMLInputFactory getInputFactory() {
        if (inputFactory == null) {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isNamespaceAware", true);
            inputFactory = factory;
        }
        return inputFactory;
    }

    private static synchronized XMLOutputFactory getOutputFactory() {
        if (outputFactory == null) {
            outputFactory = XMLOutputFactory.newInstance();
        }
        return outputFactory;
    }

    public static class XmlRepository {
        public String name;
        public long increment;
        public List<Referral> referrals = new ArrayList<Referral>();
        public List<Resource> resources = new ArrayList<Resource>();
    }

    public static class Referral {
        public String url;
        public int depth = Integer.MAX_VALUE;
    }
}

