/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.system.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.GregorianCalendar;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.system.FrameworkType;
import org.apache.karaf.system.SystemService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemServiceImpl
implements SystemService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemServiceImpl.class);
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void halt() throws Exception {
        this.halt(null);
    }

    @Override
    public void halt(String time) throws Exception {
        this.shutdown(this.timeToSleep(time));
    }

    @Override
    public void reboot() throws Exception {
        this.reboot(null, SystemService.Swipe.NONE);
    }

    @Override
    public void reboot(String time, SystemService.Swipe cleanup) throws Exception {
        this.reboot(this.timeToSleep(time), cleanup);
    }

    private void shutdown(final long sleep) {
        new Thread(){

            @Override
            public void run() {
                try {
                    SystemServiceImpl.this.sleepWithMsg(sleep, "Shutdown in " + sleep / 1000L / 60L + " minute(s)");
                    SystemServiceImpl.this.getBundleContext().getBundle(0L).stop();
                }
                catch (Exception e) {
                    LOGGER.error("Halt error", (Throwable)e);
                }
            }
        }.start();
    }

    private void reboot(final long sleep, final SystemService.Swipe clean) {
        new Thread(){

            @Override
            public void run() {
                try {
                    SystemServiceImpl.this.sleepWithMsg(sleep, "Reboot in " + sleep / 1000L / 60L + " minute(s)");
                    System.setProperty("karaf.restart", "true");
                    if (clean.equals((Object)SystemService.Swipe.ALL)) {
                        System.setProperty("karaf.clean.all", "true");
                    } else if (clean.equals((Object)SystemService.Swipe.CACHE)) {
                        System.setProperty("karaf.clean.cache", "true");
                    }
                    SystemServiceImpl.this.bundleContext.getBundle(0L).stop();
                }
                catch (Exception e) {
                    LOGGER.error("Reboot error", (Throwable)e);
                }
            }
        }.start();
    }

    private void sleepWithMsg(long sleep, String msg) throws InterruptedException {
        if (sleep > 0L) {
            LOGGER.info(msg);
            System.err.println(msg);
        }
        Thread.sleep(sleep);
    }

    @Override
    public void setStartLevel(int startLevel) throws Exception {
        ((FrameworkStartLevel)this.getBundleContext().getBundle(0L).adapt(FrameworkStartLevel.class)).setStartLevel(startLevel, new FrameworkListener[0]);
    }

    @Override
    public int getStartLevel() throws Exception {
        return ((FrameworkStartLevel)this.getBundleContext().getBundle(0L).adapt(FrameworkStartLevel.class)).getStartLevel();
    }

    private long timeToSleep(String time) throws Exception {
        long sleep = 0L;
        if (time != null && !time.equals("now")) {
            if (time.contains(":")) {
                String[] strings = time.split(":");
                if (strings.length != 2) {
                    throw new IllegalArgumentException("Time " + time + " is not valid (not in hour:minute format)");
                }
                int hour = Integer.parseInt(strings[0]);
                int minute = Integer.parseInt(strings[1]);
                if (hour < 0 || hour > 23) {
                    throw new IllegalArgumentException("Time " + time + " is not valid (hour " + hour + " is not between 0 and 23)");
                }
                if (minute < 0 || minute > 59) {
                    throw new IllegalArgumentException("Time " + time + " is not valid (minute " + minute + " is not between 0 and 59)");
                }
                GregorianCalendar currentDate = new GregorianCalendar();
                GregorianCalendar shutdownDate = new GregorianCalendar(currentDate.get(1), currentDate.get(2), currentDate.get(5), Integer.parseInt(strings[0]), Integer.parseInt(strings[1]));
                if (shutdownDate.before(currentDate)) {
                    shutdownDate.set(5, shutdownDate.get(5) + 1);
                }
                sleep = shutdownDate.getTimeInMillis() - currentDate.getTimeInMillis();
            } else {
                if (time.startsWith("+")) {
                    time = time.substring(1);
                }
                try {
                    sleep = Long.parseLong(time) * 60L * 1000L;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Time " + time + " is not valid");
                }
            }
        }
        return sleep;
    }

    @Override
    public String getVersion() {
        return System.getProperty("karaf.version");
    }

    @Override
    public String getName() {
        return this.bundleContext.getProperty("karaf.name");
    }

    @Override
    public void setName(String name) {
        try {
            String karafEtc = this.bundleContext.getProperty("karaf.etc");
            File etcDir = new File(karafEtc);
            File syspropsFile = new File(etcDir, "system.properties");
            FileInputStream fis = new FileInputStream(syspropsFile);
            Properties props = new Properties();
            props.load(fis);
            fis.close();
            props.setProperty("karaf.name", name);
            FileOutputStream fos = new FileOutputStream(syspropsFile);
            props.store(fos, "");
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public FrameworkType getFramework() {
        if (this.bundleContext.getBundle(0L).getSymbolicName().contains("felix")) {
            return FrameworkType.felix;
        }
        return FrameworkType.equinox;
    }

    private Properties loadProps() throws IOException {
        return new Properties(new File(System.getProperty("karaf.etc"), "config.properties"));
    }

    @Override
    public void setFramework(FrameworkType framework) {
        if (framework == null) {
            return;
        }
        try {
            Properties properties = this.loadProps();
            properties.put("karaf.framework", framework.name());
            properties.save();
        }
        catch (IOException e) {
            throw new RuntimeException("Error setting framework: " + e.getMessage(), e);
        }
    }

    @Override
    public void setFrameworkDebug(boolean debug) {
        try {
            Properties properties = this.loadProps();
            if (debug) {
                properties.put("felix.log.level", "4");
                properties.put("osgi.debug", "etc/equinox-debug.properties");
            } else {
                properties.remove("felix.log.level");
                properties.remove("osgi.debug");
            }
            properties.save();
        }
        catch (IOException e) {
            throw new RuntimeException("Error settting framework debugging: " + e.getMessage(), e);
        }
    }

    @Override
    public String setSystemProperty(String key, String value, boolean persist) {
        if (persist) {
            try {
                String etc = System.getProperty("karaf.etc");
                Properties props = new Properties(new File(etc, "system.properties"));
                props.put(key, value);
                props.save();
            }
            catch (IOException e) {
                throw new RuntimeException("Error persisting system property", e);
            }
        }
        return System.setProperty(key, value);
    }
}

