/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import jline.console.ConsoleReader;
import org.apache.karaf.bundle.command.BundleCommandWithConfirmation;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.osgi.framework.Bundle;
import org.osgi.framework.startlevel.BundleStartLevel;

@Command(scope="bundle", name="start-level", description="Gets or sets the start level of a bundle.")
public class StartLevel
extends BundleCommandWithConfirmation {
    @Argument(index=1, name="startLevel", description="The bundle's new start level", required=false, multiValued=false)
    Integer level;

    @Override
    protected void doExecute(Bundle bundle) throws Exception {
        BundleStartLevel bsl = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        if (bsl == null) {
            System.out.println("StartLevel service is unavailable.");
            return;
        }
        if (this.level == null) {
            System.out.println("Level " + bsl.getStartLevel());
        } else if (this.level < 50 && bsl.getStartLevel() > 50 && !this.force) {
            String str;
            do {
                String msg;
                ConsoleReader reader;
                if (!"yes".equalsIgnoreCase(str = (reader = (ConsoleReader)this.session.get(".jline.reader")).readLine(msg = "You are about to designate bundle as a system bundle.  Do you wish to continue (yes/no): "))) continue;
                bsl.setStartLevel(this.level.intValue());
                break;
            } while (!"no".equalsIgnoreCase(str));
        } else {
            bsl.setStartLevel(this.level.intValue());
        }
    }
}

