/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.List;
import org.apache.karaf.bundle.command.BundlesCommand;
import org.apache.karaf.bundle.core.BundleInfo;
import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.util.ShellUtil;
import org.osgi.framework.Bundle;

@Command(scope="bundle", name="diag", description="Displays diagnostic information why a bundle is not Active")
public class Diag
extends BundlesCommand {
    public Diag() {
        super(true);
    }

    @Override
    protected void doExecute(List<Bundle> bundles) throws Exception {
        for (Bundle bundle : bundles) {
            BundleInfo info = this.bundleService.getInfo(bundle);
            if (info.getState() != BundleState.Failure && info.getState() != BundleState.Waiting && info.getState() != BundleState.GracePeriod && info.getState() != BundleState.Installed) continue;
            String title = ShellUtil.getBundleName((Bundle)bundle);
            System.out.println(title);
            System.out.println(ShellUtil.getUnderlineString((String)title));
            System.out.println("Status: " + info.getState().toString());
            System.out.println(this.bundleService.getDiag(bundle));
            System.out.println();
        }
    }
}

