/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.commons.utils.AssertionUtils;

public class SortedLinkedList<E>
extends AbstractList<E> {
    private final List<E> list;
    private final Comparator<? super E> comparator;

    public SortedLinkedList() {
        this(Comparator.naturalOrder());
    }

    public SortedLinkedList(Comparator<? super E> comparator) {
        this.comparator = AssertionUtils.assertArgNotNull("comparator", comparator);
        this.list = new LinkedList();
    }

    public SortedLinkedList(Collection<? extends E> c) {
        this(Comparator.naturalOrder(), c);
    }

    public SortedLinkedList(Comparator<? super E> comparator, Collection<? extends E> c) {
        this.comparator = AssertionUtils.assertArgNotNull("comparator", comparator);
        this.list = new LinkedList<E>(c);
        Collections.sort(this.list, this.comparator);
    }

    @Override
    public boolean add(E e) {
        int index = this.findInsertionPoint(e);
        this.list.add(index, e);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.add(element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            this.add(e);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.addAll(c);
    }

    @Override
    public E set(int index, E element) {
        E oldValue = this.list.remove(index);
        this.add(element);
        return oldValue;
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public Comparator<? super E> comparator() {
        return this.comparator == Comparator.naturalOrder() ? null : this.comparator;
    }

    private int findInsertionPoint(E e) {
        int index;
        int size = this.list.size();
        for (index = 0; index < size && this.comparator.compare(this.list.get(index), e) < 0; ++index) {
        }
        if (index < size && this.comparator.compare(this.list.get(index), e) == 0) {
            while (index < size && this.comparator.compare(this.list.get(index), e) == 0) {
                ++index;
            }
        }
        return index;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        return this.list.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }
}

