/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.juneau.BeanContext;
import org.apache.juneau.MediaType;
import org.apache.juneau.StringRange;
import org.apache.juneau.StringRanges;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderMatch;
import org.apache.juneau.encoders.EncoderSet;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.header.BasicUriHeader;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.header.SerializedHeader;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.http.response.NotAcceptable;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.httppart.RequestAttributes;
import org.apache.juneau.rest.util.CachingHttpServletResponse;
import org.apache.juneau.rest.util.FinishablePrintWriter;
import org.apache.juneau.rest.util.FinishableServletOutputStream;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerMatch;

public class RestResponse
extends HttpServletResponseWrapper {
    private HttpServletResponse inner;
    private final RestRequest request;
    private Optional<Object> content;
    private ServletOutputStream sos;
    private FinishableServletOutputStream os;
    private FinishablePrintWriter w;
    private ResponseBeanMeta responseBeanMeta;
    private RestOpContext opContext;
    private Optional<HttpPartSchema> contentSchema;
    private Serializer serializer;
    private Optional<SerializerMatch> serializerMatch;
    private boolean safeHeaders;
    private int maxHeaderLength = 8096;

    RestResponse(RestOpContext opContext, RestSession session, RestRequest req) throws Exception {
        super(session.getResponse());
        this.inner = session.getResponse();
        this.request = req;
        this.opContext = opContext;
        this.responseBeanMeta = opContext.getResponseMeta();
        RestContext context = session.getContext();
        try {
            String passThroughHeaders = this.request.getHeaderParam("x-response-headers").orElse(null);
            if (Utils.nn((Object)passThroughHeaders)) {
                JsonMap m = (JsonMap)context.getPartParser().getPartSession().parse(HttpPartType.HEADER, null, passThroughHeaders, BeanContext.DEFAULT.getClassMeta(JsonMap.class));
                for (Map.Entry e : m.entrySet()) {
                    this.addHeader((String)e.getKey(), this.resolveUris(e.getValue()));
                }
            }
        }
        catch (Exception e1) {
            throw new BadRequest((Throwable)e1, "Invalid format for header 'x-response-headers'.  Must be in URL-encoded format.", new Object[0]);
        }
        String h = this.request.getHeaderParam("accept-charset").orElse(null);
        Charset charset = null;
        if (h == null) {
            charset = opContext.getDefaultCharset();
        } else {
            for (StringRange r : StringRanges.of((String)h).toList()) {
                if (!(r.getQValue().floatValue() > 0.0f)) continue;
                if (r.getName().equals("*")) {
                    charset = opContext.getDefaultCharset();
                } else if (Charset.isSupported(r.getName())) {
                    charset = Charset.forName(r.getName());
                }
                if (!Utils.nn((Object)charset)) continue;
                break;
            }
        }
        this.request.getContext().getDefaultResponseHeaders().forEach(x -> this.addHeader(x.getValue(), this.resolveUris(x.getValue())));
        opContext.getDefaultResponseHeaders().forEach(x -> this.addHeader(x.getName(), this.resolveUris(x.getValue())));
        if (charset == null) {
            throw new NotAcceptable("No supported charsets in header ''Accept-Charset'': ''{0}''", new Object[]{this.request.getHeaderParam("Accept-Charset").orElse(null)});
        }
        this.inner.setCharacterEncoding(charset.name());
    }

    public RestResponse addHeader(Header header) {
        if (header != null) {
            if (header instanceof BasicUriHeader) {
                BasicUriHeader header2 = (BasicUriHeader)header;
                this.addHeader(header2.getName(), this.resolveUris(header2.getValue()));
            } else if (header instanceof SerializedHeader) {
                SerializedHeader header3 = (SerializedHeader)header;
                SerializedHeader x = header3.copyWith(this.request.getPartSerializerSession(), null);
                this.addHeader(x.getName(), this.resolveUris(x.getValue()));
            } else {
                this.addHeader(header.getName(), header.getValue());
            }
        }
        return this;
    }

    public void addHeader(String name, String value) {
        if (Utils.nn((Object)name) && Utils.nn((Object)value)) {
            if (Utils.eqic((String)name, (String)"Content-Type")) {
                this.setHeader(name, value);
            } else {
                if (this.safeHeaders) {
                    value = StringUtils.stripInvalidHttpHeaderChars((String)value);
                }
                value = StringUtils.abbreviate((String)value, (int)this.maxHeaderLength);
                this.inner.addHeader(name, value);
            }
        }
    }

    public void flushBuffer() throws IOException {
        if (Utils.nn((Object)this.w)) {
            this.w.flush();
        }
        if (Utils.nn((Object)((Object)this.os))) {
            this.os.flush();
        }
        this.inner.flushBuffer();
    }

    public RequestAttributes getAttributes() {
        return this.request.getAttributes();
    }

    public Charset getCharset() {
        String s = this.getCharacterEncoding();
        return s == null ? null : Charset.forName(s);
    }

    public Optional<Object> getContent() {
        return this.content;
    }

    public <T> T getContent(Class<T> c) {
        if (this.isContentOfType(c)) {
            return (T)this.getRawOutput();
        }
        return null;
    }

    public Optional<HttpPartSchema> getContentSchema() {
        ResponseBeanMeta rbm;
        if (Utils.nn(this.contentSchema)) {
            return this.contentSchema;
        }
        this.contentSchema = Utils.nn((Object)this.responseBeanMeta) ? Utils.opt((Object)this.responseBeanMeta.getSchema()) : (Utils.nn((Object)(rbm = this.opContext.getResponseBeanMeta(this.getContent(Object.class)))) ? Utils.opt((Object)rbm.getSchema()) : Utils.opte());
        return this.contentSchema;
    }

    public RestContext getContext() {
        return this.request.getContext();
    }

    public PrintWriter getDirectWriter(String contentType) throws IOException {
        this.setContentType(contentType);
        this.setHeader("X-Content-Type-Options", "nosniff");
        this.setHeader("Content-Encoding", "identity");
        return this.getWriter(true, true);
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.inner;
    }

    public MediaType getMediaType() {
        return MediaType.of((String)this.getContentType());
    }

    public FinishableServletOutputStream getNegotiatedOutputStream() throws NotAcceptable, IOException {
        if (this.os == null) {
            Encoder encoder = null;
            EncoderSet encoders = this.request.getOpContext().getEncoders();
            String ae = this.request.getHeaderParam("Accept-Encoding").orElse(null);
            if (ae != null && !ae.isEmpty()) {
                EncoderMatch match = encoders.getEncoderMatch(ae);
                if (match == null) {
                    if (ae.matches(".*(identity|\\*)\\s*;\\s*q\\s*=\\s*(0(?!\\.)|0\\.0).*")) {
                        throw new NotAcceptable("Unsupported encoding in request header ''Accept-Encoding'': ''{0}''\n\tSupported codings: {1}", new Object[]{ae, Json5.of((Object)encoders.getSupportedEncodings())});
                    }
                } else {
                    encoder = match.getEncoder();
                    String encoding = match.getEncoding().toString();
                    if (!encoding.equals("identity")) {
                        this.setHeader("content-encoding", encoding);
                    }
                }
            }
            ServletOutputStream sos = this.getOutputStream();
            this.os = new FinishableServletOutputStream((OutputStream)(encoder == null ? sos : encoder.getOutputStream((OutputStream)sos)));
        }
        return this.os;
    }

    public FinishablePrintWriter getNegotiatedWriter() throws NotAcceptable, IOException {
        return this.getWriter(false, false);
    }

    public RestOpContext getOpContext() {
        return this.request.getOpContext();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.sos == null) {
            this.sos = this.inner.getOutputStream();
        }
        return this.sos;
    }

    public boolean getOutputStreamCalled() {
        return Utils.nn((Object)this.sos);
    }

    public ResponseBeanMeta getResponseBeanMeta() {
        return this.responseBeanMeta;
    }

    public Optional<SerializerMatch> getSerializerMatch() {
        if (Utils.nn(this.serializerMatch)) {
            return this.serializerMatch;
        }
        this.serializerMatch = Utils.nn((Object)this.serializer) ? Utils.opt((Object)new SerializerMatch(this.getMediaType(), this.serializer)) : Utils.opt((Object)this.opContext.getSerializers().getSerializerMatch(this.request.getHeaderParam("Accept").orElse("*/*")));
        return this.serializerMatch;
    }

    public PrintWriter getWriter() throws IOException {
        return this.getWriter(true, false);
    }

    public boolean hasContent() {
        return Utils.nn(this.content);
    }

    public boolean isContentOfType(Class<?> c) {
        return c.isInstance(this.getRawOutput());
    }

    public RestResponse sendPlainText(String text) throws IOException {
        this.setContentType("text/plain");
        this.getNegotiatedWriter().write(text);
        return this;
    }

    public void sendRedirect(String uri) throws IOException {
        char c;
        char c2 = c = ((String)uri).length() > 0 ? ((String)uri).charAt(0) : (char)'\u0000';
        if (c != '/' && ((String)uri).indexOf("://") == -1) {
            uri = this.request.getContextPath() + "/" + (String)uri;
        }
        this.inner.sendRedirect((String)uri);
    }

    public RestResponse setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
        return this;
    }

    public RestResponse setContent(Object output) {
        this.content = Utils.opt((Object)output);
        return this;
    }

    public RestResponse setContentSchema(HttpPartSchema schema) {
        this.contentSchema = Utils.opt((Object)schema);
        return this;
    }

    public RestResponse setDebug() throws IOException {
        return this.setDebug(true);
    }

    public RestResponse setDebug(Boolean b) throws IOException {
        this.request.setDebug(b);
        if (b.booleanValue()) {
            this.inner = CachingHttpServletResponse.wrap(this.inner);
        }
        return this;
    }

    public RestResponse setException(Throwable t) {
        this.request.setException(t);
        return this;
    }

    public RestResponse setHeader(Header header) {
        if (header != null) {
            if (header instanceof BasicUriHeader) {
                BasicUriHeader header2 = (BasicUriHeader)header;
                this.setHeader(header2.getName(), this.resolveUris(header2.getValue()));
            } else if (header instanceof SerializedHeader) {
                SerializedHeader header2 = (SerializedHeader)header;
                SerializedHeader x = header2.copyWith(this.request.getPartSerializerSession(), null);
                String v = x.getValue();
                if (Utils.nn((Object)v) && v.indexOf("://") != -1) {
                    v = this.resolveUris(v);
                }
                this.setHeader(x.getName(), v);
            } else {
                this.setHeader(header.getName(), header.getValue());
            }
        }
        return this;
    }

    public RestResponse setHeader(HttpPartSchema schema, String name, Object value) throws SchemaValidationException, SerializeException {
        this.setHeader(name, this.request.getPartSerializerSession().serialize(HttpPartType.HEADER, schema, value));
        return this;
    }

    public RestResponse setHeader(String name, Object value) throws SchemaValidationException, SerializeException {
        this.setHeader(name, this.request.getPartSerializerSession().serialize(HttpPartType.HEADER, null, value));
        return this;
    }

    public void setHeader(String name, String value) {
        if (Utils.eqic((String)name, (String)"Content-Type")) {
            this.inner.setContentType(value);
            ContentType ct = HttpHeaders.contentType((String)value);
            if (Utils.nn((Object)ct) && Utils.nn((Object)ct.getParameter("charset"))) {
                this.inner.setCharacterEncoding(ct.getParameter("charset"));
            }
        } else {
            if (this.safeHeaders) {
                value = StringUtils.stripInvalidHttpHeaderChars((String)value);
            }
            value = StringUtils.abbreviate((String)value, (int)this.maxHeaderLength);
            this.inner.setHeader(name, value);
        }
    }

    public RestResponse setMaxHeaderLength(int value) {
        this.maxHeaderLength = value;
        return this;
    }

    public RestResponse setNoTrace() {
        return this.setNoTrace(true);
    }

    public RestResponse setNoTrace(Boolean b) {
        this.request.setNoTrace(b);
        return this;
    }

    public RestResponse setResponseBeanMeta(ResponseBeanMeta rbm) {
        this.responseBeanMeta = rbm;
        return this;
    }

    public RestResponse setSafeHeaders() {
        this.safeHeaders = true;
        return this;
    }

    private Object getRawOutput() {
        return this.content == null ? null : this.content.orElse(null);
    }

    private FinishablePrintWriter getWriter(boolean raw, boolean autoflush) throws NotAcceptable, IOException {
        if (Utils.nn((Object)this.w)) {
            return this.w;
        }
        if (this.request.isPlainText()) {
            this.setHeader("Content-Type", "text/plain");
        }
        try {
            ServletOutputStream out = raw ? this.getOutputStream() : this.getNegotiatedOutputStream();
            this.w = new FinishablePrintWriter((OutputStream)out, this.getCharacterEncoding(), autoflush);
            return this.w;
        }
        catch (UnsupportedEncodingException e) {
            String ce = this.getCharacterEncoding();
            this.setCharacterEncoding("UTF-8");
            throw new NotAcceptable("Unsupported charset in request header ''Accept-Charset'': ''{0}''", new Object[]{ce});
        }
    }

    private String resolveUris(Object value) {
        String s = Utils.s((Object)value);
        return this.request.getUriResolver().resolve((Object)s);
    }
}

