/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.springboot;

import java.util.Locale;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.resource.HttpResource;
import org.apache.juneau.http.response.NotFound;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.config.BasicJsonConfig;
import org.apache.juneau.rest.servlet.BasicRestOperations;
import org.apache.juneau.rest.springboot.SpringRestServlet;
import org.apache.juneau.rest.stats.RestContextStats;

@Rest
public abstract class BasicSpringRestServlet
extends SpringRestServlet
implements BasicRestOperations,
BasicJsonConfig {
    private static final long serialVersionUID = 1L;

    public Swagger getSwagger(RestRequest req) {
        return (Swagger)req.getSwagger().orElseThrow(NotFound::new);
    }

    public HttpResource getHtdoc(@Path(value="/*") String path, Locale locale) throws NotFound {
        return (HttpResource)this.getContext().getStaticFiles().resolve(path, locale).orElseThrow(NotFound::new);
    }

    public HttpResource getFavIcon() {
        String favIcon = this.getContext().getConfig().get("REST/favicon").orElse("images/juneau.png");
        return this.getHtdoc(favIcon, null);
    }

    public void error() {
    }

    public RestContextStats getStats(RestRequest req) {
        return req.getContext().getStats();
    }
}

