/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.marshall;

import java.io.IOException;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;

public abstract class Marshall {
    private final Serializer s;
    private final Parser p;

    protected Marshall(Serializer s, Parser p) {
        this.s = s;
        this.p = p;
    }

    public Serializer getSerializer() {
        return this.s;
    }

    public Parser getParser() {
        return this.p;
    }

    public Object write(Object o) throws SerializeException {
        return this.s.serialize(o);
    }

    public final void write(Object o, Object output) throws SerializeException, IOException {
        this.s.serialize(o, output);
    }

    public final String toString(Object o) {
        try {
            return this.s.serializeToString(o);
        }
        catch (Exception e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    public final Marshall println(Object o) {
        System.out.println(this.toString(o));
        return this;
    }

    public final Marshall out(String msg, Object ... args) {
        System.out.println(this.format(msg, args));
        return this;
    }

    public final Marshall err(String msg, Object ... args) {
        System.err.println(this.format(msg, args));
        return this;
    }

    public final String format(String msg, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.toString(args[i]);
        }
        return MessageFormat.format(msg, args);
    }

    public final <T> T read(Object input, Type type, Type ... args) throws ParseException, IOException {
        return this.p.parse(input, type, args);
    }

    public final <T> T read(String input, Type type, Type ... args) throws ParseException {
        return this.p.parse(input, type, args);
    }

    public final <T> T read(Object input, Class<T> type) throws ParseException, IOException {
        return this.p.parse(input, type);
    }

    public final <T> T read(String input, Class<T> type) throws ParseException {
        return this.p.parse(input, type);
    }
}

