/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicDateHeader;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;

@Header(value="Retry-After")
public class RetryAfter
extends BasicDateHeader {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Retry-After";
    private final Integer value;
    private final Supplier<?> supplier;

    public static RetryAfter of(String value) {
        return value == null ? null : new RetryAfter(value);
    }

    public static RetryAfter of(ZonedDateTime value) {
        return value == null ? null : new RetryAfter(value);
    }

    public static RetryAfter of(Integer value) {
        return value == null ? null : new RetryAfter(value);
    }

    public static RetryAfter of(Supplier<?> value) {
        return value == null ? null : new RetryAfter(value);
    }

    public RetryAfter(String value) {
        super(NAME, StringUtils.isNumeric(value) ? null : value);
        this.value = StringUtils.isNumeric(value) ? Integer.valueOf(Integer.parseInt(value)) : null;
        this.supplier = null;
    }

    public RetryAfter(ZonedDateTime value) {
        super(NAME, value);
        this.value = null;
        this.supplier = null;
    }

    public RetryAfter(Integer value) {
        super(NAME, (String)null);
        this.value = value;
        this.supplier = null;
    }

    public RetryAfter(Supplier<?> value) {
        super(NAME, (String)null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        if (this.supplier != null) {
            Object o = this.supplier.get();
            if (o == null) {
                return null;
            }
            if (o instanceof Integer) {
                return o.toString();
            }
            if (o instanceof ZonedDateTime) {
                return DateTimeFormatter.RFC_1123_DATE_TIME.format((ZonedDateTime)o);
            }
            throw ThrowableUtils.runtimeException("Invalid object type returned by supplier: {0}", ClassUtils.className(o));
        }
        if (this.value != null) {
            return StringUtils.stringify(this.value);
        }
        return super.getValue();
    }

    public Optional<Integer> asInteger() {
        if (this.supplier != null) {
            Object o = this.supplier.get();
            return CollectionUtils.optional(o instanceof Integer ? (Integer)o : null);
        }
        return CollectionUtils.optional(this.value);
    }
}

