/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.annotation.TargetedAnnotationTBuilder;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.annotation.TargetedAnnotationTMFBuilder;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfParser;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class RdfAnnotation {
    public static final Rdf DEFAULT = RdfAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return RdfAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return RdfAnnotation.create().on(on);
    }

    public static Rdf copy(Rdf a, VarResolverSession r) {
        return RdfAnnotation.create().beanUri((Boolean)r.resolve((Object)a.beanUri())).collectionFormat(a.collectionFormat()).namespace(r.resolve(a.namespace())).on(r.resolve(a.on())).onClass((Class[])a.onClass()).prefix(r.resolve(a.prefix())).build();
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Rdf[] value();
    }

    public static class ParserApplier
    extends AnnotationApplier<Rdf, RdfParser.Builder> {
        public ParserApplier(VarResolverSession vr) {
            super(Rdf.class, RdfParser.Builder.class, vr);
        }

        public void apply(AnnotationInfo<Rdf> ai, RdfParser.Builder b) {
            Rdf a = (Rdf)ai.inner();
            if (ArrayUtils.isEmptyArray((Object[])a.on(), (Object[])a.onClass())) {
                return;
            }
            b.annotations(RdfAnnotation.copy(a, this.vr()));
        }
    }

    public static class SerializerApplier
    extends AnnotationApplier<Rdf, RdfSerializer.Builder> {
        public SerializerApplier(VarResolverSession vr) {
            super(Rdf.class, RdfSerializer.Builder.class, vr);
        }

        public void apply(AnnotationInfo<Rdf> ai, RdfSerializer.Builder b) {
            Rdf a = (Rdf)ai.inner();
            if (ArrayUtils.isEmptyArray((Object[])a.on(), (Object[])a.onClass())) {
                return;
            }
            b.annotations(RdfAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements Rdf {
        private final boolean beanUri;
        private final RdfCollectionFormat collectionFormat;
        private final String namespace;
        private final String prefix;

        Impl(Builder b) {
            super((TargetedAnnotationTBuilder)b);
            this.beanUri = b.beanUri;
            this.collectionFormat = b.collectionFormat;
            this.namespace = b.namespace;
            this.prefix = b.prefix;
            this.postConstruct();
        }

        @Override
        public boolean beanUri() {
            return this.beanUri;
        }

        @Override
        public RdfCollectionFormat collectionFormat() {
            return this.collectionFormat;
        }

        @Override
        public String namespace() {
            return this.namespace;
        }

        @Override
        public String prefix() {
            return this.prefix;
        }
    }

    public static class Builder
    extends TargetedAnnotationTMFBuilder {
        String namespace = "";
        String prefix = "";
        boolean beanUri;
        RdfCollectionFormat collectionFormat = RdfCollectionFormat.DEFAULT;

        protected Builder() {
            super(Rdf.class);
        }

        public Rdf build() {
            return new Impl(this);
        }

        public Builder beanUri(boolean value) {
            this.beanUri = value;
            return this;
        }

        public Builder collectionFormat(RdfCollectionFormat value) {
            this.collectionFormat = value;
            return this;
        }

        public Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public Builder prefix(String value) {
            this.prefix = value;
            return this;
        }

        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }
}

