/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.util.Arrays;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;

@FluentSetters(returns="FluentStringAssertion<R>")
public class FluentStringAssertion<R>
extends FluentObjectAssertion<R> {
    private String text;
    private boolean javaStrings;

    public FluentStringAssertion(String text, R returns) {
        this(null, text, returns);
    }

    public FluentStringAssertion(Assertion creator, String text, R returns) {
        super(creator, text, returns);
        this.text = text;
    }

    @FluentSetter
    public FluentStringAssertion<R> javaStrings() {
        this.javaStrings = true;
        return this;
    }

    public FluentStringAssertion<R> replaceAll(String regex, String replacement) {
        this.assertNotNull("regex", regex);
        this.assertNotNull("replacement", replacement);
        return this.apply(x -> x == null ? null : this.text.replaceAll(regex, replacement));
    }

    public FluentStringAssertion<R> replace(String target, String replacement) {
        this.assertNotNull("target", target);
        this.assertNotNull("replacement", replacement);
        return this.apply(x -> x == null ? null : this.text.replace(target, replacement));
    }

    public FluentStringAssertion<R> urlDecode() {
        return this.apply(x -> StringUtils.urlDecode(x));
    }

    public FluentStringAssertion<R> sort() {
        return this.apply(x -> x == null ? null : Arrays.asList(x.trim().split("[\r\n]+")).stream().sorted().collect(Collectors.joining("\n")));
    }

    public FluentStringAssertion<R> lc() {
        return this.apply(x -> x == null ? null : x.toLowerCase());
    }

    public FluentStringAssertion<R> uc() {
        return this.apply(x -> x == null ? null : x.toUpperCase());
    }

    public FluentStringAssertion<R> apply(Function<String, String> f) {
        return new FluentStringAssertion((Assertion)this, f.apply(this.text), this.returns());
    }

    public R isEqual(String value) throws AssertionError {
        if (!StringUtils.isEquals(value, this.text)) {
            throw this.error("Text differed at position {0}.\n\tExpected=[{1}]\n\tActual=[{2}]", StringUtils.diffPosition(value, this.text), this.fix(value), this.fix(this.text));
        }
        return this.returns();
    }

    public R isEqualLines(String ... lines) throws AssertionError {
        this.assertNotNull("lines", lines);
        String v = StringUtils.join((Object[])lines, '\n');
        if (!StringUtils.isEquals(v, this.text)) {
            throw this.error("Text differed at position {0}.\n\tExpected=[{1}]\n\tActual=[{2}]", StringUtils.diffPosition(v, this.text), this.fix(v), this.fix(this.text));
        }
        return this.returns();
    }

    public R isEqualSortedLines(String ... lines) {
        this.assertNotNull("lines", lines);
        this.exists();
        Object[] e = StringUtils.join((Object[])lines, '\n').trim().split("[\r\n]+");
        Object[] a = this.text.trim().split("[\r\n]+");
        if (e.length != a.length) {
            throw this.error("Expected text had different numbers of lines.\n\tExpected=[{0}]\n\tActual=[{1}]", e.length, a.length);
        }
        Arrays.sort(e);
        Arrays.sort(a);
        for (int i = 0; i < e.length; ++i) {
            if (((String)e[i]).equals(a[i])) continue;
            throw this.error("Expected text had different values at line {0}.\n\tExpected=[{1}]\n\tActual=[{2}]", i + 1, e[i], a[i]);
        }
        return this.returns();
    }

    public R is(String value) throws AssertionError {
        if (!StringUtils.isEquals(value, this.text)) {
            throw this.error("Unexpected value.\n\tExpected=[{0}]\n\tActual=[{1}]", this.fix(value), this.fix(this.text));
        }
        return this.isEqual(value);
    }

    public R isEqualIc(String value) throws AssertionError {
        if (!StringUtils.isEqualsIc(value, this.text)) {
            throw this.error("Text differed at position {0}.\n\tExpected=[{1}]\n\tActual=[{2}]", StringUtils.diffPositionIc(value, this.text), this.fix(value), this.fix(this.text));
        }
        return this.returns();
    }

    public R doesNotEqual(String value) throws AssertionError {
        if (StringUtils.isEquals(value, this.text)) {
            throw this.error("Text equaled unexpected.\n\tText=[{0}]", this.fix(this.text));
        }
        return this.returns();
    }

    public R isNot(String value) throws AssertionError {
        return this.doesNotEqual(value);
    }

    public R doesNotEqualIc(String value) throws AssertionError {
        if (StringUtils.isEqualsIc(value, this.text)) {
            throw this.error("Text equaled unexpected.\n\tText=[{0}]", this.fix(this.text));
        }
        return this.returns();
    }

    public R contains(String ... values) throws AssertionError {
        this.assertNotNull("values", values);
        for (String substring : values) {
            if (substring == null || StringUtils.contains(this.text, substring)) continue;
            throw this.error("Text did not contain expected substring.\n\tSubstring=[{0}]\n\tText=[{1}]", this.fix(substring), this.fix(this.text));
        }
        return this.returns();
    }

    public R doesNotContain(String ... values) throws AssertionError {
        this.assertNotNull("values", values);
        for (String substring : values) {
            if (substring == null || !StringUtils.contains(this.text, substring)) continue;
            throw this.error("Text contained unexpected substring.\n\tSubstring=[{0}]\n\tText=[{1}]", this.fix(substring), this.fix(this.text));
        }
        return this.returns();
    }

    public R isEmpty() throws AssertionError {
        if (this.text != null && !this.text.isEmpty()) {
            throw this.error("Text was not empty.\n\tText=[{0}]", this.fix(this.text));
        }
        return this.returns();
    }

    public R isNotEmpty() throws AssertionError {
        if (this.text == null) {
            throw this.error("Text was null.", new Object[0]);
        }
        if (this.text.isEmpty()) {
            throw this.error("Text was empty.", new Object[0]);
        }
        return this.returns();
    }

    public R matches(String regex) throws AssertionError {
        return this.matches(regex, 0);
    }

    public R matchesSimple(String searchPattern) throws AssertionError {
        this.assertNotNull("searchPattern", searchPattern);
        return this.matches(StringUtils.getMatchPattern(searchPattern));
    }

    public R doesNotMatch(String regex) throws AssertionError {
        this.assertNotNull("regex", regex);
        return this.doesNotMatch(regex, 0);
    }

    public R matches(String regex, int flags) throws AssertionError {
        this.assertNotNull("regex", regex);
        this.exists();
        Pattern p = Pattern.compile(regex, flags);
        if (!p.matcher(this.text).matches()) {
            throw this.error("Text did not match expected pattern.\n\tPattern=[{0}]\n\tText=[{1}]", this.fix(regex), this.fix(this.text));
        }
        return this.returns();
    }

    public R doesNotMatch(String regex, int flags) throws AssertionError {
        this.assertNotNull("regex", regex);
        return this.doesNotMatch(Pattern.compile(regex, flags));
    }

    public R matches(Pattern pattern) throws AssertionError {
        this.assertNotNull("pattern", pattern);
        this.exists();
        if (!pattern.matcher(this.text).matches()) {
            throw this.error("Text did not match expected pattern.\n\tPattern=[{0}]\n\tText=[{1}]", this.fix(pattern.pattern()), this.fix(this.text));
        }
        return this.returns();
    }

    public R doesNotMatch(Pattern pattern) throws AssertionError {
        this.assertNotNull("pattern", pattern);
        if (this.text != null && pattern.matcher(this.text).matches()) {
            throw this.error("Text matched unexpected pattern.\n\tPattern=[{0}]\n\tText=[{1}]", this.fix(pattern.pattern()), this.fix(this.text));
        }
        return this.returns();
    }

    public R startsWith(String string) {
        this.exists();
        this.assertNotNull("string", string);
        if (!this.text.startsWith(string)) {
            throw this.error("Text did not start with expected string.\n\tString=[{0}]\n\tText=[{1}]", this.fix(string), this.fix(this.text));
        }
        return this.returns();
    }

    public R endsWith(String string) {
        this.exists();
        this.assertNotNull("string", string);
        if (!this.text.endsWith(string)) {
            throw this.error("Text did not end with expected string.\n\tString=[{0}]\n\tText=[{1}]", this.fix(string), this.fix(this.text));
        }
        return this.returns();
    }

    private String fix(String text) {
        if (this.javaStrings) {
            text = text.replaceAll("\\\\", "\\\\\\\\").replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t");
        }
        return text;
    }

    @Override
    public FluentStringAssertion<R> msg(String msg, Object ... args) {
        super.msg(msg, args);
        return this;
    }

    @Override
    public FluentStringAssertion<R> stderr() {
        super.stderr();
        return this;
    }

    @Override
    public FluentStringAssertion<R> stdout() {
        super.stdout();
        return this;
    }
}

