/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.vars;

import org.apache.juneau.cp.ResourceManager;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.svl.DefaultingVar;
import org.apache.juneau.svl.VarResolverSession;

public class FileVar
extends DefaultingVar {
    private static final String SESSION_req = "req";
    private static final String SESSION_crm = "crm";
    public static final String NAME = "F";

    public FileVar() {
        super(NAME);
    }

    @Override
    public String resolve(VarResolverSession session, String key) throws Exception {
        RestRequest req = session.getSessionObject(RestRequest.class, SESSION_req, false);
        if (req != null) {
            String s = req.getClasspathResourceAsString(key);
            if (s == null) {
                return null;
            }
            String subType = FileUtils.getExtension(key);
            if ("html".equals(subType) || "xhtml".equals(subType) || "xml".equals(subType)) {
                s = s.replaceAll("(?s)<!--(.*?)-->\\s*", "");
            } else if ("json".equals(subType) || "javascript".equals(subType) || "css".equals(subType)) {
                s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
            }
            return s;
        }
        ResourceManager crm = session.getSessionObject(ResourceManager.class, SESSION_crm, false);
        if (crm != null) {
            return crm.getString(key);
        }
        return null;
    }

    @Override
    public boolean canResolve(VarResolverSession session) {
        return session.hasSessionObject(SESSION_req) || session.hasSessionObject(SESSION_crm);
    }
}

