/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.reshandlers;

import java.io.IOException;
import java.io.InputStream;
import org.apache.juneau.http.exception.HttpException;
import org.apache.juneau.http.exception.NotAcceptable;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.util.FinishableServletOutputStream;
import org.apache.juneau.utils.IOPipe;

public final class InputStreamHandler
implements ResponseHandler {
    @Override
    public boolean handle(RestRequest req, RestResponse res) throws IOException, NotAcceptable, HttpException {
        if (res.isOutputType(InputStream.class)) {
            try (FinishableServletOutputStream os = res.getNegotiatedOutputStream();){
                IOPipe.create(res.getOutput(InputStream.class), os).run();
            }
            return true;
        }
        return false;
    }
}

