/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.helper;

import org.apache.juneau.annotation.Bean;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.jsonschema.annotation.Schema;

@Bean(bpi="name,description", fluentSetters=true)
@Response(schema=@Schema(ignore=true))
public final class ResourceDescription
implements Comparable<ResourceDescription> {
    private String name;
    private String uri;
    private String description;

    public ResourceDescription(String name, String description) {
        this.name = name;
        this.uri = name;
        this.description = description;
    }

    public ResourceDescription(String name, String uri, String description) {
        this.name = name;
        this.uri = uri;
        this.description = description;
    }

    public ResourceDescription() {
    }

    @Html(link="servlet:/{uri}")
    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri == null ? this.name : this.uri;
    }

    public ResourceDescription name(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ResourceDescription description(String description) {
        this.description = description;
        return this;
    }

    public ResourceDescription uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public int compareTo(ResourceDescription o) {
        return this.getName().toString().compareTo(o.getName().toString());
    }

    public boolean equals(Object o) {
        return o instanceof ResourceDescription && ObjectUtils.eq(this, (ResourceDescription)o, (x, y) -> ObjectUtils.eq(x.getName(), y.getName()));
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

