/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client2;

import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.BackoffManager;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.juneau.BeanContextBuilder;
import org.apache.juneau.ConfigException;
import org.apache.juneau.Context;
import org.apache.juneau.DetailLevel;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Visibility;
import org.apache.juneau.html.HtmlDocSerializer;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlStrippedDocSerializer;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.BasicNameValuePair;
import org.apache.juneau.http.HeaderSupplier;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.NameValuePairSupplier;
import org.apache.juneau.http.SerializedHeader;
import org.apache.juneau.http.SerializedNameValuePair;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.marshall.Marshall;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.plaintext.PlainTextParser;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.rest.client2.RestCallHandler;
import org.apache.juneau.rest.client2.RestCallInterceptor;
import org.apache.juneau.rest.client2.RestClient;
import org.apache.juneau.rest.client2.RestRequest;
import org.apache.juneau.rest.client2.RestResponse;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.transform.BeanInterceptor;
import org.apache.juneau.uon.ParamFormat;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;

@FluentSetters(ignore={"beanMapPutReturnsOldValue", "example", "exampleJson"})
public class RestClientBuilder
extends BeanContextBuilder {
    private HttpClientBuilder httpClientBuilder;
    private CloseableHttpClient httpClient;
    private HttpClientConnectionManager httpClientConnectionManager;
    private boolean pooled;

    protected RestClientBuilder(PropertyStore ps) {
        super(ps);
        HttpClientBuilder httpClientBuilder = this.peek(HttpClientBuilder.class, "RestClient.httpClientBuilder.o");
        this.httpClientBuilder = httpClientBuilder != null ? httpClientBuilder : this.getHttpClientBuilder();
    }

    protected RestClientBuilder() {
        this((PropertyStore)null);
    }

    @Override
    public RestClient build() {
        this.set("RestClient.httpClient.o", this.getHttpClient());
        this.set("RestClient.httpClientBuilder.o", this.getHttpClientBuilder());
        return new RestClient(this.getPropertyStore());
    }

    @Override
    public <T extends Context> T build(Class<T> c) {
        this.set("RestClient.httpClient.o", this.getHttpClient());
        this.set("RestClient.httpClientBuilder.o", this.getHttpClientBuilder());
        return super.build(c);
    }

    @FluentSetter
    public RestClientBuilder json() {
        return this.serializer(JsonSerializer.class).parser(JsonParser.class);
    }

    @FluentSetter
    public RestClientBuilder simpleJson() {
        return this.serializer(SimpleJsonSerializer.class).parser(SimpleJsonParser.class);
    }

    @FluentSetter
    public RestClientBuilder xml() {
        return this.serializer(XmlSerializer.class).parser(XmlParser.class);
    }

    @FluentSetter
    public RestClientBuilder html() {
        return this.serializer(HtmlSerializer.class).parser(HtmlParser.class);
    }

    @FluentSetter
    public RestClientBuilder htmlDoc() {
        return this.serializer(HtmlDocSerializer.class).parser(HtmlParser.class);
    }

    @FluentSetter
    public RestClientBuilder htmlStrippedDoc() {
        return this.serializer(HtmlStrippedDocSerializer.class).parser(HtmlParser.class);
    }

    @FluentSetter
    public RestClientBuilder plainText() {
        return this.serializer(PlainTextSerializer.class).parser(PlainTextParser.class);
    }

    @FluentSetter
    public RestClientBuilder msgPack() {
        return this.serializer(MsgPackSerializer.class).parser(MsgPackParser.class);
    }

    @FluentSetter
    public RestClientBuilder uon() {
        return this.serializer(UonSerializer.class).parser(UonParser.class);
    }

    @FluentSetter
    public RestClientBuilder urlEnc() {
        return this.serializer(UrlEncodingSerializer.class).parser(UrlEncodingParser.class);
    }

    @FluentSetter
    public RestClientBuilder openApi() {
        return this.serializer(OpenApiSerializer.class).parser(OpenApiParser.class);
    }

    public RestClientBuilder universal() {
        return this.serializers(JsonSerializer.class, SimpleJsonSerializer.class, HtmlSerializer.class, XmlSerializer.class, UonSerializer.class, UrlEncodingSerializer.class, OpenApiSerializer.class, MsgPackSerializer.class, PlainTextSerializer.class).parsers(JsonParser.class, SimpleJsonParser.class, XmlParser.class, HtmlParser.class, UonParser.class, UrlEncodingParser.class, OpenApiParser.class, MsgPackParser.class, PlainTextParser.class);
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        return HttpClientBuilder.create();
    }

    @FluentSetter
    public RestClientBuilder httpClientBuilder(HttpClientBuilder value) {
        this.httpClientBuilder = value;
        return this;
    }

    final HttpClientBuilder getHttpClientBuilder() {
        if (this.httpClientBuilder == null) {
            this.httpClientBuilder = this.createHttpClientBuilder();
        }
        return this.httpClientBuilder;
    }

    protected CloseableHttpClient createHttpClient() {
        if (this.httpClientConnectionManager == null) {
            this.httpClientBuilder.setConnectionManager(this.createConnectionManager());
        } else {
            this.httpClientBuilder.setConnectionManager(this.httpClientConnectionManager);
        }
        return this.httpClientBuilder.build();
    }

    @FluentSetter
    public RestClientBuilder httpClient(CloseableHttpClient value) {
        this.httpClient = value;
        return this;
    }

    final CloseableHttpClient getHttpClient() {
        return this.httpClient != null ? this.httpClient : this.createHttpClient();
    }

    @FluentSetter
    public RestClientBuilder logger(Logger value) {
        return this.set("RestClient.logger.o", value);
    }

    @FluentSetter
    public RestClientBuilder logToConsole() {
        return this.set("RestClient.logToConsole.b", true);
    }

    @FluentSetter
    public RestClientBuilder logRequests(DetailLevel detail, Level level, BiPredicate<RestRequest, RestResponse> test) {
        this.set("RestClient.logRequests.s", (Object)detail);
        this.set("RestClient.logRequestsLevel.s", level);
        this.set("RestClient.logRequestsPredicate.o", test);
        return this;
    }

    protected HttpClientConnectionManager createConnectionManager() {
        return this.pooled ? new PoolingHttpClientConnectionManager() : new BasicHttpClientConnectionManager();
    }

    @FluentSetter
    public RestClientBuilder pooled() {
        this.pooled = true;
        return this;
    }

    @FluentSetter
    public RestClientBuilder basicAuth(String host, int port, String user, String pw) {
        AuthScope scope = new AuthScope(host, port);
        UsernamePasswordCredentials up = new UsernamePasswordCredentials(user, pw);
        BasicCredentialsProvider p = new BasicCredentialsProvider();
        p.setCredentials(scope, (Credentials)up);
        this.defaultCredentialsProvider((CredentialsProvider)p);
        return this;
    }

    @FluentSetter
    public RestClientBuilder header(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer) {
        return this.headers(RestClientBuilder.serializedHeader(name, value, serializer, schema));
    }

    @FluentSetter
    public RestClientBuilder header(String name, Supplier<?> value, HttpPartSchema schema, HttpPartSerializer serializer) {
        return this.headers(RestClientBuilder.serializedHeader(name, value, serializer, schema));
    }

    @FluentSetter
    public RestClientBuilder header(String name, Object value, HttpPartSchema schema) {
        return this.headers(RestClientBuilder.serializedHeader(name, value, null, schema));
    }

    @FluentSetter
    public RestClientBuilder header(String name, Supplier<?> value, HttpPartSchema schema) {
        return this.headers(RestClientBuilder.serializedHeader(name, value, null, schema));
    }

    @FluentSetter
    public RestClientBuilder header(String name, Object value) {
        return this.headers(RestClientBuilder.serializedHeader(name, value, null, null));
    }

    @FluentSetter
    public RestClientBuilder header(String name, Supplier<?> value) {
        return this.headers(RestClientBuilder.serializedHeader(name, value, null, null));
    }

    @FluentSetter
    public RestClientBuilder header(Header header) {
        return this.headers(header);
    }

    @FluentSetter
    public RestClientBuilder headers(Object ... headers) {
        for (Object h : headers) {
            if (BasicHeader.canCast(h) || h instanceof HeaderSupplier) {
                this.appendTo("RestClient.headers.lo", h);
                continue;
            }
            if (h instanceof Map) {
                for (Map.Entry<Object, Object> e : RestClientBuilder.toMap(h).entrySet()) {
                    this.appendTo("RestClient.headers.lo", RestClientBuilder.serializedHeader(e.getKey(), e.getValue(), null, null));
                }
                continue;
            }
            if (h instanceof Collection) {
                for (Object o : (Collection)h) {
                    this.headers(o);
                }
                continue;
            }
            if (h != null && h.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(h); ++i) {
                    this.headers(Array.get(h, i));
                }
                continue;
            }
            if (h == null) continue;
            throw new RuntimeException("Invalid type passed to headers():  " + ClassUtils.className(h));
        }
        return this;
    }

    @FluentSetter
    public RestClientBuilder headerPairs(Object ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new RuntimeException("Odd number of parameters passed into headerPairs()");
        }
        for (int i = 0; i < pairs.length; i += 2) {
            this.headers(RestClientBuilder.serializedHeader(pairs[i], pairs[i + 1], null, null));
        }
        return this;
    }

    @FluentSetter
    public RestClientBuilder accept(Object value) {
        return this.header("Accept", value);
    }

    @FluentSetter
    public RestClientBuilder acceptCharset(Object value) {
        return this.header("Accept-Charset", value);
    }

    @FluentSetter
    public RestClientBuilder acceptEncoding(Object value) {
        return this.header("Accept-Encoding", value);
    }

    @FluentSetter
    public RestClientBuilder acceptLanguage(Object value) {
        return this.header("Accept-Language", value);
    }

    @FluentSetter
    public RestClientBuilder authorization(Object value) {
        return this.header("Authorization", value);
    }

    @FluentSetter
    public RestClientBuilder cacheControl(Object value) {
        return this.header("Cache-Control", value);
    }

    @FluentSetter
    public RestClientBuilder clientVersion(Object value) {
        return this.header("X-Client-Version", value);
    }

    @FluentSetter
    public RestClientBuilder connection(Object value) {
        return this.header("Connection", value);
    }

    @FluentSetter
    public RestClientBuilder contentLength(Object value) {
        return this.header("Content-Length", value);
    }

    @FluentSetter
    public RestClientBuilder contentType(Object value) {
        return this.header("Content-Type", value);
    }

    @FluentSetter
    public RestClientBuilder contentEncoding(Object value) {
        return this.header("Content-Encoding", value);
    }

    @FluentSetter
    public RestClientBuilder date(Object value) {
        return this.header("Date", value);
    }

    @FluentSetter
    public RestClientBuilder expect(Object value) {
        return this.header("Expect", value);
    }

    @FluentSetter
    public RestClientBuilder forwarded(Object value) {
        return this.header("Forwarded", value);
    }

    @FluentSetter
    public RestClientBuilder from(Object value) {
        return this.header("From", value);
    }

    @FluentSetter
    public RestClientBuilder host(Object value) {
        return this.header("Host", value);
    }

    @FluentSetter
    public RestClientBuilder ifMatch(Object value) {
        return this.header("If-Match", value);
    }

    @FluentSetter
    public RestClientBuilder ifModifiedSince(Object value) {
        return this.header("If-Modified-Since", value);
    }

    @FluentSetter
    public RestClientBuilder ifNoneMatch(Object value) {
        return this.header("If-None-Match", value);
    }

    @FluentSetter
    public RestClientBuilder ifRange(Object value) {
        return this.header("If-Range", value);
    }

    @FluentSetter
    public RestClientBuilder ifUnmodifiedSince(Object value) {
        return this.header("If-Unmodified-Since", value);
    }

    @FluentSetter
    public RestClientBuilder maxForwards(Object value) {
        return this.header("Max-Forwards", value);
    }

    @FluentSetter
    public RestClientBuilder noTrace() {
        return this.header("No-Trace", true);
    }

    @FluentSetter
    public RestClientBuilder origin(Object value) {
        return this.header("Origin", value);
    }

    @FluentSetter
    public RestClientBuilder pragma(Object value) {
        return this.header("Pragma", value);
    }

    @FluentSetter
    public RestClientBuilder proxyAuthorization(Object value) {
        return this.header("Proxy-Authorization", value);
    }

    @FluentSetter
    public RestClientBuilder range(Object value) {
        return this.header("Range", value);
    }

    @FluentSetter
    public RestClientBuilder referer(Object value) {
        return this.header("Referer", value);
    }

    @FluentSetter
    public RestClientBuilder te(Object value) {
        return this.header("TE", value);
    }

    @FluentSetter
    public RestClientBuilder userAgent(Object value) {
        return this.header("User-Agent", value);
    }

    @FluentSetter
    public RestClientBuilder upgrade(Object value) {
        return this.header("Upgrade", value);
    }

    @FluentSetter
    public RestClientBuilder via(Object value) {
        return this.header("Via", value);
    }

    @FluentSetter
    public RestClientBuilder warning(Object value) {
        return this.header("Warning", value);
    }

    @FluentSetter
    public RestClientBuilder query(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer) {
        return this.queries(RestClientBuilder.serializedNameValuePair(name, value, HttpPartType.QUERY, serializer, schema));
    }

    @FluentSetter
    public RestClientBuilder query(String name, Supplier<?> value, HttpPartSchema schema, HttpPartSerializer serializer) {
        return this.queries(RestClientBuilder.serializedNameValuePair(name, value, HttpPartType.QUERY, serializer, schema));
    }

    @FluentSetter
    public RestClientBuilder query(String name, Object value, HttpPartSchema schema) {
        return this.queries(RestClientBuilder.serializedNameValuePair(name, value, HttpPartType.QUERY, null, schema));
    }

    @FluentSetter
    public RestClientBuilder query(String name, Supplier<?> value, HttpPartSchema schema) {
        return this.queries(RestClientBuilder.serializedNameValuePair(name, value, HttpPartType.QUERY, null, schema));
    }

    @FluentSetter
    public RestClientBuilder query(String name, Object value) {
        return this.queries(RestClientBuilder.serializedNameValuePair(name, value, HttpPartType.QUERY, null, null));
    }

    @FluentSetter
    public RestClientBuilder query(NameValuePair pair) {
        return this.queries(pair);
    }

    @FluentSetter
    public RestClientBuilder query(String name, Supplier<?> value) {
        return this.queries(RestClientBuilder.serializedNameValuePair(name, value, HttpPartType.QUERY, null, null));
    }

    @FluentSetter
    public RestClientBuilder queries(Object ... params) {
        for (Object p : params) {
            if (BasicNameValuePair.canCast(p) || p instanceof NameValuePairSupplier) {
                this.appendTo("RestClient.query.lo", p);
                continue;
            }
            if (p instanceof Map) {
                for (Map.Entry<Object, Object> e : RestClientBuilder.toMap(p).entrySet()) {
                    this.appendTo("RestClient.query.lo", RestClientBuilder.serializedNameValuePair(e.getKey(), e.getValue(), HttpPartType.QUERY, null, null));
                }
                continue;
            }
            if (p instanceof Collection) {
                for (Object o : (Collection)p) {
                    this.queries(o);
                }
                continue;
            }
            if (p != null && p.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(p); ++i) {
                    this.queries(Array.get(p, i));
                }
                continue;
            }
            if (p == null) continue;
            throw new RuntimeException("Invalid type passed to query():  " + ClassUtils.className(p));
        }
        return this;
    }

    @FluentSetter
    public RestClientBuilder queryPairs(Object ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new RuntimeException("Odd number of parameters passed into queryPairs(Object...)");
        }
        for (int i = 0; i < pairs.length; i += 2) {
            this.queries(RestClientBuilder.serializedNameValuePair(pairs[i], pairs[i + 1], HttpPartType.QUERY, null, null));
        }
        return this;
    }

    @FluentSetter
    public RestClientBuilder formData(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer) {
        return this.formDatas(RestClientBuilder.serializedNameValuePair(name, value, HttpPartType.FORMDATA, serializer, schema));
    }

    @FluentSetter
    public RestClientBuilder formData(String name, Supplier<?> value, HttpPartSchema schema, HttpPartSerializer serializer) {
        return this.formDatas(RestClientBuilder.serializedNameValuePair(name, value, HttpPartType.FORMDATA, serializer, schema));
    }

    @FluentSetter
    public RestClientBuilder formData(String name, Object value, HttpPartSchema schema) {
        return this.formDatas(RestClientBuilder.serializedNameValuePair(name, value, HttpPartType.FORMDATA, null, schema));
    }

    @FluentSetter
    public RestClientBuilder formData(String name, Supplier<?> value, HttpPartSchema schema) {
        return this.formDatas(RestClientBuilder.serializedNameValuePair(name, value, HttpPartType.FORMDATA, null, schema));
    }

    @FluentSetter
    public RestClientBuilder formData(String name, Object value) {
        return this.formDatas(RestClientBuilder.serializedNameValuePair(name, value, HttpPartType.FORMDATA, null, null));
    }

    @FluentSetter
    public RestClientBuilder formData(NameValuePair pair) {
        return this.formDatas(pair);
    }

    @FluentSetter
    public RestClientBuilder formData(String name, Supplier<?> value) {
        return this.formDatas(RestClientBuilder.serializedNameValuePair(name, value, HttpPartType.FORMDATA, null, null));
    }

    @FluentSetter
    public RestClientBuilder formDatas(Object ... params) {
        for (Object p : params) {
            if (BasicNameValuePair.canCast(p) || p instanceof NameValuePairSupplier) {
                this.appendTo("RestClient.formData.lo", p);
                continue;
            }
            if (p instanceof Map) {
                for (Map.Entry<Object, Object> e : RestClientBuilder.toMap(p).entrySet()) {
                    this.appendTo("RestClient.formData.lo", RestClientBuilder.serializedNameValuePair(e.getKey(), e.getValue(), HttpPartType.FORMDATA, null, null));
                }
                continue;
            }
            if (p instanceof Collection) {
                for (Object o : (Collection)p) {
                    this.formDatas(o);
                }
                continue;
            }
            if (p != null && p.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(p); ++i) {
                    this.formDatas(Array.get(p, i));
                }
                continue;
            }
            if (p == null) continue;
            throw new RuntimeException("Invalid type passed to formData():  " + ClassUtils.className(p));
        }
        return this;
    }

    @FluentSetter
    public RestClientBuilder formDataPairs(Object ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new RuntimeException("Odd number of parameters passed into formDataPairs()");
        }
        for (int i = 0; i < pairs.length; i += 2) {
            this.formDatas(RestClientBuilder.serializedNameValuePair(pairs[i], pairs[i + 1], HttpPartType.FORMDATA, null, null));
        }
        return this;
    }

    @FluentSetter
    public RestClientBuilder callHandler(Class<? extends RestCallHandler> value) {
        return this.set("RestClient.callHandler.o", value);
    }

    @FluentSetter
    public RestClientBuilder callHandler(RestCallHandler value) {
        return this.set("RestClient.callHandler.o", value);
    }

    @FluentSetter
    public RestClientBuilder console(Class<? extends PrintStream> value) {
        return this.set("RestClient.console.o", value);
    }

    @FluentSetter
    public RestClientBuilder console(PrintStream value) {
        return this.set("RestClient.console.o", value);
    }

    @FluentSetter
    public RestClientBuilder errorCodes(Predicate<Integer> value) {
        return this.set("RestClient.errorCodes.o", value);
    }

    @FluentSetter
    public RestClientBuilder executorService(ExecutorService executorService, boolean shutdownOnClose) {
        this.set("RestClient.executorService.o", executorService);
        this.set("RestClient.executorServiceShutdownOnClose.b", shutdownOnClose);
        return this;
    }

    @FluentSetter
    public RestClientBuilder keepHttpClientOpen() {
        return this.set("RestClient.keepHttpClientOpen.b", true);
    }

    @FluentSetter
    public RestClientBuilder ignoreErrors() {
        return this.ignoreErrors(true);
    }

    @FluentSetter
    public RestClientBuilder ignoreErrors(boolean value) {
        return this.set("RestClient.ignoreErrors.b", value);
    }

    @FluentSetter
    public RestClientBuilder interceptors(Class<?> ... values) throws Exception {
        for (Class<?> c : values) {
            ClassInfo ci = ClassInfo.of(c);
            if (ci == null) continue;
            if (ci.isChildOfAny(RestCallInterceptor.class, HttpRequestInterceptor.class, HttpResponseInterceptor.class)) {
                this.interceptors(ci.newInstance());
                continue;
            }
            throw new ConfigException("Invalid class of type ''{0}'' passed to interceptors().", ci.getName());
        }
        return this;
    }

    @FluentSetter
    public RestClientBuilder interceptors(Object ... value) {
        ArrayList<RestCallInterceptor> l = new ArrayList<RestCallInterceptor>();
        for (Object o : value) {
            ClassInfo ci = ClassInfo.of(o);
            if (ci == null) continue;
            if (!ci.isChildOfAny(HttpRequestInterceptor.class, HttpResponseInterceptor.class, RestCallInterceptor.class)) {
                throw new ConfigException("Invalid object of type ''{0}'' passed to interceptors().", ci.getName());
            }
            if (o instanceof HttpRequestInterceptor) {
                this.addInterceptorLast((HttpRequestInterceptor)o);
            }
            if (o instanceof HttpResponseInterceptor) {
                this.addInterceptorLast((HttpResponseInterceptor)o);
            }
            if (!(o instanceof RestCallInterceptor)) continue;
            l.add((RestCallInterceptor)o);
        }
        return this.prependTo("RestClient.interceptors.lo", l);
    }

    @FluentSetter
    public RestClientBuilder leakDetection() {
        return this.set("RestClient.leakDetection.b", true);
    }

    @FluentSetter
    public RestClientBuilder marshall(Marshall value) {
        if (value != null) {
            this.serializer(value.getSerializer()).parser(value.getParser());
        }
        return this;
    }

    @FluentSetter
    public RestClientBuilder marshalls(Marshall ... value) {
        for (Marshall m : value) {
            if (m == null) continue;
            this.serializer(m.getSerializer()).parser(m.getParser());
        }
        return this;
    }

    @FluentSetter
    public RestClientBuilder parser(Class<? extends Parser> value) {
        return this.parsers(value);
    }

    @FluentSetter
    public RestClientBuilder parser(Parser value) {
        return this.parsers(value);
    }

    @FluentSetter
    public RestClientBuilder parsers(Class<? extends Parser> ... value) {
        return this.prependTo("RestClient.parsers.lo", value);
    }

    @FluentSetter
    public RestClientBuilder parsers(Parser ... value) {
        return this.prependTo("RestClient.parsers.lo", value);
    }

    @FluentSetter
    public RestClientBuilder partParser(Class<? extends HttpPartParser> value) {
        return this.set("RestClient.partParser.o", value);
    }

    @FluentSetter
    public RestClientBuilder partParser(HttpPartParser value) {
        return this.set("RestClient.partParser.o", value);
    }

    @FluentSetter
    public RestClientBuilder partSerializer(Class<? extends HttpPartSerializer> value) {
        return this.set("RestClient.partSerializer.o", value);
    }

    @FluentSetter
    public RestClientBuilder partSerializer(HttpPartSerializer value) {
        return this.set("RestClient.partSerializer.o", value);
    }

    @FluentSetter
    public RestClientBuilder rootUri(Object value) {
        return this.set("RestClient.rootUri.s", value);
    }

    @FluentSetter
    public RestClientBuilder serializer(Class<? extends Serializer> value) {
        return this.serializers(value);
    }

    @FluentSetter
    public RestClientBuilder serializer(Serializer value) {
        return this.serializers(value);
    }

    @FluentSetter
    public RestClientBuilder serializers(Class<? extends Serializer> ... value) {
        return this.prependTo("RestClient.serializers.lo", value);
    }

    @FluentSetter
    public RestClientBuilder serializers(Serializer ... value) {
        return this.prependTo("RestClient.serializers.lo", value);
    }

    @FluentSetter
    public RestClientBuilder detectRecursions() {
        return this.set("BeanTraverseContext.detectRecursions.b", true);
    }

    @FluentSetter
    public RestClientBuilder ignoreRecursions() {
        return this.set("BeanTraverseContext.ignoreRecursions.b", true);
    }

    @FluentSetter
    public RestClientBuilder initialDepth(int value) {
        return this.set("BeanTraverseContext.initialDepth.i", value);
    }

    @FluentSetter
    public RestClientBuilder maxDepth(int value) {
        return this.set("BeanTraverseContext.maxDepth.i", value);
    }

    @FluentSetter
    public RestClientBuilder addBeanTypes() {
        return this.set("Serializer.addBeanTypes.b", true);
    }

    @FluentSetter
    public RestClientBuilder addRootType() {
        return this.set("Serializer.addRootType.b", true);
    }

    @FluentSetter
    public RestClientBuilder keepNullProperties() {
        return this.set("Serializer.keepNullProperties.b", true);
    }

    @FluentSetter
    public RestClientBuilder sortCollections() {
        return this.set("Serializer.sortCollections.b", true);
    }

    @FluentSetter
    public RestClientBuilder sortMaps() {
        return this.set("Serializer.sortMaps.b", true);
    }

    @FluentSetter
    public RestClientBuilder trimEmptyCollections() {
        return this.set("Serializer.trimEmptyCollections.b", true);
    }

    @FluentSetter
    public RestClientBuilder trimEmptyMaps() {
        return this.set("Serializer.trimEmptyMaps.b", true);
    }

    @FluentSetter
    public RestClientBuilder trimStringsOnWrite() {
        return this.set("Serializer.trimStrings.b", true);
    }

    @FluentSetter
    public RestClientBuilder uriContext(UriContext value) {
        return this.set("Serializer.uriContext.s", value);
    }

    @FluentSetter
    public RestClientBuilder uriRelativity(UriRelativity value) {
        return this.set("Serializer.uriRelativity.s", (Object)value);
    }

    @FluentSetter
    public RestClientBuilder uriResolution(UriResolution value) {
        return this.set("Serializer.uriResolution.s", (Object)value);
    }

    @FluentSetter
    public RestClientBuilder maxIndent(int value) {
        return this.set("WriterSerializer.maxIndent.i", value);
    }

    @FluentSetter
    public RestClientBuilder quoteChar(char value) {
        return this.set("WriterSerializer.quoteChar.s", Character.valueOf(value));
    }

    @FluentSetter
    public RestClientBuilder sq() {
        return this.set("WriterSerializer.quoteChar.s", Character.valueOf('\''));
    }

    @FluentSetter
    public RestClientBuilder useWhitespace() {
        return this.set("WriterSerializer.useWhitespace.b", true);
    }

    @FluentSetter
    public RestClientBuilder ws() {
        return this.set("WriterSerializer.useWhitespace.b", true);
    }

    @FluentSetter
    public RestClientBuilder debugOutputLines(int value) {
        this.set("Parser.debugOutputLines.i", value);
        return this;
    }

    @FluentSetter
    public RestClientBuilder strict() {
        return this.set("Parser.strict.b", true);
    }

    @FluentSetter
    public RestClientBuilder trimStringsOnRead() {
        return this.set("Parser.trimStrings.b", true);
    }

    @FluentSetter
    public RestClientBuilder oapiFormat(HttpPartFormat value) {
        return this.set("OpenApi.format.s", (Object)value);
    }

    @FluentSetter
    public RestClientBuilder oapiCollectionFormat(HttpPartCollectionFormat value) {
        return this.set("OpenApi.collectionformat.s", (Object)value);
    }

    @FluentSetter
    public RestClientBuilder paramFormat(ParamFormat value) {
        return this.set("UonSerializer.paramFormat.s", (Object)value);
    }

    @FluentSetter
    public RestClientBuilder paramFormatPlain() {
        return this.set("UonSerializer.paramFormat.s", (Object)ParamFormat.PLAINTEXT);
    }

    @Override
    public RestClientBuilder add(Map<String, Object> properties) {
        super.add((Map)properties);
        return this;
    }

    @Override
    public RestClientBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    @Override
    public RestClientBuilder appendTo(String name, Object value) {
        super.appendTo(name, value);
        return this;
    }

    @Override
    public RestClientBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    @Override
    public RestClientBuilder applyAnnotations(Class<?> ... fromClasses) {
        super.applyAnnotations((Class[])fromClasses);
        return this;
    }

    @Override
    public RestClientBuilder applyAnnotations(Method ... fromMethods) {
        super.applyAnnotations(fromMethods);
        return this;
    }

    @Override
    public RestClientBuilder applyAnnotations(AnnotationList al, VarResolverSession r) {
        super.applyAnnotations(al, r);
        return this;
    }

    @Override
    public RestClientBuilder debug() {
        super.debug();
        return this;
    }

    @Override
    public RestClientBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    @Override
    public RestClientBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    @Override
    public RestClientBuilder prependTo(String name, Object value) {
        super.prependTo(name, value);
        return this;
    }

    @Override
    public RestClientBuilder putAllTo(String name, Object value) {
        super.putAllTo(name, value);
        return this;
    }

    @Override
    public RestClientBuilder putTo(String name, String key, Object value) {
        super.putTo(name, key, value);
        return this;
    }

    @Override
    public RestClientBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    @Override
    public RestClientBuilder set(Map<String, Object> properties) {
        super.set((Map)properties);
        return this;
    }

    @Override
    public RestClientBuilder set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    @Override
    public RestClientBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    @Override
    public RestClientBuilder annotations(Annotation ... values) {
        super.annotations(values);
        return this;
    }

    @Override
    public RestClientBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    @Override
    public RestClientBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    @Override
    public RestClientBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    @Override
    public RestClientBuilder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
        super.beanInterceptor(on, value);
        return this;
    }

    @Override
    public RestClientBuilder beanMethodVisibility(Visibility value) {
        super.beanMethodVisibility(value);
        return this;
    }

    @Override
    public RestClientBuilder beansDontRequireSomeProperties() {
        super.beansDontRequireSomeProperties();
        return this;
    }

    @Override
    public RestClientBuilder beansRequireDefaultConstructor() {
        super.beansRequireDefaultConstructor();
        return this;
    }

    @Override
    public RestClientBuilder beansRequireSerializable() {
        super.beansRequireSerializable();
        return this;
    }

    @Override
    public RestClientBuilder beansRequireSettersForGetters() {
        super.beansRequireSettersForGetters();
        return this;
    }

    @Override
    public RestClientBuilder bpi(Map<String, Object> values) {
        super.bpi(values);
        return this;
    }

    @Override
    public RestClientBuilder bpi(Class<?> beanClass, String properties) {
        super.bpi(beanClass, properties);
        return this;
    }

    @Override
    public RestClientBuilder bpi(String beanClassName, String properties) {
        super.bpi(beanClassName, properties);
        return this;
    }

    @Override
    public RestClientBuilder bpro(Map<String, Object> values) {
        super.bpro(values);
        return this;
    }

    @Override
    public RestClientBuilder bpro(Class<?> beanClass, String properties) {
        super.bpro(beanClass, properties);
        return this;
    }

    @Override
    public RestClientBuilder bpro(String beanClassName, String properties) {
        super.bpro(beanClassName, properties);
        return this;
    }

    @Override
    public RestClientBuilder bpwo(Map<String, Object> values) {
        super.bpwo(values);
        return this;
    }

    @Override
    public RestClientBuilder bpwo(Class<?> beanClass, String properties) {
        super.bpwo(beanClass, properties);
        return this;
    }

    @Override
    public RestClientBuilder bpwo(String beanClassName, String properties) {
        super.bpwo(beanClassName, properties);
        return this;
    }

    @Override
    public RestClientBuilder bpx(Map<String, Object> values) {
        super.bpx(values);
        return this;
    }

    @Override
    public RestClientBuilder bpx(Class<?> beanClass, String properties) {
        super.bpx(beanClass, properties);
        return this;
    }

    @Override
    public RestClientBuilder bpx(String beanClassName, String properties) {
        super.bpx(beanClassName, properties);
        return this;
    }

    @Override
    public RestClientBuilder dictionary(Object ... values) {
        super.dictionary(values);
        return this;
    }

    @Override
    public RestClientBuilder dictionaryOn(Class<?> on, Class<?> ... values) {
        super.dictionaryOn(on, values);
        return this;
    }

    @Override
    public RestClientBuilder dontIgnorePropertiesWithoutSetters() {
        super.dontIgnorePropertiesWithoutSetters();
        return this;
    }

    @Override
    public RestClientBuilder dontIgnoreTransientFields() {
        super.dontIgnoreTransientFields();
        return this;
    }

    @Override
    public RestClientBuilder dontIgnoreUnknownNullBeanProperties() {
        super.dontIgnoreUnknownNullBeanProperties();
        return this;
    }

    @Override
    public RestClientBuilder dontUseInterfaceProxies() {
        super.dontUseInterfaceProxies();
        return this;
    }

    @Override
    public RestClientBuilder fluentSetters() {
        super.fluentSetters();
        return this;
    }

    @Override
    public RestClientBuilder fluentSetters(Class<?> on) {
        super.fluentSetters(on);
        return this;
    }

    @Override
    public RestClientBuilder ignoreInvocationExceptionsOnGetters() {
        super.ignoreInvocationExceptionsOnGetters();
        return this;
    }

    @Override
    public RestClientBuilder ignoreInvocationExceptionsOnSetters() {
        super.ignoreInvocationExceptionsOnSetters();
        return this;
    }

    @Override
    public RestClientBuilder ignoreUnknownBeanProperties() {
        super.ignoreUnknownBeanProperties();
        return this;
    }

    @Override
    public RestClientBuilder implClass(Class<?> interfaceClass, Class<?> implClass) {
        super.implClass(interfaceClass, implClass);
        return this;
    }

    @Override
    public RestClientBuilder implClasses(Map<Class<?>, Class<?>> values) {
        super.implClasses(values);
        return this;
    }

    @Override
    public RestClientBuilder interfaceClass(Class<?> on, Class<?> value) {
        super.interfaceClass(on, value);
        return this;
    }

    @Override
    public RestClientBuilder interfaces(Class<?> ... value) {
        super.interfaces(value);
        return this;
    }

    @Override
    public RestClientBuilder notBeanClasses(Object ... values) {
        super.notBeanClasses(values);
        return this;
    }

    @Override
    public RestClientBuilder notBeanPackages(Object ... values) {
        super.notBeanPackages(values);
        return this;
    }

    @Override
    public RestClientBuilder propertyNamer(Class<? extends PropertyNamer> value) {
        super.propertyNamer(value);
        return this;
    }

    @Override
    public RestClientBuilder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
        super.propertyNamer(on, value);
        return this;
    }

    @Override
    public RestClientBuilder sortProperties() {
        super.sortProperties();
        return this;
    }

    @Override
    public RestClientBuilder sortProperties(Class<?> ... on) {
        super.sortProperties(on);
        return this;
    }

    @Override
    public RestClientBuilder stopClass(Class<?> on, Class<?> value) {
        super.stopClass(on, value);
        return this;
    }

    @Override
    public RestClientBuilder swaps(Object ... values) {
        super.swaps(values);
        return this;
    }

    @Override
    public RestClientBuilder typeName(Class<?> on, String value) {
        super.typeName(on, value);
        return this;
    }

    @Override
    public RestClientBuilder typePropertyName(String value) {
        super.typePropertyName(value);
        return this;
    }

    @Override
    public RestClientBuilder typePropertyName(Class<?> on, String value) {
        super.typePropertyName(on, value);
        return this;
    }

    @Override
    public RestClientBuilder useEnumNames() {
        super.useEnumNames();
        return this;
    }

    @Override
    public RestClientBuilder useJavaBeanIntrospector() {
        super.useJavaBeanIntrospector();
        return this;
    }

    @FluentSetter
    public RestClientBuilder disableRedirectHandling() {
        this.httpClientBuilder.disableRedirectHandling();
        return this;
    }

    @FluentSetter
    public RestClientBuilder redirectStrategy(RedirectStrategy redirectStrategy) {
        this.httpClientBuilder.setRedirectStrategy(redirectStrategy);
        return this;
    }

    @FluentSetter
    public RestClientBuilder defaultCookieSpecRegistry(Lookup<CookieSpecProvider> cookieSpecRegistry) {
        this.httpClientBuilder.setDefaultCookieSpecRegistry(cookieSpecRegistry);
        return this;
    }

    @FluentSetter
    public RestClientBuilder requestExecutor(HttpRequestExecutor requestExec) {
        this.httpClientBuilder.setRequestExecutor(requestExec);
        return this;
    }

    @FluentSetter
    public RestClientBuilder sslHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.httpClientBuilder.setSSLHostnameVerifier(hostnameVerifier);
        return this;
    }

    @FluentSetter
    public RestClientBuilder publicSuffixMatcher(PublicSuffixMatcher publicSuffixMatcher) {
        this.httpClientBuilder.setPublicSuffixMatcher(publicSuffixMatcher);
        return this;
    }

    @FluentSetter
    public RestClientBuilder sslContext(SSLContext sslContext) {
        this.httpClientBuilder.setSSLContext(sslContext);
        return this;
    }

    @FluentSetter
    public RestClientBuilder sslSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
        this.httpClientBuilder.setSSLSocketFactory(sslSocketFactory);
        return this;
    }

    @FluentSetter
    public RestClientBuilder maxConnTotal(int maxConnTotal) {
        this.httpClientBuilder.setMaxConnTotal(maxConnTotal);
        return this;
    }

    @FluentSetter
    public RestClientBuilder maxConnPerRoute(int maxConnPerRoute) {
        this.httpClientBuilder.setMaxConnPerRoute(maxConnPerRoute);
        return this;
    }

    @FluentSetter
    public RestClientBuilder defaultSocketConfig(SocketConfig config) {
        this.httpClientBuilder.setDefaultSocketConfig(config);
        return this;
    }

    @FluentSetter
    public RestClientBuilder defaultConnectionConfig(ConnectionConfig config) {
        this.httpClientBuilder.setDefaultConnectionConfig(config);
        return this;
    }

    @FluentSetter
    public RestClientBuilder connectionTimeToLive(long connTimeToLive, TimeUnit connTimeToLiveTimeUnit) {
        this.httpClientBuilder.setConnectionTimeToLive(connTimeToLive, connTimeToLiveTimeUnit);
        return this;
    }

    @FluentSetter
    public RestClientBuilder connectionManager(HttpClientConnectionManager connManager) {
        this.httpClientConnectionManager = connManager;
        this.httpClientBuilder.setConnectionManager(connManager);
        return this;
    }

    @FluentSetter
    public RestClientBuilder connectionManagerShared(boolean shared) {
        this.httpClientBuilder.setConnectionManagerShared(shared);
        return this;
    }

    @FluentSetter
    public RestClientBuilder connectionReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
        this.httpClientBuilder.setConnectionReuseStrategy(reuseStrategy);
        return this;
    }

    @FluentSetter
    public RestClientBuilder keepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
        this.httpClientBuilder.setKeepAliveStrategy(keepAliveStrategy);
        return this;
    }

    @FluentSetter
    public RestClientBuilder targetAuthenticationStrategy(AuthenticationStrategy targetAuthStrategy) {
        this.httpClientBuilder.setTargetAuthenticationStrategy(targetAuthStrategy);
        return this;
    }

    @FluentSetter
    public RestClientBuilder proxyAuthenticationStrategy(AuthenticationStrategy proxyAuthStrategy) {
        this.httpClientBuilder.setProxyAuthenticationStrategy(proxyAuthStrategy);
        return this;
    }

    @FluentSetter
    public RestClientBuilder userTokenHandler(UserTokenHandler userTokenHandler) {
        this.httpClientBuilder.setUserTokenHandler(userTokenHandler);
        return this;
    }

    @FluentSetter
    public RestClientBuilder disableConnectionState() {
        this.httpClientBuilder.disableConnectionState();
        return this;
    }

    @FluentSetter
    public RestClientBuilder schemePortResolver(SchemePortResolver schemePortResolver) {
        this.httpClientBuilder.setSchemePortResolver(schemePortResolver);
        return this;
    }

    @FluentSetter
    public RestClientBuilder userAgent(String userAgent) {
        this.httpClientBuilder.setUserAgent(userAgent);
        return this;
    }

    @FluentSetter
    public RestClientBuilder defaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.httpClientBuilder.setDefaultHeaders(defaultHeaders);
        return this;
    }

    @FluentSetter
    public RestClientBuilder addInterceptorFirst(HttpResponseInterceptor itcp) {
        this.httpClientBuilder.addInterceptorFirst(itcp);
        return this;
    }

    @FluentSetter
    public RestClientBuilder addInterceptorLast(HttpResponseInterceptor itcp) {
        this.httpClientBuilder.addInterceptorLast(itcp);
        return this;
    }

    @FluentSetter
    public RestClientBuilder addInterceptorFirst(HttpRequestInterceptor itcp) {
        this.httpClientBuilder.addInterceptorFirst(itcp);
        return this;
    }

    @FluentSetter
    public RestClientBuilder addInterceptorLast(HttpRequestInterceptor itcp) {
        this.httpClientBuilder.addInterceptorLast(itcp);
        return this;
    }

    @FluentSetter
    public RestClientBuilder disableCookieManagement() {
        this.httpClientBuilder.disableCookieManagement();
        return this;
    }

    @FluentSetter
    public RestClientBuilder disableContentCompression() {
        this.httpClientBuilder.disableContentCompression();
        return this;
    }

    @FluentSetter
    public RestClientBuilder disableAuthCaching() {
        this.httpClientBuilder.disableAuthCaching();
        return this;
    }

    @FluentSetter
    public RestClientBuilder httpProcessor(HttpProcessor httpprocessor) {
        this.httpClientBuilder.setHttpProcessor(httpprocessor);
        return this;
    }

    @FluentSetter
    public RestClientBuilder retryHandler(HttpRequestRetryHandler retryHandler) {
        this.httpClientBuilder.setRetryHandler(retryHandler);
        return this;
    }

    @FluentSetter
    public RestClientBuilder disableAutomaticRetries() {
        this.httpClientBuilder.disableAutomaticRetries();
        return this;
    }

    @FluentSetter
    public RestClientBuilder proxy(HttpHost proxy) {
        this.httpClientBuilder.setProxy(proxy);
        return this;
    }

    @FluentSetter
    public RestClientBuilder routePlanner(HttpRoutePlanner routePlanner) {
        this.httpClientBuilder.setRoutePlanner(routePlanner);
        return this;
    }

    @FluentSetter
    public RestClientBuilder connectionBackoffStrategy(ConnectionBackoffStrategy connectionBackoffStrategy) {
        this.httpClientBuilder.setConnectionBackoffStrategy(connectionBackoffStrategy);
        return this;
    }

    @FluentSetter
    public RestClientBuilder backoffManager(BackoffManager backoffManager) {
        this.httpClientBuilder.setBackoffManager(backoffManager);
        return this;
    }

    @FluentSetter
    public RestClientBuilder serviceUnavailableRetryStrategy(ServiceUnavailableRetryStrategy serviceUnavailStrategy) {
        this.httpClientBuilder.setServiceUnavailableRetryStrategy(serviceUnavailStrategy);
        return this;
    }

    @FluentSetter
    public RestClientBuilder defaultCookieStore(CookieStore cookieStore) {
        this.httpClientBuilder.setDefaultCookieStore(cookieStore);
        return this;
    }

    @FluentSetter
    public RestClientBuilder defaultCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        return this;
    }

    @FluentSetter
    public RestClientBuilder defaultAuthSchemeRegistry(Lookup<AuthSchemeProvider> authSchemeRegistry) {
        this.httpClientBuilder.setDefaultAuthSchemeRegistry(authSchemeRegistry);
        return this;
    }

    @FluentSetter
    public RestClientBuilder contentDecoderRegistry(Map<String, InputStreamFactory> contentDecoderMap) {
        this.httpClientBuilder.setContentDecoderRegistry(contentDecoderMap);
        return this;
    }

    @FluentSetter
    public RestClientBuilder defaultRequestConfig(RequestConfig config) {
        this.httpClientBuilder.setDefaultRequestConfig(config);
        return this;
    }

    @FluentSetter
    public RestClientBuilder useSystemProperties() {
        this.httpClientBuilder.useSystemProperties();
        return this;
    }

    @FluentSetter
    public RestClientBuilder evictExpiredConnections() {
        this.httpClientBuilder.evictExpiredConnections();
        return this;
    }

    @FluentSetter
    public RestClientBuilder evictIdleConnections(long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.httpClientBuilder.evictIdleConnections(maxIdleTime, maxIdleTimeUnit);
        return this;
    }

    private static Map<Object, Object> toMap(Object o) {
        return (Map)o;
    }

    private static SerializedNameValuePair serializedNameValuePair(Object key, Object value, HttpPartType type, HttpPartSerializer serializer, HttpPartSchema schema) {
        return key == null ? null : SerializedNameValuePair.of(StringUtils.stringify(key), value).type(type).serializer(serializer).schema(schema);
    }

    private static SerializedHeader serializedHeader(Object key, Object value, HttpPartSerializer serializer, HttpPartSchema schema) {
        return key == null ? null : SerializedHeader.of(StringUtils.stringify(key), value).serializer(serializer).schema(schema);
    }
}

