/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.UriResolver;
import org.apache.juneau.config.Config;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.http.BasicHttpResource;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.StringRange;
import org.apache.juneau.http.StringRanges;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.http.exception.UnsupportedMediaType;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.RequestBeanMeta;
import org.apache.juneau.httppart.bean.RequestBeanPropertyMeta;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.RequestAttributes;
import org.apache.juneau.rest.RequestBody;
import org.apache.juneau.rest.RequestFormData;
import org.apache.juneau.rest.RequestHeaders;
import org.apache.juneau.rest.RequestPath;
import org.apache.juneau.rest.RequestProperties;
import org.apache.juneau.rest.RequestQuery;
import org.apache.juneau.rest.ResponsePartMeta;
import org.apache.juneau.rest.RestCall;
import org.apache.juneau.rest.RestCallLogger;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestMethodContext;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.util.CachingHttpServletRequest;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;

public final class RestRequest
extends HttpServletRequestWrapper {
    private HttpServletRequest inner;
    private final RestContext context;
    private RestMethodContext restJavaMethod;
    private final String method;
    private RequestBody body;
    private Method javaMethod;
    private RequestProperties properties;
    private BeanSession beanSession;
    private VarResolverSession varSession;
    private final RequestQuery queryParams;
    private RequestFormData formData;
    private RequestPath pathParams;
    private boolean isPost;
    private UriContext uriContext;
    private String charset;
    private String authorityPath;
    private RequestHeaders headers;
    private RequestAttributes attrs;
    private Config cf;
    private Swagger swagger;
    private SerializerSessionArgs serializerSessionArgs;
    private ParserSessionArgs parserSessionArgs;
    private RestResponse res;
    private HttpPartSerializerSession partSerializerSession;
    private HttpPartParserSession partParserSession;
    private final RestCall call;

    RestRequest(RestCall call) throws ServletException {
        super(call.getRequest());
        HttpServletRequest req;
        this.inner = req = call.getRequest();
        call.restRequest(this);
        this.context = call.getContext();
        this.call = call;
        try {
            String b;
            Set<String> s;
            this.isPost = req.getMethod().equalsIgnoreCase("POST");
            this.queryParams = new RequestQuery(this);
            if (this.isPost) {
                RestUtils.parseQuery(this.getQueryString(), this.queryParams);
            } else {
                this.queryParams.putAll(req.getParameterMap());
            }
            String _method = super.getMethod();
            String m = this.getQuery().getString("method");
            if (m != null && !(s = this.context.getAllowedMethodParams()).isEmpty() && (s.contains("*") || s.contains(m))) {
                _method = m;
            }
            if ((m = req.getHeader("X-Method")) != null && !(s = this.context.getAllowedMethodHeaders()).isEmpty() && (s.contains("*") || s.contains(m))) {
                _method = m;
            }
            this.method = _method;
            this.headers = new RequestHeaders(this);
            Enumeration e = this.getHeaderNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.headers.put(name, super.getHeaders(name));
            }
            this.body = new RequestBody(this);
            if (this.context.isAllowBodyParam() && (b = this.getQuery().getString("body")) != null) {
                this.headers.put("Content-Type", UonSerializer.DEFAULT.getResponseContentType());
                this.body.load(MediaType.UON, UonParser.DEFAULT, b.getBytes(IOUtils.UTF8));
            }
            if (!(s = this.context.getAllowedHeaderParams()).isEmpty()) {
                this.headers.queryParams(this.queryParams, s);
            }
            this.pathParams = new RequestPath(call);
        }
        catch (Exception e) {
            throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
        }
    }

    final void init(RestMethodContext rjm, RequestProperties properties) throws IOException {
        String stylesheet;
        this.restJavaMethod = rjm;
        this.javaMethod = rjm.method;
        this.properties = properties;
        this.beanSession = rjm.createSession();
        this.partParserSession = rjm.partParser.createPartSession(this.getParserSessionArgs());
        this.partSerializerSession = rjm.partSerializer.createPartSession(this.getSerializerSessionArgs());
        this.pathParams.parser(this.partParserSession);
        this.queryParams.addDefault(rjm.defaultQuery).parser(this.partParserSession);
        this.headers.addDefault(rjm.reqHeaders).addDefault(this.context.getReqHeaders()).parser(this.partParserSession);
        this.attrs = new RequestAttributes(this, rjm.reqAttrs);
        this.body.encoders(rjm.encoders).parsers(rjm.parsers).headers(this.headers).maxInput(rjm.maxInput);
        if (this.isDebug()) {
            this.inner = CachingHttpServletRequest.wrap(this.inner);
        }
        if ((stylesheet = this.getQuery().getString("stylesheet")) != null) {
            this.getSession().setAttribute("HtmlDocSerializer.stylesheet.ls", (Object)stylesheet.replace(' ', '$'));
        }
        if ((stylesheet = (String)this.getSession().getAttribute("stylesheet")) != null) {
            properties.put("HtmlDocSerializer.stylesheet.ls", new String[]{stylesheet});
        }
    }

    RestRequest setResponse(RestResponse res) {
        this.res = res;
        return this;
    }

    public String getDescription() {
        String qs = this.getQueryString();
        return "HTTP " + this.getMethod() + " " + this.getRequestURI() + (qs == null ? "" : "?" + qs);
    }

    @Deprecated
    public RequestProperties getProperties() {
        return this.properties;
    }

    @Deprecated
    public RestRequest prop(String name, Object value) {
        this.properties.append(name, value);
        return this;
    }

    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.getHeaders().getString(name);
    }

    public Enumeration<String> getHeaders(String name) {
        String[] v = (String[])this.headers.get(name);
        if (v == null || v.length == 0) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(Arrays.asList(v));
    }

    public List<MediaType> getProduces() {
        return this.restJavaMethod == null ? Collections.emptyList() : this.restJavaMethod.supportedAcceptTypes;
    }

    public List<MediaType> getConsumes() {
        return this.restJavaMethod == null ? Collections.emptyList() : this.restJavaMethod.supportedContentTypes;
    }

    public PropertyStore getPropertyStore() {
        return this.restJavaMethod == null ? PropertyStore.DEFAULT : this.restJavaMethod.getPropertyStore();
    }

    public void setCharacterEncoding(String charset) {
        this.charset = charset;
    }

    public String getCharacterEncoding() throws UnsupportedMediaType {
        if (this.charset == null) {
            int i;
            String h = this.getHeader("Content-Type");
            if (h != null && (i = h.indexOf(";charset=")) > 0) {
                this.charset = h.substring(i + 9).trim();
            }
            if (this.charset == null && this.restJavaMethod != null) {
                this.charset = this.restJavaMethod.defaultCharset;
            }
            if (this.charset == null) {
                this.charset = "UTF-8";
            }
            if (!Charset.isSupported(this.charset)) {
                throw new UnsupportedMediaType("Unsupported charset in header ''Content-Type'': ''{0}''", h);
            }
        }
        return this.charset;
    }

    public Charset getCharset() {
        String s = this.getCharacterEncoding();
        return s == null ? null : Charset.forName(s);
    }

    public Locale getLocale() {
        Locale best = super.getLocale();
        String h = this.headers.getString("Accept-Language");
        if (h != null) {
            StringRanges sr = StringRanges.of(h);
            float qValue = 0.0f;
            for (StringRange r : sr.getRanges()) {
                if (!(r.getQValue().floatValue() > qValue)) continue;
                best = RestRequest.toLocale(r.getName());
                qValue = r.getQValue().floatValue();
            }
        }
        return best;
    }

    public Enumeration<Locale> getLocales() {
        StringRanges mr;
        String h = this.headers.getString("Accept-Language");
        if (h != null && !(mr = StringRanges.of(h)).getRanges().isEmpty()) {
            ArrayList<Locale> l = new ArrayList<Locale>(mr.getRanges().size());
            for (StringRange r : mr.getRanges()) {
                if (!(r.getQValue().floatValue() > 0.0f)) continue;
                l.add(RestRequest.toLocale(r.getName()));
            }
            return Collections.enumeration(l);
        }
        return super.getLocales();
    }

    public RequestAttributes getAttributes() {
        return this.attrs;
    }

    public Object getAttribute(String name, Object def) {
        Object o = super.getAttribute(name);
        return o == null ? def : o;
    }

    public RestRequest attr(String name, Object value) {
        this.setAttribute(name, value);
        return this;
    }

    public RequestQuery getQuery() {
        return this.queryParams;
    }

    public String getQuery(String name) {
        return this.getQuery().getString(name);
    }

    public RequestFormData getFormData() throws InternalServerError {
        try {
            if (this.formData == null) {
                this.formData = new RequestFormData(this, this.getPartParser());
                if (!this.body.isLoaded()) {
                    this.formData.putAll(this.getParameterMap());
                } else {
                    Map<String, String[]> m = RestUtils.parseQuery(this.body.getReader());
                    for (Map.Entry<String, String[]> e : m.entrySet()) {
                        for (String v : e.getValue()) {
                            this.formData.put(e.getKey(), v);
                        }
                    }
                }
            }
            this.formData.addDefault(this.restJavaMethod == null ? null : this.restJavaMethod.defaultFormData);
            return this.formData;
        }
        catch (Exception e) {
            throw new InternalServerError(e);
        }
    }

    public String getFormData(String name) {
        return this.getFormData().getString(name);
    }

    public RequestPath getPathMatch() {
        return this.pathParams;
    }

    public String getPath(String name) {
        return (String)this.getPathMatch().get(name);
    }

    public String getPathRemainder() {
        return this.getPathMatch().getRemainder();
    }

    public RequestBody getBody() {
        return this.body;
    }

    public BufferedReader getReader() throws IOException {
        return this.getBody().getReader();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.getBody().getInputStream();
    }

    ServletInputStream getRawInputStream() throws IOException {
        return this.inner.getInputStream();
    }

    public String getContextPath() {
        String cp = this.context.getUriContext();
        return cp == null ? super.getContextPath() : cp;
    }

    public String getAuthorityPath() {
        if (this.authorityPath == null) {
            this.authorityPath = this.context.getUriAuthority();
        }
        if (this.authorityPath == null) {
            String scheme = this.getScheme();
            int port = this.getServerPort();
            StringBuilder sb = new StringBuilder(this.getScheme()).append("://").append(this.getServerName());
            if (!(port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme))) {
                sb.append(':').append(port);
            }
            this.authorityPath = sb.toString();
        }
        return this.authorityPath;
    }

    public String getServletPath() {
        String cp = this.context.getUriContext();
        String sp = super.getServletPath();
        return cp == null || !sp.startsWith(cp) ? sp : sp.substring(cp.length());
    }

    public UriContext getUriContext() {
        if (this.uriContext == null) {
            this.uriContext = UriContext.of(this.getAuthorityPath(), this.getContextPath(), this.getServletPath(), StringUtils.urlEncodePath(super.getPathInfo()));
        }
        return this.uriContext;
    }

    public UriResolver getUriResolver(UriResolution resolution, UriRelativity relativity) {
        return UriResolver.of(resolution, relativity, this.getUriContext());
    }

    public UriResolver getUriResolver() {
        return UriResolver.of(this.context.getUriResolution(), this.context.getUriRelativity(), this.getUriContext());
    }

    public URI getUri(boolean includeQuery, Map<String, ?> addQueryParams) {
        String uri = this.getRequestURI();
        if (includeQuery || addQueryParams != null) {
            StringBuilder sb = new StringBuilder(uri);
            RequestQuery rq = this.queryParams.copy();
            if (addQueryParams != null) {
                for (Map.Entry<String, ?> e : addQueryParams.entrySet()) {
                    rq.put(e.getKey(), e.getValue());
                }
            }
            if (!rq.isEmpty()) {
                sb.append('?').append(rq.asQueryString());
            }
            uri = sb.toString();
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public RestInfoProvider getInfoProvider() {
        return this.context.getInfoProvider();
    }

    public Swagger getSwagger() {
        try {
            if (this.swagger == null) {
                this.swagger = this.context.getInfoProvider().getSwagger(this);
            }
            return this.swagger;
        }
        catch (Exception e) {
            throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
        }
    }

    public String getSiteName() {
        try {
            return this.context.getInfoProvider().getSiteName(this);
        }
        catch (Exception e) {
            throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
        }
    }

    public String getResourceTitle() {
        try {
            return this.context.getInfoProvider().getTitle(this);
        }
        catch (Exception e) {
            throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
        }
    }

    public String getResourceDescription() {
        try {
            return this.context.getInfoProvider().getDescription(this);
        }
        catch (Exception e) {
            throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
        }
    }

    public String getMethodSummary() {
        try {
            return this.context.getInfoProvider().getMethodSummary(this.javaMethod, this);
        }
        catch (Exception e) {
            throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
        }
    }

    public String getMethodDescription() {
        try {
            return this.context.getInfoProvider().getMethodDescription(this.javaMethod, this);
        }
        catch (Exception e) {
            throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
        }
    }

    public SerializerGroup getSerializers() {
        return this.restJavaMethod == null ? SerializerGroup.EMPTY : this.restJavaMethod.serializers;
    }

    public ParserGroup getParsers() {
        return this.restJavaMethod == null ? ParserGroup.EMPTY : this.restJavaMethod.parsers;
    }

    public HttpPartParserSession getPartParser() {
        return this.partParserSession == null ? OpenApiParser.DEFAULT.createPartSession(null) : this.partParserSession;
    }

    public HttpPartSerializerSession getPartSerializer() {
        return this.partSerializerSession == null ? OpenApiSerializer.DEFAULT.createPartSession(null) : this.partSerializerSession;
    }

    public String getMethod() {
        return this.method;
    }

    public int getContentLength() {
        return this.getBody().getContentLength();
    }

    int getRawContentLength() {
        return super.getContentLength();
    }

    public boolean isPlainText() {
        return "true".equals(this.getQuery().getString("plainText", "false"));
    }

    public Messages getMessages() {
        return this.context.getMessages().forLocale(this.getLocale());
    }

    public String getMessage(String key, Object ... args) {
        return this.getMessages().getString(key, args);
    }

    public RestContext getContext() {
        return this.context;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public BeanSession getBeanSession() {
        if (this.beanSession == null) {
            this.beanSession = this.context.createBeanSession();
        }
        return this.beanSession;
    }

    public boolean isDebug() {
        Boolean b = ObjectUtils.castOrNull(this.getAttribute("Debug"), Boolean.class);
        return b == null ? false : b;
    }

    public RestRequest setException(Throwable t) {
        this.setAttribute("Exception", t);
        return this;
    }

    public RestRequest setNoTrace(Boolean b) {
        this.setAttribute("NoTrace", b);
        return this;
    }

    public RestRequest setNoTrace() {
        return this.setNoTrace(true);
    }

    public RestRequest setDebug(Boolean b) throws IOException {
        this.setAttribute("Debug", b);
        if (b.booleanValue()) {
            this.inner = CachingHttpServletRequest.wrap(this.inner);
        }
        return this;
    }

    public RestRequest setDebug() throws IOException {
        return this.setDebug(true);
    }

    public VarResolverSession getVarResolverSession() {
        if (this.varSession == null) {
            this.varSession = this.context.getVarResolver().createSession(this.context.getSessionObjects(this.call)).sessionObject("req", (Object)this).sessionObject("res", (Object)this.res);
        }
        return this.varSession;
    }

    public BasicHttpResource getClasspathHttpResource(String name, boolean resolveVars, MediaType mediaType, boolean cached) throws IOException {
        String s = this.context.getClasspathResourceAsString(name, this.getLocale());
        if (s == null) {
            return null;
        }
        BasicHttpResource b = BasicHttpResource.of(() -> resolveVars ? this.getVarResolverSession().resolve(s) : s).contentType(mediaType == null ? null : ContentType.of(mediaType.toString()));
        if (cached) {
            b.cache();
        }
        return b;
    }

    public String getClasspathResourceAsString(String name) throws IOException {
        return this.getClasspathResourceAsString(name, false);
    }

    public String getClasspathResourceAsString(String name, boolean resolveVars) throws IOException {
        String s = this.context.getClasspathResourceAsString(name, this.getLocale());
        if (resolveVars) {
            return this.varSession.resolve(s);
        }
        return s;
    }

    public BasicHttpResource getClasspathHttpResource(String name, boolean resolveVars) throws IOException {
        return this.getClasspathHttpResource(name, resolveVars, MediaType.of(this.context.getMediaTypeForName(name)), false);
    }

    public BasicHttpResource getClasspathHttpResource(String name) throws IOException {
        return this.getClasspathHttpResource(name, false, MediaType.of(this.context.getMediaTypeForName(name)), false);
    }

    public Config getConfig() {
        if (this.cf == null) {
            this.cf = this.context.getConfig().resolving(this.getVarResolverSession());
        }
        return this.cf;
    }

    @Deprecated
    public Map<String, Widget> getWidgets() {
        return this.restJavaMethod == null ? Collections.emptyMap() : this.restJavaMethod.widgets;
    }

    public <T> T getRequest(Class<T> c) {
        return this.getRequest(RequestBeanMeta.create(c, this.getContext().getPropertyStore()));
    }

    public <T> T getRequest(final RequestBeanMeta rbm) {
        try {
            Class<?> c = rbm.getClassMeta().getInnerClass();
            BeanMeta<?> bm = this.getBeanSession().getBeanMeta(c);
            return (T)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    RequestBeanPropertyMeta pm = rbm.getProperty(method.getName());
                    if (pm != null) {
                        HttpPartParserSession pp = pm.getParser(RestRequest.this.getPartParser());
                        HttpPartSchema schema = pm.getSchema();
                        String name = pm.getPartName();
                        ClassMeta type = RestRequest.this.getContext().getClassMeta(method.getGenericReturnType(), new Type[0]);
                        HttpPartType pt = pm.getPartType();
                        if (pt == HttpPartType.BODY) {
                            return RestRequest.this.getBody().schema(schema).asType(type, new Type[0]);
                        }
                        if (pt == HttpPartType.QUERY) {
                            return RestRequest.this.getQuery().get(pp, schema, name, type, new Type[0]);
                        }
                        if (pt == HttpPartType.FORMDATA) {
                            return RestRequest.this.getFormData().get(pp, schema, name, type, new Type[0]);
                        }
                        if (pt == HttpPartType.HEADER) {
                            return RestRequest.this.getHeaders().get(pp, schema, name, type, new Type[0]);
                        }
                        if (pt == HttpPartType.PATH) {
                            return RestRequest.this.getPathMatch().get(pp, schema, name, type, new Type[0]);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n").append(this.getDescription()).append("\n");
        sb.append("---Headers---\n");
        Enumeration e = this.getHeaderNames();
        while (e.hasMoreElements()) {
            String string = (String)e.nextElement();
            sb.append("\t").append(string).append(": ").append(this.getHeader(string)).append("\n");
        }
        sb.append("---Default Servlet Headers---\n");
        for (Map.Entry entry : this.context.getReqHeaders().entrySet()) {
            sb.append("\t").append((String)entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        if (this.javaMethod == null) {
            sb.append("***init() not called yet!***\n");
        } else if (this.method.equals("PUT") || this.method.equals("POST")) {
            try {
                sb.append("---Body UTF-8---\n");
                sb.append(this.body.asString()).append("\n");
                sb.append("---Body Hex---\n");
                sb.append(this.body.asSpacedHex()).append("\n");
            }
            catch (Exception e1) {
                sb.append(e1.getLocalizedMessage());
            }
        }
        return sb.toString();
    }

    public SerializerSessionArgs getSerializerSessionArgs() {
        if (this.serializerSessionArgs == null) {
            this.serializerSessionArgs = SerializerSessionArgs.create().properties(this.getProperties()).javaMethod(this.getJavaMethod()).locale(this.getLocale()).timeZone(this.getHeaders().getTimeZone()).debug(this.isDebug() ? Boolean.valueOf(true) : null).uriContext(this.getUriContext()).resolver(this.getVarResolverSession()).useWhitespace(this.isPlainText() ? Boolean.valueOf(true) : null);
        }
        return this.serializerSessionArgs;
    }

    public ParserSessionArgs getParserSessionArgs() {
        if (this.parserSessionArgs == null) {
            this.parserSessionArgs = ParserSessionArgs.create().properties(this.getProperties()).javaMethod(this.getJavaMethod()).locale(this.getLocale()).timeZone(this.getHeaders().getTimeZone()).debug(this.isDebug() ? Boolean.valueOf(true) : null);
        }
        return this.parserSessionArgs;
    }

    @Deprecated
    public RestCallLogger getLogger() {
        return null;
    }

    public RestCallLoggerConfig getCallLoggerConfig() {
        if (this.restJavaMethod != null) {
            return this.restJavaMethod.getCallLoggerConfig();
        }
        return RestCallLoggerConfig.DEFAULT_NOOP;
    }

    void close() {
        if (this.cf != null) {
            try {
                this.cf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ResponseBeanMeta getResponseBeanMeta(Object o) {
        return this.restJavaMethod == null ? this.context.getResponseBeanMeta(o) : this.restJavaMethod.getResponseBeanMeta(o);
    }

    public ResponsePartMeta getResponseHeaderMeta(Object o) {
        return this.restJavaMethod == null ? null : this.restJavaMethod.getResponseHeaderMeta(o);
    }

    public ResponsePartMeta getResponseBodyMeta(Object o) {
        return this.restJavaMethod == null ? null : this.restJavaMethod.getResponseBodyMeta(o);
    }

    public JsonSchemaGenerator getJsonSchemaGenerator() {
        return this.restJavaMethod == null ? this.context.getJsonSchemaGenerator() : this.restJavaMethod.getJsonSchemaGenerator();
    }

    protected HttpServletRequest getInner() {
        return this.inner;
    }

    <T> ClassMeta<T> getClassMeta(Type type, Type[] args) {
        return this.beanSession.getClassMeta(type, args);
    }

    <T> ClassMeta<T> getClassMeta(Class<T> type) {
        return this.beanSession.getClassMeta(type);
    }

    private static Locale toLocale(String lang) {
        String country = "";
        int i = lang.indexOf(45);
        if (i > -1) {
            country = lang.substring(i + 1).trim();
            lang = lang.substring(0, i).trim();
        }
        return new Locale(lang, country);
    }

    void setJavaMethod(Method method) {
        this.javaMethod = method;
    }
}

