/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.cp.BasicResourceFinder;
import org.apache.juneau.cp.ResourceFinder;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.BasicRestCallLogger;
import org.apache.juneau.rest.BasicRestInfoProvider;
import org.apache.juneau.rest.BasicRestMethods;
import org.apache.juneau.rest.BasicRestResourceResolver;
import org.apache.juneau.rest.RestCallLogger;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestContextBuilder;
import org.apache.juneau.rest.RestContextStats;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestHook;
import org.apache.juneau.rest.config.BasicUniversalRest;

@Rest(allowedMethodParams="OPTIONS")
@HtmlDocConfig(navlinks={"up: request:/..", "options: servlet:/?method=OPTIONS", "stats: servlet:/stats"})
public abstract class BasicRest
implements BasicUniversalRest,
BasicRestMethods,
RestInfoProvider,
RestCallLogger,
RestResourceResolver,
ResourceFinder {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private volatile RestContext context;
    private RestInfoProvider infoProvider;
    private RestCallLogger callLogger;
    private ResourceFinder resourceFinder;
    private RestResourceResolver resourceResolver = new BasicRestResourceResolver();

    @Override
    public Swagger getOptions(RestRequest req) {
        return req.getSwagger();
    }

    @Override
    public Swagger getOptions2(RestRequest req) {
        return req.getSwagger();
    }

    @Override
    public void error() {
    }

    @Override
    public RestContextStats getStats(RestRequest req) {
        return req.getContext().getStats();
    }

    protected synchronized RestContext getContext() {
        if (this.context == null) {
            throw new InternalServerError("RestContext object not set on resource.");
        }
        return this.context;
    }

    public void log(String msg) {
        this.doLog(Level.INFO, null, () -> msg);
    }

    public void log(String msg, Throwable cause) {
        this.doLog(Level.INFO, null, () -> msg);
    }

    public void log(Level level, String msg, Object ... args) {
        this.doLog(level, null, () -> StringUtils.format(msg, args));
    }

    public void log(Level level, Throwable cause, String msg, Object ... args) {
        this.doLog(level, cause, () -> StringUtils.format(msg, args));
    }

    protected void doLog(Level level, Throwable cause, Supplier<String> msg) {
        this.logger.log(level, cause, msg);
    }

    @RestHook(value=HookEvent.INIT)
    public void onInit(RestContextBuilder builder) throws Exception {
    }

    @RestHook(value=HookEvent.POST_INIT)
    public void onPostInit(RestContext context) throws Exception {
        this.context = context;
        this.infoProvider = new BasicRestInfoProvider(context);
        this.callLogger = new BasicRestCallLogger(context);
        this.resourceFinder = new BasicResourceFinder();
    }

    @RestHook(value=HookEvent.POST_INIT_CHILD_FIRST)
    public void onPostInitChildFirst(RestContext context) throws Exception {
    }

    @RestHook(value=HookEvent.DESTROY)
    public void onDestroy(RestContext context) throws Exception {
    }

    @RestHook(value=HookEvent.START_CALL)
    public void onStartCall(HttpServletRequest req, HttpServletResponse res) throws Exception {
    }

    @RestHook(value=HookEvent.PRE_CALL)
    public void onPreCall(RestRequest req, RestResponse res) throws Exception {
    }

    @RestHook(value=HookEvent.POST_CALL)
    public void onPostCall(RestRequest req, RestResponse res) throws Exception {
    }

    @RestHook(value=HookEvent.END_CALL)
    public void onEndCall(HttpServletRequest req, HttpServletResponse res) throws Exception {
    }

    public synchronized RestRequest getRequest() {
        return this.getContext().getRequest();
    }

    public synchronized RestResponse getResponse() {
        return this.getContext().getResponse();
    }

    @Override
    public Swagger getSwagger(RestRequest req) throws Exception {
        return this.infoProvider.getSwagger(req);
    }

    @Override
    public String getSiteName(RestRequest req) throws Exception {
        return this.infoProvider.getSiteName(req);
    }

    @Override
    public String getTitle(RestRequest req) throws Exception {
        return this.infoProvider.getTitle(req);
    }

    @Override
    public String getDescription(RestRequest req) throws Exception {
        return this.infoProvider.getDescription(req);
    }

    @Override
    public String getMethodSummary(Method method, RestRequest req) throws Exception {
        return this.infoProvider.getMethodSummary(method, req);
    }

    @Override
    public String getMethodDescription(Method method, RestRequest req) throws Exception {
        return this.infoProvider.getMethodDescription(method, req);
    }

    @Override
    public void log(RestCallLoggerConfig config, HttpServletRequest req, HttpServletResponse res) {
        this.callLogger.log(config, req, res);
    }

    @Override
    public InputStream findResource(Class<?> baseClass, String name, Locale locale) throws IOException {
        return this.resourceFinder.findResource(baseClass, name, locale);
    }

    @Override
    public <T> T resolve(Object parent, Class<T> c, Object ... args) {
        return this.resourceResolver.resolve(parent, c, args);
    }

    @Override
    public <T> T resolve(Object parent, Class<T> c, RestContextBuilder builder, Object ... args) throws Exception {
        return this.resourceResolver.resolve(parent, c, builder, args);
    }
}

