/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingBeanPropertyMeta;
import org.apache.juneau.urlencoding.UrlEncodingClassMeta;
import org.apache.juneau.urlencoding.UrlEncodingCommon;
import org.apache.juneau.urlencoding.UrlEncodingMetaProvider;
import org.apache.juneau.urlencoding.UrlEncodingSerializerBuilder;
import org.apache.juneau.urlencoding.UrlEncodingSerializerSession;

@ConfigurableContext
public class UrlEncodingSerializer
extends UonSerializer
implements UrlEncodingMetaProvider,
UrlEncodingCommon {
    static final String PREFIX = "UrlEncodingSerializer";
    public static final String URLENC_expandedParams = "UrlEncodingSerializer.expandedParams.b";
    public static final UrlEncodingSerializer DEFAULT = new UrlEncodingSerializer(PropertyStore.DEFAULT);
    public static final UrlEncodingSerializer DEFAULT_PLAINTEXT = new PlainText(PropertyStore.DEFAULT);
    public static final UrlEncodingSerializer DEFAULT_EXPANDED = new Expanded(PropertyStore.DEFAULT);
    public static final UrlEncodingSerializer DEFAULT_READABLE = new Readable(PropertyStore.DEFAULT);
    private final boolean expandedParams;
    private final Map<ClassMeta<?>, UrlEncodingClassMeta> urlEncodingClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, UrlEncodingBeanPropertyMeta> urlEncodingBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, UrlEncodingBeanPropertyMeta>();

    public UrlEncodingSerializer(PropertyStore ps) {
        this(ps, "application/x-www-form-urlencoded", null);
    }

    public UrlEncodingSerializer(PropertyStore ps, String produces, String accept) {
        super(ps.builder().setDefault("UonSerializer.encoding.b", true).build(), produces, accept);
        this.expandedParams = this.getBooleanProperty(URLENC_expandedParams, false);
    }

    @Override
    public UrlEncodingSerializerBuilder builder() {
        return new UrlEncodingSerializerBuilder(this.getPropertyStore());
    }

    public static UrlEncodingSerializerBuilder create() {
        return new UrlEncodingSerializerBuilder();
    }

    @Override
    public UrlEncodingSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public UrlEncodingSerializerSession createSession(SerializerSessionArgs args) {
        return new UrlEncodingSerializerSession(this, null, args);
    }

    @Override
    public UrlEncodingClassMeta getUrlEncodingClassMeta(ClassMeta<?> cm) {
        UrlEncodingClassMeta m = this.urlEncodingClassMetas.get(cm);
        if (m == null) {
            m = new UrlEncodingClassMeta(cm, this);
            this.urlEncodingClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public UrlEncodingBeanPropertyMeta getUrlEncodingBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return UrlEncodingBeanPropertyMeta.DEFAULT;
        }
        UrlEncodingBeanPropertyMeta m = this.urlEncodingBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new UrlEncodingBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.urlEncodingBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    protected final boolean isExpandedParams() {
        return this.expandedParams;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap().a("expandedParams", this.expandedParams));
    }

    public static class PlainText
    extends UrlEncodingSerializer {
        public PlainText(PropertyStore ps) {
            super(ps.builder().setDefault("UonSerializer.paramFormat.s", "PLAINTEXT").build());
        }
    }

    public static class Readable
    extends UrlEncodingSerializer {
        public Readable(PropertyStore ps) {
            super(ps.builder().setDefault("WriterSerializer.useWhitespace.b", true).build());
        }
    }

    public static class Expanded
    extends UrlEncodingSerializer {
        public Expanded(PropertyStore ps) {
            super(ps.builder().setDefault(UrlEncodingSerializer.URLENC_expandedParams, true).build());
        }
    }
}

